<?php

namespace App\Helpers;

class Bbcode
{
    public static function toHtml($text)
    {
        if (!$text) return '';

        $map = [
            '[b]' => '<strong>', '[/b]' => '</strong>',
            '[i]' => '<i>', '[/i]' => '</i>',
            '[u]' => '<u>', '[/u]' => '</u>',
            '[ol]' => '<ol>', '[/ol]' => '</ol>',
            '[ul]' => '<ul>', '[/ul]' => '</ul>',
            '[li]' => '<li>', '[/li]' => '</li>',
        ];

        $html = str_replace(array_keys($map), array_values($map), $text);

        return nl2br($html);
    }
}
