<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Company;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;   // <-- import Str
use Illuminate\Http\Request;

class RegisterController extends Controller
{
    use RegistersUsers;

    protected $redirectTo = '/home';

    public function __construct()
    {
        $this->middleware('guest');
    }

    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name'     => ['required', 'string', 'max:255'],
            'email'    => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }
protected function create(array $data)
{
    // Reuse the UUID from session
    $uuidFromSession = session('company_uuid');

    //dump($uuidFromSession); // Debugging line to check UUID

    $user = User::create([
        'uuid'     => $uuidFromSession, // same UUID as company.c_uuid
        'name'     => $data['name'],
        'email'    => $data['email'],
        'password' => Hash::make($data['password']),
        'type'     => 1, // default for Employer
    ]);

    // Link company to this user
    $companyId = session('company_uuid');

    //dump($companyId); // Debugging line to check company ID

    if ($companyId) {
        $company = Company::find($companyId);
        if ($company) {
            $company->user_id = $user->id; // numeric FK
            $company->save();
        }
    }

    return $user;
}

public function store(Request $request)
    {
        $request->validate([
            'name'     => 'required|string|max:255',
            'email'    => 'required|email|unique:users,email',
            'password' => 'required|min:6|confirmed',
        ]);

    $uuid = Str::uuid()->toString();
        // Create user
        $user = User::create([
            'name'     => $request->name,
            'email'    => $request->email,
            'password' => Hash::make($request->password),
            'uuid'     => $uuid, // Temporary placeholder     
            ]);

        // Auto-login
        auth()->login($user);

        return redirect('/home'); // or wherever you want
    }

}
