<?php

namespace App\Http\Controllers;

use App\Helpers\Bbcode;
use App\Models\JobBoard;
use Illuminate\Container\Attributes\Auth;
use Illuminate\Http\Request;
use App\Models\AdsType;
use App\Models\Transaction;
use Stripe\StripeClient;
use Stripe\Charge;
use Stripe\Stripe;
use App\Models\Question;
use App\Models\Company;
use App\Models\User;
use App\Mail\CandidateNotificationMail;
use Illuminate\Support\Facades\Mail;





class JobBoardController extends Controller
{
    public function index()
    {
        return JobBoard::with('company')->get();
    }

    public function show($id)
    {
        return JobBoard::with('company')->findOrFail($id);
    }





// public function store(Request $request)
// {
//     try {
//         // Validate job fields only
//         $validated = $request->validate([
//             'company_id'        => 'required|exists:companies,id',
//             'ad_type'           => 'required|string',
//             'category'          => 'required|string',
//             'company'           => 'required|string',
//             'description'       => 'nullable|string',
//             'job_title'         => 'nullable|string',
//             'location'          => 'required|string',
//             'workplace'         => 'required|string',
//             'work_type'         => 'required|string',
//             'pay_type'          => 'required|string',
//             'pay_min'           => 'nullable|numeric',
//             'pay_max'           => 'nullable|numeric',
//             'pay_visibility'    => 'boolean',
//             'summary'           => 'nullable|string',
//             'logo'              => 'nullable|string',
//             'overview'          => 'nullable|string',
//             'social_media'      => 'nullable|string',
//             'video'             => 'nullable|string',
//             'ad_rev_status'     => 'nullable|string',
//             'status'            => 'nullable|string',
//             'expiry_date'       => 'nullable|date',
//             'ad_price'          => 'nullable|integer',
//             'ad_duration'       => 'nullable|string',
//             'payment_intent_id' => 'nullable|string',

//             // questions come as KEYS, not IDs
//             // 'questions'         => 'nullable|array',
//         ]);

//         // Create job
//         $job = JobBoard::create($validated);

//         // -----------------------------
//         // PROCESS QUESTIONS
//         // -----------------------------
//         // $questionIds = [];

//         if ($request->questions) { $job->questions()->sync($request->questions); }
//          return response()->json([ 'success' => true, 'job_id' => $job->id ]);


//         // 2. Fetch all candidates (users where type = 0)
//          $candidates = User::where('type', 0) 
//          ->whereNotNull('email') 
//          ->select('name', 'email') 
//          ->get(); 

//          dd($candidates);

//          // 3. Prepare email content 
//          $subject = "New Job Posted: {$job->title}"; 
//          $message = "Hello,\n\nA new job has been posted:\n\n{$job->title}\n\nLog in to apply."; 
//          // 4. Send email to each candidate 
//          foreach ($candidates as $candidate)
//              { Mail::to($candidate->email) 
//                 ->queue(new CandidateNotificationMail($subject, $message)); }

//     } catch (\Exception $e) {
//         return response()->json([
//             'error' => $e->getMessage(),
//             'line'  => $e->getLine(),
//             'file'  => $e->getFile()
//         ], 500);
//     }
// }

public function store(Request $request)
{
    try {
        // Validate job fields only
        $validated = $request->validate([
            'company_id'        => 'required|exists:companies,id',
            'ad_type'           => 'required|string',
            'category'          => 'required|string',
            'company'           => 'required|string',
            'description'       => 'nullable|string',
            'job_title'         => 'nullable|string',
            'location'          => 'required|string',
            'workplace'         => 'required|string',
            'work_type'         => 'required|string',
            'pay_type'          => 'required|string',
            'pay_min'           => 'nullable|numeric',
            'pay_max'           => 'nullable|numeric',
            'pay_visibility'    => 'boolean',
            'summary'           => 'nullable|string',
            'logo'              => 'nullable|string',
            'overview'          => 'nullable|string',
            'social_media'      => 'nullable|string',
            'video'             => 'nullable|string',
            'ad_rev_status'     => 'nullable|string',
            'status'            => 'nullable|string',
            'expiry_date'       => 'nullable|date',
            'ad_price'          => 'nullable|integer',
            'ad_duration'       => 'nullable|string',
            'payment_intent_id' => 'nullable|string',
        ]);

        // Create job
        $job = JobBoard::create($validated);

        // Sync questions
        if ($request->questions) {
            $job->questions()->sync($request->questions);
        }

        
        // SEND EMAIL TO ALL CANDIDATES (type = 0)
    
        $candidates = User::where('type', 0)
            ->whereNotNull('email')
            ->select('name', 'email')
            ->get();

             $description_html = \App\Helpers\Bbcode::toHtml($job->description);

    foreach ($candidates as $candidate) {
    Mail::to($candidate->email)
        ->send(new CandidateNotificationMail($candidate, $job, $description_html));
}


        // Return success AFTER sending emails
        return response()->json([
            'success' => true,
            'job_id'  => $job->id,
            'emails_sent' => $candidates->count()
        ]);

    } catch (\Exception $e) {
        return response()->json([
            'error' => $e->getMessage(),
            'line'  => $e->getLine(),
            'file'  => $e->getFile()
        ], 500);
    }
}





public function update(Request $request, $id)
{
    // Validate incoming request (no need for 'id' in body now)
    $validated = $request->validate([
        'workplace'    => 'nullable|string|max:255',
        'work_type'    => 'nullable|string|max:255',
        'pay_type'     => 'nullable|string|max:255',
        'pay_min'      => 'nullable|numeric',
        'pay_max'      => 'nullable|numeric',
        'description'  => 'nullable|string',
        'summary'      => 'nullable|string',
        'logo'         => 'nullable|string|max:255',
        'social_media' => 'nullable|string|max:255',
        'video'        => 'nullable|string|max:255',
        'overview'     => 'nullable|string',
    ]);

    // Find the job board entry by ID
    $jobBoard = JobBoard::findOrFail($id);

    // Update with validated data
    $jobBoard->update($validated);

    return response()->json([
        'success' => true,
        'message' => 'Job updated successfully',
        'job'     => $jobBoard
    ]);
}



    public function editData($id)
    {
        $job = JobBoard::findOrFail($id);

        if (is_string($job->questions)) {
            $job->questions = json_decode($job->questions, true) ?? [];
        }

        return response()->json($job);
    }


   public function destroy($id)
    {
        $job = JobBoard::findOrFail($id);
        $job->delete();

        return response()->json(['message' => 'Job ad deleted successfully']);
    }

    public function close ($id)
    {
        $job = JobBoard::findOrFail($id);
        $job->status = 'closed';
        $job->save();

        return response()->json(['message' => 'Job ad closed successfully']);
    }



    public function echeckquiz()
{
    // You can redirect, render a view, or perform logic here
       $questions = Question::orderBy('category')->get()->groupBy('category');
    return view('EAdmin.echeck', compact('questions'));
}


public function checkoutView()
{

    return view('EAdmin.checkout');
}

public function processPayment(Request $request)
    {
        try {
            Stripe::setApiKey('sk_test_51RlN3fRdXeSPt59V49EkJyzVBS14E8pEAAps4fNVRLcrpxJPIUlmTd66P0z8KiMvN326bb3QVN0Ktmsadv2XyFjF008u9jgDN0');

            // Get amount from frontend (convert to cents)
            $amount = ((int) $request->input('amount')) * 100;

            $charge = Charge::create([
                'amount' => $amount,
                'currency' => 'aud',
                'source' => $request->input('token'),
                'description' => 'Job Ad Payment',
                'metadata' => [
                    'company_id' => $request->input('company_id'),
                    'company'    => $request->input('company'),
                    'adType'     => $request->input('adType'),
                ],
            ]);

            return response()->json(['success' => true, 'charge_id' => $charge->id]);

        } catch (\Exception $e) {
            return response()->json(['success' => false, 'error' => $e->getMessage()], 500);
        }
    }



// public function checkout(Request $request)
//     {
//         // 1. Get job board and adType from request/mergedData
//         $jobBoard = JobBoard::findOrFail($request->job_board_id);
//         $adType = $jobBoard->ad_type; // or $request->adType

//         // 2. Lookup amount from ads_types table
//         $adsType = AdsType::where('name', $adType)->firstOrFail();
//         $amount = $adsType->amount;

//         // 3. Process payment with Stripe
//         $stripe = new StripeClient(env('STRIPE_SECRET'));

//         $paymentIntent = $stripe->paymentIntents->create([
//             'amount' => intval($amount * 100), // cents
//             'currency' => 'aud',
//             'payment_method' => $request->payment_method_id,
//             'confirm' => true,
//         ]);

//         // 4. Save transaction
//         $transaction = Transaction::create([
//             'job_board_id' => $jobBoard->id,
//             'stripe_id' => $paymentIntent->id,
//             'status' => $paymentIntent->status,
//             'amount' => $amount,
//             'response' => $paymentIntent->toArray(),
//         ]);

//         // 5. Update job board status
//         $jobBoard->update(['ad_rev_status' => 'paid']);

//         return response()->json([
//             'message' => 'Payment successful',
//             'transaction' => $transaction,
//         ]);
//     }




public function processPaymentExt(Request $request)
    {
        try {
           Stripe::setApiKey('sk_test_51RlN3fRdXeSPt59V49EkJyzVBS14E8pEAAps4fNVRLcrpxJPIUlmTd66P0z8KiMvN326bb3QVN0Ktmsadv2XyFjF008u9jgDN0');

            $amount = ((int) $request->input('amount')) * 100;

            $charge = Charge::create([
                'amount' => $amount,
                'currency' => 'aud',
                'source' => $request->input('token'), // card token
                'description' => 'Job Ad Payment',
                'metadata' => [
                    'company_id' => $request->input('company_id'),
                    'company'    => $request->input('company'),
                    'adType'     => $request->input('adType'),
                ],
            ]);

            return response()->json(['success' => true, 'charge_id' => $charge->id]);

        } catch (\Exception $e) {
            return response()->json(['success' => false, 'error' => $e->getMessage()], 500);
        }
    }




public function extend(Request $request, $id)
{
    $request->validate([
        'duration' => 'required|string',
        'ad_type'  => 'required|string',
        'price'    => 'required|numeric'
    ]);

    $job = JobBoard::findOrFail($id);

    // Extract number from duration (e.g. "3_months" → 3)
    preg_match('/(\d+)_/', $request->duration, $matches);
    $amount = isset($matches[1]) ? intval($matches[1]) : 1;

    // Determine if weeks or months
    $isMonthly = str_contains($request->duration, 'month');

    // Calculate new expiry date
    if ($isMonthly) {
        $job->expiry_date = now()->addMonths($amount);
    } else {
        $job->expiry_date = now()->addWeeks($amount);
    }

    // Update ad type if changed
    if ($job->ad_type !== $request->ad_type) {
        $job->ad_type = $request->ad_type;
        $job->ad_price = $request->price;
        $job->status = 'open'; // Reopen the ad if type changes
        $job->ad_duration = $request->duration;
    }

    // Optional: store price history
    // $job->last_extension_price = $request->price;

    $job->save();

    return response()->json([
        'success' => true,
        'message' => 'Job ad extended successfully.',
        'expiry_date' => $job->expiry_date->toDateString(),
        'ad_type' => $job->ad_type
    ]);
}


//get all jobs per category and dispaly them on the category page

// public function swjobsshow()
// {
//     // Retrieve jobs filtered by category and ordered by creation date
//     $jobs = JobBoard::where('category', 'Support Workers')
//         ->orderBy('created_at', 'desc')
//         ->get();
//           foreach ($jobs as $job) {
//             $job->description_html = Bbcode::toHtml($job->description);
//             $job->summary_html     = Bbcode::toHtml($job->summary);
//         }

//     // Return the view with the jobs data
//     return view('swjobs', compact('jobs'));
// }
public function jobs()
{
    $jobs = JobBoard::with('company')
     ->orderByRaw("
            CASE 
                WHEN ad_type = 'platinum' THEN 1
                WHEN ad_type = 'premium' THEN 2
                ELSE 3
            END
        ")
        ->orderBy('created_at', 'desc') // newest inside each tier
        ->paginate(9)
        ->withQueryString();
   
    foreach ($jobs as $job) {
        $job->description_html = Bbcode::toHtml($job->description);
        $job->summary_html     = Bbcode::toHtml($job->summary);
        }
    return view('jobs', compact('jobs'));
}


public function swjobsshow()
{
    $jobs = JobBoard::where('category', 'Support Workers')
        ->orderByRaw("
            CASE 
                WHEN ad_type = 'platinum' THEN 1
                WHEN ad_type = 'premium' THEN 2
                ELSE 3
            END
        ")
        ->orderBy('created_at', 'desc') // newest inside each tier
        ->paginate(9)
        ->withQueryString();

    foreach ($jobs as $job) {
        $job->description_html = Bbcode::toHtml($job->description);
        $job->summary_html     = Bbcode::toHtml($job->summary);
    }

    return view('swjobs', compact('jobs'));
}

public function sswjobsshow()
{
    $jobs = JobBoard::where('category', 'Senior Support Workers')
        ->orderByRaw("
            CASE 
                WHEN ad_type = 'platinum' THEN 1
                WHEN ad_type = 'premium' THEN 2
                ELSE 3
            END
        ")
        ->orderBy('created_at', 'desc') // newest inside each tier
        ->paginate(9)
        ->withQueryString();

    foreach ($jobs as $job) {
        $job->description_html = Bbcode::toHtml($job->description);
        $job->summary_html     = Bbcode::toHtml($job->summary);
    }

    return view('sswjobs', compact('jobs'));
}

public function smjobsshow()
{
    $jobs = JobBoard::where('category', 'Service Managers')
        ->orderByRaw("
            CASE 
                WHEN ad_type = 'platinum' THEN 1
                WHEN ad_type = 'premium' THEN 2
                ELSE 3
            END
        ")
        ->orderBy('created_at', 'desc') // newest inside each tier
        ->paginate(9)
        ->withQueryString();

    foreach ($jobs as $job) {
        $job->description_html = Bbcode::toHtml($job->description);
        $job->summary_html     = Bbcode::toHtml($job->summary);
    }

    return view('smjobs', compact('jobs'));     
}

public function omjobsshow()
{   
    $jobs = JobBoard::where('category', 'Operation Managers')
        ->orderByRaw("
            CASE 
                WHEN ad_type = 'platinum' THEN 1
                WHEN ad_type = 'premium' THEN 2
                ELSE 3
            END
        ")
        ->orderBy('created_at', 'desc') // newest inside each tier
        ->paginate(9)
        ->withQueryString();

    foreach ($jobs as $job) {
        $job->description_html = Bbcode::toHtml($job->description);
        $job->summary_html     = Bbcode::toHtml($job->summary);
    }

    return view('omjobs', compact('jobs'));     
}
public function socialwjobsshow()
{   
    $jobs = JobBoard::where('category', 'Social Workers')
        ->orderByRaw("
            CASE 
                WHEN ad_type = 'platinum' THEN 1
                WHEN ad_type = 'premium' THEN 2
                ELSE 3
            END
        ")
        ->orderBy('created_at', 'desc') // newest inside each tier
        ->paginate(9)
        ->withQueryString();

    foreach ($jobs as $job) {
        $job->description_html = Bbcode::toHtml($job->description);
        $job->summary_html     = Bbcode::toHtml($job->summary);
    }

    return view('socialwjobs', compact('jobs'));     
}

public function amjobsshow()
{   
    $jobs = JobBoard::where('category', 'Administration Officers')
        ->orderByRaw("
            CASE 
                WHEN ad_type = 'platinum' THEN 1
                WHEN ad_type = 'premium' THEN 2
                ELSE 3
            END
        ")
        ->orderBy('created_at', 'desc') // newest inside each tier
        ->paginate(9)
        ->withQueryString();

    foreach ($jobs as $job) {
        $job->description_html = Bbcode::toHtml($job->description);
        $job->summary_html     = Bbcode::toHtml($job->summary);
    }

    return view('amjobs', compact('jobs'));     
}   

public function nursesjobsshow()
{   
    $jobs = JobBoard::where('category', 'Nurses')
        ->orderByRaw("
            CASE 
                WHEN ad_type = 'platinum' THEN 1
                WHEN ad_type = 'premium' THEN 2
                ELSE 3
            END
        ")
        ->orderBy('created_at', 'desc') // newest inside each tier
        ->paginate(9)
        ->withQueryString();

    foreach ($jobs as $job) {
        $job->description_html = Bbcode::toHtml($job->description);
        $job->summary_html     = Bbcode::toHtml($job->summary);
    }

    return view('nursesjobs', compact('jobs'));     
}
public function tmjobsshow()
{   
    $jobs = JobBoard::where('category', 'Team Leaders')
        ->orderByRaw("
            CASE 
                WHEN ad_type = 'platinum' THEN 1
                WHEN ad_type = 'premium' THEN 2
                ELSE 3
            END
        ")
        ->orderBy('created_at', 'desc') // newest inside each tier
        ->paginate(9)
        ->withQueryString();

    foreach ($jobs as $job) {
        $job->description_html = Bbcode::toHtml($job->description);
        $job->summary_html     = Bbcode::toHtml($job->summary);
    }

    return view('tmjobs', compact('jobs'));     
}

public function bmjobsshow()
{   
    $jobs = JobBoard::where('category', 'Business Managers')
        ->orderByRaw("
            CASE 
                WHEN ad_type = 'platinum' THEN 1
                WHEN ad_type = 'premium' THEN 2
                ELSE 3
            END
        ")
        ->orderBy('created_at', 'desc') // newest inside each tier
        ->paginate(9)
        ->withQueryString();

    foreach ($jobs as $job) {
        $job->description_html = Bbcode::toHtml($job->description);
        $job->summary_html     = Bbcode::toHtml($job->summary);
    }

    return view('bmjobs', compact('jobs'));     
}   

}
