<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class InterviewScheduledMail extends Mailable
{
    use Queueable, SerializesModels;

    public $applicant;
    public $sender;
    public $date;
    public $startTime;
    public $endTime;
    public $meetUrl;
    public $description;
    public $startTimeUtc;
    public $endTimeUtc;

    public function __construct(
        $applicant,
        $sender,
        $date,
        $startTime,
        $endTime,
        $meetUrl,
        $description,
        $startTimeUtc,
        $endTimeUtc
    ) {
        $this->applicant = $applicant;
        $this->sender = $sender;
        $this->date = $date;
        $this->startTime = $startTime;
        $this->endTime = $endTime;
        $this->meetUrl = $meetUrl;
        $this->description = $description;
        $this->startTimeUtc = $startTimeUtc;
        $this->endTimeUtc = $endTimeUtc;
    }

    public function build()
    {
        return $this->subject("Interview Scheduled with {$this->sender}")
                    ->view('emails.interview_scheduled');
    }
}



