<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Casts\Attribute;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'type',
        'uuid',
        'google_token',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    /**
     * Interact with the user's first name.
     *
     * @param  string  $value
     * @return \Illuminate\Database\Eloquent\Casts\Attribute
     */
    protected function type(): Attribute
    {
        return new Attribute(
            get: fn ($value) =>  ["user", "admin", "manager"][$value],
        );
    }

//    public function companies()
//{
//    return $this->hasMany(Company::class, 'user_id');
//}

// User.php
    public function company()
    {
        return $this->hasOne(Company::class, 'user_id');
    }

    // app/Models/User.php

public function appliedJobs()
{
    return $this->belongsToMany(JobBoard::class, 'applications')
        ->withPivot(['status'])
        ->withTimestamps();
}

public function savedJobs()
{
    return $this->belongsToMany(JobBoard::class, 'saved_jobs')
        ->withTimestamps();
}


public function defaultTimes()
{
    $times = [];

    for ($hour = 9; $hour <= 17; $hour++) {
        $times[] = sprintf('%02d:00', $hour);
    }

    return $times;
}





}
