<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('questions', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();   // e.g. has_working_rights
            $table->string('label');           // e.g. Do you have working rights?
            $table->string('type');            // boolean, select, number, text
            $table->json('options')->nullable(); // for select dropdowns
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('questions');
    }
};

