<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Question;

class QuestionSeeder extends Seeder
{
    public function run()
    {
        $questions = [

            // -------------------------
            // WORKING RIGHTS
            // -------------------------
            [
                'label' => 'Do you currently have legal working rights in Australia?',
                'type' => 'boolean',
                'options' => null,
                'category' => 'working_rights'
            ],
            [
                'label' => 'What type of visa do you currently hold?',
                'type' => 'text',
                'options' => null,
                'category' => 'working_rights'
            ],
            [
                'label' => 'Can you provide documentation confirming your working rights?',
                'type' => 'boolean',
                'options' => null,
                'category' => 'working_rights'
            ],

            // -------------------------
            // QUALIFICATIONS
            // -------------------------
            [
                'label' => 'What is your highest completed qualification?',
                'type' => 'text',
                'options' => null,
                'category' => 'qualifications'
            ],
            [
                'label' => 'Have you completed any specialised training (e.g. dementia, autism, mental health)?',
                'type' => 'text',
                'options' => null,
                'category' => 'qualifications'
            ],
            [
                'label' => 'Are you professionally registered (AHPRA, ACA, NDIS, etc.)?',
                'type' => 'boolean',
                'options' => null,
                'category' => 'qualifications'
            ],

            // -------------------------
            // FIRST AID & CPR
            // -------------------------
            [
                'label' => 'Do you currently hold a valid First Aid certificate?',
                'type' => 'boolean',
                'options' => null,
                'category' => 'first_aid'
            ],
            [
                'label' => 'Do you currently hold a valid CPR certificate?',
                'type' => 'boolean',
                'options' => null,
                'category' => 'first_aid'
            ],

            // -------------------------
            // DRIVING
            // -------------------------
            [
                'label' => 'Do you hold a valid Australian driver’s licence?',
                'type' => 'boolean',
                'options' => null,
                'category' => 'driving'
            ],
            [
                'label' => 'Do you have access to a reliable vehicle for work?',
                'type' => 'boolean',
                'options' => null,
                'category' => 'driving'
            ],

            // -------------------------
            // CHECKS
            // -------------------------
            [
                'label' => 'Do you have a current National Police Check?',
                'type' => 'boolean',
                'options' => null,
                'category' => 'checks'
            ],
            [
                'label' => 'Do you have a valid NDIS Worker Screening Check?',
                'type' => 'boolean',
                'options' => null,
                'category' => 'checks'
            ],

            // -------------------------
            // EXPERIENCE
            // -------------------------
            [
                'label' => 'How many years of relevant experience do you have?',
                'type' => 'number',
                'options' => null,
                'category' => 'experience'
            ],
            [
                'label' => 'What client groups have you previously supported?',
                'type' => 'text',
                'options' => null,
                'category' => 'experience'
            ],
            [
                'label' => 'Describe a challenging situation you handled and how you resolved it.',
                'type' => 'text',
                'options' => null,
                'category' => 'experience'
            ],

            // -------------------------
            // EMPLOYMENT & SALARY
            // -------------------------
            [
                'label' => 'What type of employment are you seeking?',
                'type' => 'select',
                'options' => json_encode(['Full-time', 'Part-time', 'Casual']),
                'category' => 'employment'
            ],
            [
                'label' => 'What is your expected hourly rate?',
                'type' => 'number',
                'options' => null,
                'category' => 'employment'
            ],
            [
                'label' => 'Please describe your general availability.',
                'type' => 'text',
                'options' => null,
                'category' => 'employment'
            ],
        ];

        foreach ($questions as $q) {
            Question::create($q);
        }
    }
}
