@extends('layouts.admin.adminapp')
@include('components.offcanvas')
@include('components.activejobsoffcanvas'),
@include('components.closedjobsoffcanvas'),
@include('components.expiredjobsoffcanvas'),
@include('components.openjobsoffcanvas'),



<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sceditor@3/minified/themes/default.min.css" />
<script src="https://cdn.jsdelivr.net/npm/sceditor@3/minified/sceditor.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sceditor@3/minified/formats/bbcode.js"></script>

<style>
 
    .dashboard-card {
        background: #ffffff !important;
        border-radius: 20px !important; /* bigger radius */
        border: 1px solid #e5e5e5 !important;
        transition: all 0.25s ease !important;
        cursor: pointer !important;
    }

    /* Hover effect */
    .dashboard-card:hover {
        transform: translateY(-4px) !important;
        border-color: rgb(113,16,62) !important;
        box-shadow: 0 8px 22px rgba(113,16,62,0.18) !important;
    }

    /* Icon styling */
    .dashboard-card .icon-wrapper i {
        color: #6c757d !important;
        transition: color 0.25s ease !important;
    }

    /* Icon hover color */
    .dashboard-card:hover .icon-wrapper i {
        color: rgb(113,16,62) !important;
    }


    /* Light Mode (Default) */
:root {
    --bg-color: #F8F6F8;
    --card-bg: #ffffff;
    --text-color: #333;
    --border-color: #e5e5e5;
    --brand-color: #71103E;
}

/* Dark Mode */
.dark-mode {
    --bg-color: #1e1e1e;
    --card-bg: #2a2a2a;
    --text-color: #f1f1f1;
    --border-color: #444;
    --brand-color: #c94f8a;
}

/* Apply Variables */
body {
    background: var(--bg-color);
    color: var(--text-color);
}

.settings-card {
    background: var(--card-bg) !important;
    border-color: var(--border-color) !important;
}

.settings-title {
    color: var(--brand-color) !important;
}

.btn-save-settings,
.btn-change-logo {
    background: var(--brand-color) !important;
}

.company-logo {
    border-color: var(--border-color) !important;
}

.flash-message {
    position: fixed;
    top: 20px;
    right: 20px;
    padding: 14px 20px;
    border-radius: 6px;
    font-weight: 600;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    z-index: 9999;
    opacity: 1;
    transition: opacity 0.6s ease-out;
}



</style>






@section('content')
<div class="container-fluid py-4">
    <!-- Page Title -->
<div class="d-flex justify-content-between align-items-center mb-3 p-2 rounded-3 shadow-sm"
     style="background:#fff; border:1px solid #eee;">

    <h5 class="fw-bold text-dark m-0 d-flex align-items-center">
        <span class="me-2 d-flex align-items-center justify-content-center"
              style="width:36px; height:36px; border-radius:10px; background:rgba(113,16,62,0.08);">
            <i class="fa fa-tachometer-alt" style="color: rgb(85, 6, 43); font-size:1rem;"></i>
        </span>
        {{ auth()->user()->company?->name }}
    </h5>


    @if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

@if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
@endif

<div style="display:flex; align-items:center; gap:12px;">

    <!-- Admin Access Badge -->
    <span class="px-2 py-1 rounded-pill"
          style="background:rgba(113,16,62,0.1); color:rgb(113,16,62); font-weight:600; font-size:0.8rem;">
        Admin Access
    </span>

    <!-- Google Connection Status -->
    @if(auth()->user()->google_token)
        <span style="display:flex; align-items:center; gap:6px; 
                     background:#e6f7e6; color:#1a7f1a; 
                     padding:6px 12px; border-radius:20px; font-weight:600; font-size:0.8rem;">
            ✓ Google Connected for Meetings
        </span>
    @else
        <a href="/google/redirect" 
           class="btn btn-danger" 
           style="font-size:0.8rem; padding:6px 12px; border-radius:20px;">
            Connect Google Calendar
        </a>
    @endif

</div>




</div>



    <!-- Job Statistics Overview -->
<div class="row g-3 mb-4">
    @foreach ([
        ['key' => 'active', 'icon' => 'fa-bullhorn', 'title' => 'Active Job Ads', 'count' => $jobCounts['active'], 'text' => 'Currently published'],
        ['key' => 'open', 'icon' => 'fa-briefcase', 'title' => 'Open Jobs', 'count' => $jobCounts['open'], 'text' => 'Accepting applications'],
        ['key' => 'expired', 'icon' => 'fa-times-circle', 'title' => 'Expired Jobs', 'count' => $jobCounts['expired'], 'text' => 'Past deadline'],
        ['key' => 'closed', 'icon' => 'fa-lock', 'title' => 'Closed Jobs', 'count' => $jobCounts['closed'], 'text' => 'No longer available']
    ] as $jobStatus)
        <div class="col-md-3">
            <div class="card h-100 dashboard-card"
     role="button"
     data-bs-toggle="offcanvas"
     data-bs-target="#jobOffcanvas-{{ $jobStatus['key'] }}">


                <div class="card-body text-center py-4">
                    <div class="icon-wrapper mb-2">
                        <i class="fa {{ $jobStatus['icon'] }} fa-2x"></i>
                    </div>

                    <h6 class="fw-semibold mb-1">{{ $jobStatus['title'] }}</h6>

                    <p class="fs-2 fw-bold mb-0 text-dark">{{ $jobStatus['count'] }}</p>

                    <small class="text-muted">{{ $jobStatus['text'] }}</small>
                </div>

            </div>
        </div>
    @endforeach
</div>






    <!-- Job Trends Chart -->
<div class="row g-3 mb-4">
    <div class="col-12">
        <div class="card border-0 bg-light h-100">
            <div class="card-header bg-white border-0 fw-semibold">
                <i class="fa fa-chart-line me-2 text-info"></i> Job Trends Overview
            </div>
            <div class="card-body">
                <!-- Admin controls -->
                <form id="jobFilterForm" class="row g-2 mb-3">
                    <div class="col-md-4">
                        <label for="jobTitles" class="form-label">Job Title</label>
                        <select id="jobTitles" class="form-select">
                            <option value="Support Workers">Support Workers</option>
                            <option value="Senior Support Workers">Senior Support Workers</option>
                            <option value="Service Managers">Service Managers</option>
                            <option value="Operations Managers">Operations Managers</option>
                            <option value="Social Workers">Social Workers</option>
                            <option value="Administration Officers">Administration Officers</option>
                            <option value="Nurses">Nurses</option>
                            <option value="Team Leaders">Team Leaders</option>
                            <option value="Business Managers">Business Managers</option>
                        </select>
                    </div>
                    
                           {{-- <div class="col-md-4">
                  <label class="form-label" for="location">Location <span class="text-danger">*</span></label>
                          <input type="text" class="form-control" id="location" placeholder="Enter suburb" required autocomplete="off">
                        </div> --}}
                    <div class="col-md-4 d-flex align-items-end">
                        <button type="submit" class="btn btn-info w-100">
                            <i class="fa fa-sync-alt me-1"></i> Filter Data
                        </button>
                    </div>
                </form>

                <!-- Chart canvas -->
                <canvas id="jobTrendsChart"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Include Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
let jobTrendsChart = null;

document.addEventListener('DOMContentLoaded', () => {
    // Initial load: no filters, just show what's in the DB
    loadJobTrendChart(false);

    const form = document.getElementById('jobFilterForm');
    if (form) {
        form.addEventListener('submit', function (e) {
            e.preventDefault();
            loadJobTrendChart(true);
        });
    }
});

function loadJobTrendChart(useFilters) {
    let url = '/job-trends-data';

    // Only apply filters when requested (form submit)
    if (useFilters) {
        const jobEl = document.getElementById('jobTitles');
        const locEl = document.getElementById('location');

        const job = jobEl ? jobEl.value : '';
        const location = locEl ? locEl.value.trim() : '';

        const params = new URLSearchParams();
        if (job) params.append('job', job);
        if (location) params.append('location', location);

        const qs = params.toString();
        if (qs) url += `?${qs}`;
    }

    fetch(url)
        .then(res => res.json())
        .then(res => {
            // Allow both {success, data} and plain [array] formats
            const success = typeof res.success === 'undefined' ? true : res.success;
            const rows = Array.isArray(res.data) ? res.data : (Array.isArray(res) ? res : []);

            if (!success) {
                console.error('Job trends API returned success = false', res);
                renderEmptyJobTrendChart('Failed to load job trend data');
                return;
            }

            if (!rows || rows.length === 0) {
                renderEmptyJobTrendChart('No data found for this filter');
                return;
            }

            const labels = rows.map(r => r.job_title);
            const values = rows.map(r => Number(r.applicants || r.count || 0));

            const chartData = {
                labels: labels,
                datasets: [{
                    label: 'Number of Applicants',
                    data: values,
                    backgroundColor: 'rgba(0, 123, 255, 0.5)',
                    borderColor: 'rgba(0, 123, 255, 1)',
                    borderWidth: 1
                }]
            };

            const config = {
                type: 'bar',
                data: chartData,
                options: {
                    responsive: true,
                    plugins: {
                        legend: { position: 'top' },
                        title: { display: true, text: 'Job Trends Overview' }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: { display: true, text: 'Number of Applicants' }
                        }
                    }
                }
            };

            // Destroy old chart before creating new one
            if (jobTrendsChart) {
                jobTrendsChart.destroy();
            }

            const ctx = document.getElementById('jobTrendsChart');
            if (!ctx) {
                console.error('jobTrendsChart canvas not found in DOM');
                return;
            }

            jobTrendsChart = new Chart(ctx, config);
        })
        .catch(err => {
            console.error('Error loading job trends', err);
            renderEmptyJobTrendChart('Error loading job trends');
        });
}

function renderEmptyJobTrendChart(message) {
    const ctx = document.getElementById('jobTrendsChart');
    if (!ctx) return;

    const chartData = {
        labels: [],
        datasets: [{
            label: 'Number of Applicants',
            data: [],
            backgroundColor: 'rgba(0, 123, 255, 0.5)',
            borderColor: 'rgba(0, 123, 255, 1)',
            borderWidth: 1
        }]
    };

    const config = {
        type: 'bar',
        data: chartData,
        options: {
            responsive: true,
            plugins: {
                legend: { display: false },
                title: { display: true, text: message }
            },
            scales: {
                y: { beginAtZero: true }
            }
        }
    };

    if (jobTrendsChart) {
        jobTrendsChart.destroy();
    }
    jobTrendsChart = new Chart(ctx, config);
}
</script>










<!-- Quick Links Section -->
{{-- <div class="row g-3 mt-4">
    <div class="col-12">
        <div class="card border-0 bg-light shadow-sm h-100">
            <div class="card-header bg-white border-0 fw-semibold">
                <i class="fa fa-link me-2 text-primary"></i> Quick Links
            </div>
            <div class="card-body">
                <div class="d-flex flex-column">
                    <a href="#" class="btn btn-outline-primary mb-2">View All Job Listings</a>
                    <a href="#" class="btn btn-outline-success mb-2">Manage Candidates</a>
                    <a href="#" class="btn btn-outline-warning mb-2">View Employee Records</a>
                    <a href="#" class="btn btn-outline-info mb-2">Check Analytics</a>
                    <a href="#" class="btn btn-outline-secondary mb-2">Training Resources</a>
                </div>
            </div>
        </div>
    </div>
</div> --}}





<script>
document.addEventListener('DOMContentLoaded', function () {
  const jobForm = document.getElementById('jobForm');
  const jobFormCanvas = document.getElementById('jobFormCanvasUnique'); // current offcanvas
  const adTypeCanvas = document.getElementById('adTypeCanvas');         // target offcanvas

  jobForm.addEventListener('submit', function (event) {
    event.preventDefault(); // stop page reload

    // Step 1: Validate form
    if (!jobForm.checkValidity()) {
      jobForm.reportValidity();
      return;
    }

    // Step 2: Collect data
    const jobData = {
      category: document.getElementById('category').value,
      jobTitle: document.getElementById('jobTitle').value,
      location: document.getElementById('location').value,
      workplace: document.getElementById('workplace').value,
      workType: document.getElementById('workType').value,
      payType: document.getElementById('payType').value,
      payMin: document.getElementById('payMin').value,
      payMax: document.getElementById('payMax').value,
      payVisibility: document.querySelector('input[name="payVisibility"]:checked').value
    };

    // Step 3: Save to sessionStorage
    sessionStorage.setItem('jobFormData', JSON.stringify(jobData));
    console.log('Job data saved:', jobData);

    // Step 4: Close the job form offcanvas
    const jobFormInstance = bootstrap.Offcanvas.getInstance(jobFormCanvas);
    if (jobFormInstance) {
      jobFormInstance.hide();
    }

        // Configure Notiflix Loading to be small and less intrusive
    Notiflix.Loading.init({
  className: 'notiflix-loading',
  cssAnimationStyle: 'zoom',
  svgSize: '40px',       // makes the circle smaller
  messageFontSize: '13px',
  backgroundColor: 'rgba(0,0,0,0.1)', // lighter overlay
});

     // Show loading overlay
  Notiflix.Loading.circle('Loading next step...');
    setTimeout(() => {
      Notiflix.Loading.remove();
    }, 1500); // simulate loading time

    // Step 5: Show the adType offcanvas
    const adTypeCanvasInstance = new bootstrap.Offcanvas(adTypeCanvas);
    adTypeCanvasInstance.show();
  });
});
</script>





<script>
document.addEventListener('DOMContentLoaded', function () {
  const nxtBtn = document.getElementById('nxtBtn');
  const adTypeCanvas = document.getElementById('adTypeCanvas');

  nxtBtn.addEventListener('click', function () {
    // Step 1: Get selected ad type
    const selected = document.querySelector('input[name="adType"]:checked');
    if (!selected) {
      alert('Please select an ad type first.');
      return;
    }

    // Step 2: Retrieve job data from sessionStorage
    const jobData = JSON.parse(sessionStorage.getItem('jobFormData')) || {};

    // Step 3: Append ad type to jobData
    jobData.adType = selected.value;

    // Step 3a: Get price dynamically from the card (numeric only)
    const card = selected.closest('.ad-card');
    const priceElement = card.querySelector('.price-value');
    if (priceElement) {
      // Remove all non-digit characters
      const numericPrice = priceElement.textContent.replace(/\D/g, '');
      jobData.adPrice = numericPrice;
    }

    // Step 4: Save back to sessionStorage
    sessionStorage.setItem('jobFormData', JSON.stringify(jobData));
    console.log('Updated job data:', jobData);

    // Configure Notiflix Loading to be small and less intrusive
    Notiflix.Loading.init({
      className: 'notiflix-loading',
      cssAnimationStyle: 'zoom',
      svgSize: '40px',       // makes the circle smaller
      messageFontSize: '13px',
      backgroundColor: 'rgba(0,0,0,0.1)', // lighter overlay
    });

    // Show loading overlay
    Notiflix.Loading.circle();
    setTimeout(() => {
      Notiflix.Loading.remove();
    }, 1500); // simulate loading time

    // Step 5: Open the adType offcanvas
    const adTypeCanvasInstance = new bootstrap.Offcanvas(adTypeCanvas);
    adTypeCanvasInstance.show();
  });
});
</script>


<script>
document.addEventListener('DOMContentLoaded', function () {
    const nxtBtn = document.getElementById('nxtBtn');
    const detailsBody = document.getElementById('detailsBody');
    const detailsCanvas = document.getElementById('detailsCanvas');
    const adTypeCanvas = document.getElementById('adTypeCanvas');

    const company = @json(Auth::user()->company?->name);
    const companyId = @json(Auth::user()->company?->id);

    // ✅ Register custom BBCode tags
sceditor.formats.bbcode.set('note', {
    tags: { div: { class: 'bb-note' } },
    format: function (element) {
        return '[note]' + element.innerHTML + '[/note]';
    },
    html: '<div class="bb-note">{0}</div>'
});

sceditor.formats.bbcode.set('warning', {
    tags: { div: { class: 'bb-warning' } },
    format: function (element) {
        return '[warning]' + element.innerHTML + '[/warning]';
    },
    html: '<div class="bb-warning">{0}</div>'
});

sceditor.formats.bbcode.set('success', {
    tags: { div: { class: 'bb-success' } },
    format: function (element) {
        return '[success]' + element.innerHTML + '[/success]';
    },
    html: '<div class="bb-success">{0}</div>'
});

// ✅ Add toolbar buttons
sceditor.command.set("note", {
    exec: function () { this.insert("[note]", "[/note]"); },
    tooltip: "Note"
});

sceditor.command.set("warning", {
    exec: function () { this.insert("[warning]", "[/warning]"); },
    tooltip: "Warning"
});

sceditor.command.set("success", {
    exec: function () { this.insert("[success]", "[/success]"); },
    tooltip: "Success"
});


    // ✅ Helper: Initialize SCEditor on all BBCode fields
    function initBBCodeEditors() {
        document.querySelectorAll('.job-description, .job-summary').forEach(textarea => {
            // Destroy existing editor if reloading UI
            if (sceditor.instance(textarea)) {
                sceditor.instance(textarea).destroy();
            }

            sceditor.create(textarea, {
                format: 'bbcode',
                style: 'https://cdn.jsdelivr.net/npm/sceditor@3/minified/themes/content/default.min.css',
                toolbar: 'bold,italic,underline|color|link,unlink|bulletlist,orderedlist|quote|source',
                emoticonsEnabled: false
            });
        });
    }

    //  Load fields dynamically when user clicks Next
    nxtBtn.addEventListener('click', function () {
        const selected = document.querySelector('input[name="adType"]:checked');
        detailsBody.innerHTML = '';

        if (!selected) {
            detailsBody.innerHTML = '<p>Please select an ad type first.</p>';
            return;
        }

        let fields = '';

        switch (selected.value) {
            case 'basic':
                fields = `
                    <div class="mb-3">
                        <label class="form-label">Job Description</label>
                        <textarea class="form-control job-description" rows="6" style="min-height:300px;" required></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Job Summary</label>
                        <textarea class="form-control job-summary" rows="6" style="min-height:300px;" required></textarea>
                    </div>
                `;
                break;

            case 'premium':
                fields = `
                    <div class="mb-3"><label class="form-label">Job Description</label><textarea class="form-control job-description" rows="6" style="min-height:300px;"></textarea></div>
                    <div class="mb-3"><label class="form-label">Job Summary</label><textarea class="form-control job-summary" rows="6" style="min-height:300px;"></textarea></div>
                    <div class="mb-3"><label class="form-label">Company Brand/Logo</label><input type="file" class="form-control company-logo"></div>
                    <div class="mb-3"><label class="form-label">Social Media Handles</label><input type="text" class="form-control social-media"></div>
                    <div class="mb-3"><label class="form-label">Company Overview</label><textarea class="form-control company-overview" rows="6"></textarea></div>
                `;
                break;

            case 'platinum':
                fields = `
                    <div class="mb-3"><label class="form-label">Job Description</label><textarea class="form-control job-description" rows="6" style="min-height:300px;"></textarea></div>
                    <div class="mb-3"><label class="form-label">Job Summary</label><textarea class="form-control job-summary" rows="6" style="min-height:300px;"></textarea></div>
                    <div class="mb-3"><label class="form-label">Company Brand/Logo</label><input type="file" class="form-control company-logo"></div>
                    <div class="mb-3"><label class="form-label">Social Media Handles</label><input type="text" class="form-control social-media"></div>
                    <div class="mb-3"><label class="form-label">Company Overview</label><textarea class="form-control company-overview" rows="6"></textarea></div>
                    <div class="mb-3"><label class="form-label">Upload Video Description</label><input type="file" class="form-control company-video"></div>
                `;
                break;
        }

        fields += `
            <button type="button" id="continueBtn" data-url="{{ route('echeckquiz') }}"
                class="w-100 mt-3 d-flex align-items-center justify-content-center"
                style="background-color: rgb(113, 16, 62); color: #fff; border: none; padding: 12px; border-radius: 6px; font-weight: 600;">
                <i class="fas fa-arrow-right me-2"></i> Continue Screening Questions
            </button>

            <p class="mt-3 text-center">
                <a href="#" id="chooseAnother" class="text-decoration-none text-danger fw-semibold">
                    Not satisfied with this ad? Choose another
                </a>
            </p>
        `;

        detailsBody.innerHTML = fields;

        // Initialize SCEditor NOW (after injecting HTML)
        initBBCodeEditors();

        //  Switch canvases
        const adCanvasInstance = bootstrap.Offcanvas.getInstance(adTypeCanvas);
        if (adCanvasInstance) adCanvasInstance.hide();

        const detailsCanvasInstance = new bootstrap.Offcanvas(detailsCanvas);
        detailsCanvasInstance.show();
    });

    //  Handle clicks inside detailsBody
    detailsBody.addEventListener('click', function (e) {

        // Go back
        if (e.target.id === 'chooseAnother') {
            bootstrap.Offcanvas.getInstance(detailsCanvas)?.hide();
            new bootstrap.Offcanvas(adTypeCanvas).show();
            return;
        }

        // Continue button
        if (e.target.id === 'continueBtn') {

            //  Extract BBCode values from SCEditor
            const descEditor = sceditor.instance(detailsBody.querySelector('.job-description'));
            const summaryEditor = sceditor.instance(detailsBody.querySelector('.job-summary'));

            const description = descEditor ? descEditor.val().trim() : '';
            const summary = summaryEditor ? summaryEditor.val().trim() : '';

            const errors = [];
            if (!description) errors.push('Job Description is required.');
            if (!summary) errors.push('Job Summary is required.');

            if (errors.length > 0) {
                Notiflix.Notify.failure(errors.join(' '));
                return;
            }

            const jobData = {
                company_id: companyId,
                company: company,
                description,
                summary,
                logo: detailsBody.querySelector('.company-logo')?.files[0]?.name || null,
                socialMedia: detailsBody.querySelector('.social-media')?.value || null,
                overview: detailsBody.querySelector('.company-overview')?.value || null,
                video: detailsBody.querySelector('.company-video')?.files[0]?.name || null,
            };

            //  Merge with session data
            let existingData = {};
            try {
                existingData = JSON.parse(sessionStorage.getItem('jobFormData')) || {};
            } catch {}

            const mergedData = { ...existingData, ...jobData };
            sessionStorage.setItem('jobFormData', JSON.stringify(mergedData));

            console.log('Updated job data:', mergedData);

            //  Redirect
            window.location.href = e.target.dataset.url;
        }
    });
});
</script>



<!-- Custom CSS -->
<style>

  #savedProfilesPanel.offcanvas-top {
    height: 500px;          /* let it grow with content */
    max-height: 100vh;     /* prevent overflow beyond viewport */
    background-color: rgb(113, 16, 62) /* light background */
  }
  #savedProfilesPanel .offcanvas-body.no-scroll {
    overflow-y: visible;   /* disable scrolling */
  }
  
</style>



@endsection

@section('scripts')

function initSuburbAutocomplete() {
    const input = document.getElementById('location');
     if (!input) {
    console.warn('No #location input found');
    return;
  }

    // Australia bounds (rough box) to help relevance
    const ausBounds = new google.maps.LatLngBounds(
      new google.maps.LatLng(-44.0, 112.0), // SW
      new google.maps.LatLng(-10.0, 154.0)  // NE
    );

    const autocomplete = new google.maps.places.Autocomplete(input, {
      // Regions returns localities, sublocalities, etc.
      types: ['(regions)'],
      componentRestrictions: { country: 'au' },
      fields: ['address_components', 'formatted_address', 'name', 'geometry'],
      bounds: ausBounds,
      strictBounds: true
    });

    autocomplete.addListener('place_changed', () => {
      const place = autocomplete.getPlace();
      console.log('Selected suburb:', place.formatted_address);
      if (!place || !place.address_components) return;

      // Extract suburb (locality or sublocality_level_1), state, postcode
      let suburb = '';
      let state = '';
      let postcode = '';

      place.address_components.forEach(c => {
        const types = c.types || [];
        if (types.includes('locality')) suburb = c.long_name;
        if (types.includes('sublocality') || types.includes('sublocality_level_1')) {
          // Some suburbs are provided as sublocality
          suburb = suburb || c.long_name;
        }
        if (types.includes('administrative_area_level_1')) state = c.short_name; // e.g., QLD, NSW
        if (types.includes('postal_code')) postcode = c.long_name;
      });

      // Accept only if we got a suburb-like value
      if (suburb) {
        const display = `${suburb}${state ? ', ' + state : ''}${postcode ? ' ' + postcode : ''}`;
        input.value = display;
        input.setCustomValidity('');
      } else {
        // Not a suburb: prompt user to pick a suburb
        input.setCustomValidity('Please select a suburb in Australia (not a street or business).');
        input.reportValidity();
      }
    });

    // Optional: prevent form submit on Enter before a place is selected
    input.addEventListener('keydown', (e) => {
      if (e.key === 'Enter') e.preventDefault();
    });
  }


document.addEventListener('DOMContentLoaded', function () {
    const flash = document.querySelector('.flash-message');
    if (flash) {
        setTimeout(() => {
            flash.style.opacity = '0';
            setTimeout(() => flash.remove(), 600);
        }, 3000);
    }
});



@endsection
