@extends('layouts.app')

@section('content')

<br>

<div class="container d-flex justify-content-center">
    <div class="w-75"> <!-- reduce width to 75% of container -->
        <!-- Gradient Header -->
        <div class="bg-wine-gradient text-white rounded-top p-4 shadow-sm mb-4 text-center">
            <h2 class="mb-2"><i class="fa fa-building me-2"></i><strong> Register Your Company</strong></h2>
            <p class="get-started-text mb-0">Enter your ABN. We'll do the rest</p>
        </div>

        {{-- Success & Error Alerts --}}
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show card shadow-sm" role="alert">
                <i class="fa fa-check-circle me-2"></i> {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show card shadow-sm" role="alert">
                <i class="fa fa-exclamation-circle me-2"></i> {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                  @if (session('show_login'))
            <br><br>
            <a href="{{ route('login') }}" class="btn btn-primary">
                Login
            </a>
        @endif
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger card shadow-sm">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li><i class="fa fa-times-circle me-1"></i> {{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

      <!-- Main Card -->
<form id="companyForm" method="POST" action="{{ route('companies.store') }}" class="card p-4 shadow-lg border-0">
    @csrf

    <!-- Error alert placeholder (moved above ABN input) -->
<!-- Error alert placeholder (centered, reduced width) -->
<div class="d-flex justify-content-center mb-3">
    <div id="lookupError" class="alert alert-danger card shadow-sm text-center"
         style="display:none; max-width: 500px; width: 100%;">
    </div>
</div>

<div class="mb-4">
    <label for="abn" class="form-label text-wine fw-bold">Enter ABN</label>
    <div class="input-group">
        <span class="input-group-text bg-wine-gradient text-white"><i class="fa fa-id-card"></i></span>
        <input type="text" name="abn" id="abn" class="form-control" placeholder="e.g. 51824753556" required>
    </div>
    <button type="button" id="lookupBtn" class="btn btn-wine mt-3 w-100">
        <i class="fa fa-search me-2"></i> Lookup ABN
    </button>
</div>


    <!-- Progress Bar -->
    <div id="progressWrapper" class="mb-3" style="display:none;">
        <div class="progress">
            <div id="progressBar" class="progress-bar bg-wine-gradient" role="progressbar" style="width: 1%;" aria-valuenow="1" aria-valuemin="0" aria-valuemax="100">1%</div>
        </div>
    </div>

    <!-- Hidden initially -->
    <div id="companyFields" style="display:none;">
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label text-wine fw-bold">Company Name</label>
                <input type="text" name="name" id="name" class="form-control" readonly>
            </div>
            <div class="col-md-6">
                <label class="form-label text-wine fw-bold">Status</label>
                <input type="text" name="status" id="status" class="form-control" readonly>
            </div>
            <div class="col-md-6">
                <label class="form-label text-wine fw-bold">Type</label>
                <input type="text" name="type" id="type" class="form-control" readonly>
            </div>
            <div class="col-md-3">
                <label class="form-label text-wine fw-bold">State</label>
                <input type="text" name="state" id="state" class="form-control" readonly>
            </div>
            <div class="col-md-3">
                <label class="form-label text-wine fw-bold">Postcode</label>
                <input type="text" name="postcode" id="postcode" class="form-control" readonly>
            </div>
        </div>

        <button id="submitBtn" type="submit" class="btn btn-wine mt-4 w-100">
            <i class="fa fa-check me-2"></i> Register Company
        </button>

    </div>
</form>


        <!-- Error alert placeholder -->
        <div id="lookupError" class="alert alert-danger mt-3 card shadow-sm" style="display:none;"></div>
    </div>
</div>

<br>
<br>
<br>
<br>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>$('#lookupBtn').on('click', function() {
    let abn = $('#abn').val().trim();
    $('#lookupError').hide().text('');
    $('#companyFields').hide();

    if (!abn) {
        $('#lookupError').text('Please enter an ABN').show();
        return;
    }

    // Show progress bar
    $('#progressWrapper').show();
    let progress = 1;
    let interval = setInterval(function() {
        if (progress >= 100) {
            clearInterval(interval);
            // Auto-hide progress bar after reaching 100%
            setTimeout(() => $('#progressWrapper').fadeOut(), 500);
        } else {
            progress++;
            $('#progressBar')
                .css('width', progress + '%')
                .attr('aria-valuenow', progress)
                .text(progress + '%');
        }
    }, 30);

    $.ajax({
        url: "{{ route('companies.lookup') }}",
        type: "POST",
        data: {
            _token: "{{ csrf_token() }}",
            abn: abn
        },
        success: function(data) {
            clearInterval(interval);
            $('#progressBar')
                .css('width', '100%')
                .attr('aria-valuenow', 100)
                .text('100%');
            // Hide progress bar after short delay
            setTimeout(() => $('#progressWrapper').fadeOut(), 500);

            $('#name').val(data.name);
            $('#status').val(data.status);
            $('#type').val(data.type);
            $('#state').val(data.state);
            $('#postcode').val(data.postcode);
            $('#companyFields').fadeIn();
        },
        error: function(xhr) {
            clearInterval(interval);
            $('#progressBar')
                .css('width', '100%')
                .attr('aria-valuenow', 100)
                .text('100%');
            // Hide progress bar after short delay
            setTimeout(() => $('#progressWrapper').fadeOut(), 500);

            let msg = (xhr.responseJSON && xhr.responseJSON.error)
                ? xhr.responseJSON.error
                : 'Lookup failed';
            $('#lookupError').text(msg).show();
        }
    });
});

    document.getElementById("companyForm").addEventListener("submit", function () {
        const btn = document.getElementById("submitBtn");
        btn.innerHTML = '<i class="fa fa-spinner fa-spin me-2"></i> Submitting company info. Please wait...';
        btn.disabled = true; // prevent multiple clicks
    });

</script>

<style>

    .get-started-text {
        font-size: 1rem;
        font-weight: 500;
        opacity: 0.9;
    }
    .text-wine {
        color: rgb(113, 16, 62) !important;
    }
    .bg-wine-gradient {
        background: linear-gradient(45deg, rgb(113, 16, 62), #6b0f3e);
    }
    .btn-wine {
        background-color: rgb(113, 16, 62);
        color: #fff;
        border: none;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    .btn-wine:hover {
        background-color: #6b0f3e;
        transform: translateY(-2px);
        box-shadow: 0 0.5rem 1rem rgba(113, 16, 62, 0.4);
    }
    .card {
        border-radius: 1rem;
        background-color: #fff;
        color: #000;
    }
    .form-control {
        border-radius: 0.5rem;
    }
    .progress {
        height: 25px;
        border-radius: 0.5rem;
        overflow: hidden;
    }
    .progress-bar {
        font-weight: bold;
    }
</style>










{{-- <div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-lg border-0 rounded-3">
                <!-- Header -->
                <div class="card-header bg-wine-gradient text-white text-center rounded-top">
                    <h4 class="mb-0">
                        <i class="fa fa-building me-2"></i> {{ __('Register Your Company') }}
                    </h4>
                </div>

                <!-- Sub-heading -->
                <div class="text-center mt-3">
                    <h5 class="get-started-text">
                        <i class="fa fa-play-circle me-2 text-wine"></i> Get Started
                    </h5>
                </div>

                <!-- Body -->
                <div class="card-body p-4">
                    <form method="POST" action="{{ route('company.store') }}">
                        @csrf

                        <!-- Business Name -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Business / Company Name</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light"><i class="fa fa-briefcase text-wine"></i></span>
                                <input type="text" name="company_name" class="form-control" required>
                            </div>
                        </div>

                        <!-- Address -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Address</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light"><i class="fa fa-map-marker-alt text-wine"></i></span>
                                <input type="text" name="address" class="form-control" required>
                            </div>
                        </div>

                        <!-- Email -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Email</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light"><i class="fa fa-envelope text-wine"></i></span>
                                <input type="email" name="email_address" class="form-control" required>
                            </div>
                        </div>

                        <!-- ABN -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">ABN</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light"><i class="fa fa-id-card text-wine"></i></span>
                                <input type="text" name="abn" class="form-control" required>
                            </div>
                        </div>

                        <!-- Submit -->
                        <div class="d-grid mt-4">
                            <button type="submit" class="btn btn-wine btn-lg shadow-sm">
                                Next <i class="fa fa-arrow-right ms-2"></i>
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Footer -->
                <div class="card-footer text-center bg-light rounded-bottom">
                    <small class="company-note text-muted"
                           data-bs-toggle="tooltip"
                           data-bs-placement="top"
                           title="Company verification is mandatory before using this platform">
                        <i class="fa fa-info-circle me-1 text-wine"></i>
                        Please ensure your company details are correct before proceeding.
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        })
    });
</script>
<style>
    .get-started-text {
        font-size: 1.1rem;
        font-weight: 600;
        color: #333;
        margin-top: 1rem;
        margin-bottom: 1rem;
    }
    .text-wine {
        color: rgb(113, 16, 62) !important;
    }
    .bg-wine-gradient {
        background: linear-gradient(45deg, rgb(113, 16, 62), #6b0f3e);
    }
    .btn-wine {
        background-color: rgb(113, 16, 62);
        color: #fff;
        border: none;
        transition: all 0.3s ease;
    }
    .btn-wine:hover {
        background-color: #6b0f3e;
        transform: translateY(-2px);
        box-shadow: 0 0.5rem 1rem rgba(113, 16, 62, 0.4);
    }
    .card {
        border-radius: 1rem;
    }
    .input-group-text {
        border-radius: 0.5rem 0 0 0.5rem;
    }
    .form-control {
        border-radius: 0 0.5rem 0.5rem 0;
    }
    .company-note {
        font-size: 0.9rem;
        transition: color 0.3s ease;
        cursor: pointer;
    }
    .company-note:hover {
        color: rgb(113, 16, 62);
        text-decoration: underline;
    }
</style> --}}
@endsection
