
<!-- Active Jobs Offcanvas -->
<div class="offcanvas offcanvas-end offcanvas-75 shadow-lg rounded-start" tabindex="-1" id="jobOffcanvas-active">
    <div class="offcanvas-header bg-gradient-primary text-white py-3 px-4">
        <h5 class="offcanvas-title fw-bold">
            <i class="fa fa-bullhorn me-2"></i> Active Job Ads
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body p-4 bg-light">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <h6 class="fw-bold mb-3 text-primary">
                    <i class="fa fa-list me-2"></i> Job Listings
                </h6>

                @if($activeJobs->isEmpty())
                    <div class="text-center py-5">
                        <i class="fa fa-info-circle fa-3x text-muted mb-3"></i>
                        <h5 class="fw-bold text-secondary">No Open Jobs at the Moment</h5>
                        <p class="text-muted mb-4">You haven’t published any active job ads yet.</p>
                        <a href="javascript:void(0)"
                           class="btn btn-danger"
                           data-bs-toggle="offcanvas"
                           data-bs-target="#jobFormCanvasUnique">
                            <i class="fa fa-plus me-2"></i> Post a Job Ad
                        </a>
                    </div>
                @else
                    <div class="table-responsive">
                        @include('components.activejobs', ['jobs' => $activeJobs])
                    </div>
                @endif

            </div>
        </div>
    </div>
</div>