@extends('layouts.app')

@section('content')

<style>
    body {
        background: #f5f6fa;
    }

    .page-title {
        font-size: 28px;
        font-weight: 800;
        color: rgb(113, 16, 62);
        letter-spacing: -0.5px;
    }

    /* Floating filter bar */
    .filter-bar {
        position: sticky;
        top: 70px;
        z-index: 20;
        background: rgba(255, 255, 255, 0.96);
        backdrop-filter: blur(8px);
        border-radius: 16px;
        padding: 12px 18px;
        box-shadow: 0 10px 25px rgba(0,0,0,0.06);
        margin-bottom: 20px;
        border: 1px solid #eee;
    }

    .filter-bar .form-control,
    .filter-bar .form-select {
        border-radius: 12px;
        border-color: #ddd;
        font-size: 14px;
    }

    .filter-badge {
        font-size: 13px;
        padding: 6px 10px;
        border-radius: 999px;
        border: 1px solid #ddd;
        cursor: pointer;
        transition: .2s;
    }

    .filter-badge.active {
        background: rgb(113, 16, 62);
        color: #fff;
        border-color: rgb(113, 16, 62);
    }

    /* Job card grid fade transitions */
    .jobs-grid {
        transition: opacity .25s ease;
    }
    .jobs-grid.fade-out {
        opacity: 0;
    }

    /* Job Card */
    .job-card {
        background: #fff;
        border-radius: 18px;
        padding: 22px;
        cursor: pointer;
        transition: all .25s ease;
        border: 1px solid #eee;
        position: relative;
    }
    .job-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 12px 28px rgba(113, 16, 62, 0.15);
        border-color: rgb(113, 16, 62);
    }

    .job-logo {
        width: 60px;
        height: 60px;
        border-radius: 12px;
        object-fit: cover;
        background: #fafafa;
        border: 1px solid #ddd;
    }

    /* Favorite (Saved) Icon */
    .favorite-toggle {
        position: absolute;
        top: 14px;
        right: 14px;
        background: rgba(255,255,255,0.9);
        border-radius: 999px;
        width: 32px;
        height: 32px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: .2s;
        box-shadow: 0 4px 10px rgba(0,0,0,0.08);
    }
    .favorite-toggle i {
        color: #bbb;
        font-size: 16px;
    }
    .favorite-toggle.active i {
        color: rgb(220, 53, 69);
    }

    .text-wine {
        color: rgb(113, 16, 62) !important;
    }

    /* Offcanvas Styling */
    .fancy-offcanvas {
        width: 520px !important;
        backdrop-filter: blur(10px);
        background: rgba(255, 255, 255, 0.95);
        box-shadow: -6px 0 30px rgba(113, 16, 62, 0.25);
        border-left: 5px solid rgb(113, 16, 62);
        animation: slideIn .4s ease;
    }

    @keyframes slideIn {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }

    .fancy-offcanvas .offcanvas-header {
        background: rgb(113, 16, 62);
        color: white;
        padding: 20px;
    }

    .fancy-offcanvas .offcanvas-body {
        padding: 25px;
    }

    .quick-apply-btn {
        background: rgb(113, 16, 62);
        color: white;
        border: none;
        padding: 12px 20px;
        border-radius: 10px;
        font-weight: 600;
        width: 100%;
        margin-top: 20px;
        transition: .25s;
    }
    .quick-apply-btn:hover {
        background: rgb(140, 20, 80);
        transform: translateY(-2px);
    }

    .section-title {
        font-weight: 700;
        margin-top: 20px;
        margin-bottom: 6px;
        color: rgb(113, 16, 62);
    }

    .info-text {
        background: white;
        padding: 12px;
        border-radius: 10px;
        border: 1px solid #ddd;
    }

    /* Pagination styling */
    .pagination {
        justify-content: center;
    }
    .pagination .page-link {
        border-radius: 999px !important;
        margin: 0 3px;
    }
    /* BASIC */
.job-card.basic {
    border: 1px solid #ddd;
    background: #fff;
}

/* PREMIUM */
.job-card.premium {
    border: 2px solid #b8860b;
    background: #fff8e1;
    box-shadow: 0 0 10px rgba(184, 134, 11, 0.3);
}

/* PLATINUM */
.job-card.platinum {
    border: 2px solid #6a1b9a;
    background: #f3e5f5;
    box-shadow: 0 0 15px rgba(106, 27, 154, 0.4);
    position: relative;
}

/* Actively Hiring badge */
.platinum-badge {
    position: absolute;
    top: -10px;
    right: -10px;
    background: #6a1b9a;
    color: #fff;
    padding: 5px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: bold;
}

</style>

@php
    $currentSearch   = request('search');
    $currentCategory = request('category');
@endphp

<div class="container py-4">

    <button class="btn btn-outline-secondary mb-4" onclick="window.history.back();">
        <i class="fa-solid fa-arrow-left me-2"></i> Back  To Job Categories
    </button>


    <h4 class="page-title mb-3">
        <i class="fa-solid fa-briefcase me-2"></i> Social Workers Job Listings
    </h4>

    <!-- Floating filter bar -->
    <div class="filter-bar mb-4">
        <form method="GET" action="{{ url()->current() }}" class="row g-2 align-items-center">
            <div class="col-md-5">
                <input type="text"
                       name="search"
                       class="form-control"
                       placeholder="Search by job title or company..."
                       value="{{ $currentSearch }}">
            </div>

            <div class="col-md-2 d-flex justify-content-md-start justify-content-center">
                <button type="submit" class="btn btn-sm btn-outline-secondary w-100">
                    <i class="fa-solid fa-filter me-1"></i> Filter
                </button>
            </div>

            <div class="col-md-2 d-flex justify-content-md-end justify-content-center mt-2 mt-md-0">
                <span class="filter-badge" id="savedFilterToggle">
                    <i class="fa-solid fa-heart me-1"></i> Saved only
                </span>
            </div>
        </form>
    </div>

<div id="jobsGrid" class="row g-4 jobs-grid">
    @foreach($jobs as $job)
        <div class="col-md-4 job-card-wrapper" data-job-id="{{ $job->id }}">

            @php
                $type = strtolower($job->ad_type ?? 'basic');
            @endphp

            <div class="job-card {{ $type }}" onclick="openJobDetails({{ $job->id }})">

                {{-- Platinum badge --}}
                @if($type === 'platinum')
                    <div class="platinum-badge">Actively Hiring</div>
                @endif

                <div class="favorite-toggle" onclick="toggleFavorite(event, {{ $job->id }})">
                    <i class="fa-solid fa-heart"></i>
                </div>

                <div class="d-flex align-items-center mb-3">
                    @if($job->logo)
                        <img src="{{ asset('storage/' . $job->logo) }}" class="job-logo me-3">
                    @else
                        <div class="job-logo me-3 d-flex align-items-center justify-content-center text-muted">
                            <i class="fa-solid fa-building"></i>
                        </div>
                    @endif

                    <div>
                        <h6 class="fw-bold text-wine mb-1">{{ $job->company }}</h6>
                        <small class="text-muted">
                            Expires: {{ \Carbon\Carbon::parse($job->expiry_date)->format('d M Y') }}
                        </small>
                    </div>
                </div>

                <h5 class="fw-bold">{{ $job->job_title }}</h5>

            </div>
        </div>
    @endforeach
</div>


    <div class="mt-4">
        {{ $jobs->withQueryString()->links() }}
    </div>
</div>

<!-- Offcanvas -->
<div class="offcanvas offcanvas-end fancy-offcanvas" tabindex="-1" id="jobDetailsCanvas">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title fw-bold">
            <i class="fa-solid fa-briefcase me-2"></i> Job Details
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body" id="jobDetailsContent">
        <div class="text-center text-muted">Loading...</div>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {

    const jobsGrid = document.getElementById('jobsGrid');
    const savedFilterToggle = document.getElementById('savedFilterToggle');

    // Smooth fade on pagination click (simple)
    document.addEventListener('click', function (e) {
        if (e.target.closest('.pagination a')) {
            jobsGrid.classList.add('fade-out');
        }
    });

    // FAVORITES (localStorage)
    const FAVORITES_KEY = 'sw_favorite_jobs';

    function getFavorites() {
        try {
            return JSON.parse(localStorage.getItem(FAVORITES_KEY)) || [];
        } catch (e) {
            return [];
        }
    }

    function setFavorites(ids) {
        localStorage.setItem(FAVORITES_KEY, JSON.stringify(ids));
    }

    function isFavorite(id) {
        return getFavorites().includes(id);
    }

    function refreshFavoriteIcons() {
        const favorites = getFavorites();
        document.querySelectorAll('.job-card-wrapper').forEach(wrapper => {
            const jobId = parseInt(wrapper.getAttribute('data-job-id'));
            const toggle = wrapper.querySelector('.favorite-toggle');
            if (!toggle) return;
            if (favorites.includes(jobId)) {
                toggle.classList.add('active');
            } else {
                toggle.classList.remove('active');
            }
        });
    }

    function applySavedFilter() {
        const favorites = getFavorites();
        const savedOnly = savedFilterToggle.classList.contains('active');

        document.querySelectorAll('.job-card-wrapper').forEach(wrapper => {
            const jobId = parseInt(wrapper.getAttribute('data-job-id'));
            if (!savedOnly) {
                wrapper.style.display = '';
            } else {
                wrapper.style.display = favorites.includes(jobId) ? '' : 'none';
            }
        });
    }

    window.toggleFavorite = function(event, jobId) {
        event.stopPropagation(); // prevent opening offcanvas

        let favorites = getFavorites();
        if (favorites.includes(jobId)) {
            favorites = favorites.filter(id => id !== jobId);
        } else {
            favorites.push(jobId);
        }
        setFavorites(favorites);
        refreshFavoriteIcons();
        applySavedFilter();
    };

    savedFilterToggle.addEventListener('click', function () {
        savedFilterToggle.classList.toggle('active');
        applySavedFilter();
    });

    // INITIAL favorite state
    refreshFavoriteIcons();
    applySavedFilter();


  

    // OFFCANVAS
    window.openJobDetails = function(id) {

           //  Track the view immediately 
                fetch(`/job-viewed/${id}`, { 
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    }
                })
                .then(res => res.json())
                .then(data => console.log("VIEW TRACK:", data))
                .catch(err => console.error("VIEW ERROR:", err));

        const url = `{{ url('/swjobs') }}/${id}`;

        fetch(url)
            .then(res => res.json())
            .then(job => {

                let html = `
                    <div class="text-center mb-3">
                        ${job.logo ? `<img src="/storage/${job.logo}" class="job-logo mb-3">` : ''}
                        <h3 class="fw-bold text-wine">${job.job_title}</h3>
                        <p class="text-muted mb-0">${job.company}</p>
                        <small class="text-muted">Expires: ${job.expiry_date}</small>
                    </div>

                    <hr>

                    <h6 class="section-title">Job Information</h6>
                    <p><strong>Category:</strong> ${job.category ?? ''}</p>
                    <p><strong>Location:</strong> ${job.location ?? ''}</p>
                    <p><strong>Workplace:</strong> ${job.workplace ?? ''}</p>
                    <p><strong>Work Type:</strong> ${job.work_type ?? ''}</p>
                    <p><strong>Pay Type:</strong> ${job.pay_type ?? ''}</p>
                    <p><strong>Pay Range:</strong> ${job.pay_min ?? ''} - ${job.pay_max ?? ''}</p>

                    <h6 class="section-title">Summary</h6>
                    <div id="summaryContainer" class="info-text"></div>

                    <h6 class="section-title">Description</h6>
                    <div id="descriptionContainer" class="info-text"></div>

                 <button class="quick-apply-btn" onclick="event.stopPropagation(); quickApply(${job.id})">
                    <i class="fa-solid fa-paper-plane me-2"></i> Quick Apply
                </button>


                `;

                const contentEl = document.getElementById('jobDetailsContent');
                contentEl.innerHTML = html;

                document.getElementById('summaryContainer').innerHTML = job.summary_html ?? '';
                document.getElementById('descriptionContainer').innerHTML = job.description_html ?? '';

                const canvasEl = document.getElementById('jobDetailsCanvas');
                const canvas = new bootstrap.Offcanvas(canvasEl);
                canvas.show();
            })
            .catch(err => console.error(err));
    };

});


    function quickApply(jobId) {
        const isLoggedIn = {{ auth()->check() ? 'true' : 'false' }};

        if (!isLoggedIn) {
            // User NOT logged in → send to login page
            window.location.href = "{{ route('login') }}";
            return;
        }

        // User IS logged in → go to home or open modal
        window.location.href = "/home";
    }


</script>

@endsection
