<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\JobBoardController;
use App\Http\Controllers\Auth\RegisterController;
use App\Models\JobBoard;
use App\Helpers\Bbcode;
use App\Http\Controllers\QuestionsController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use App\Http\Controllers\ApplicationController;
use Illuminate\Support\Facades\Mail;
use App\Mail\TestEmail;
use Google\Client;
use Google\Service\Calendar;
use App\Http\Controllers\GoogleController;





Route::get('/', function () {
    return view('index');
});

Auth::routes();
Auth::routes(['register' => false]); // disable default register route

// Re‑add register route but protect it
Route::get('/register', [App\Http\Controllers\Auth\RegisterController::class, 'showRegistrationForm'])
    ->middleware('company.created')
    ->name('register');

Route::post('/register', [App\Http\Controllers\Auth\RegisterController::class, 'register'])
    ->middleware('company.created');


/*------------------------------------------
--------------------------------------------
All Normal Users Routes List
--------------------------------------------
--------------------------------------------*/
Route::middleware(['auth', 'user-access:user'])->group(function () {

    Route::get('/home', [HomeController::class, 'index'])->name('home');
    Route::post('/upload/resume', [HomeController::class, 'uploadResume'])->name('resume.upload');
Route::post('/upload/cover-letter', [HomeController::class, 'uploadCoverLetter'])->name('coverletter.upload');
// Submit job application (resume, cover letter, answers)
Route::post('/apply-job', [ApplicationController::class, 'store'])
    ->name('applications.store');

Route::post('/job-viewed/{id}', [ApplicationController::class, 'jobViewed'])
->name('job-viewed');







});

/*------------------------------------------
--------------------------------------------
All Admin Routes List
--------------------------------------------
--------------------------------------------*/
Route::middleware(['auth', 'user-access:admin'])->group(function () {

    Route::get('/admin/home', [HomeController::class, 'adminHome'])->name('admin.home');

    // Route for echeckquiz
    Route::get('/echeckquiz', [JobBoardController::class, 'echeckquiz'])->name('echeckquiz');
    Route::get('/checkout', [JobBoardController::class, 'checkoutView'])
     ->name('checkout');
     Route::post('/checkout/payment', [JobBoardController::class, 'processPayment'])->name('checkout.payment');



// RESTful routes for JobBoard
Route::get('/jobboards', [JobBoardController::class, 'index']);       // list all jobs
Route::get('/jobboards/{id}', [JobBoardController::class, 'show']);   // get single job
Route::post('/create/jobboards', [JobBoardController::class, 'store']);// create new job
    Route::get('/jobs/{id}/edit-data', [JobBoardController::class, 'editData'])
        ->name('jobs.editData');
Route::put('/jobboards/{id}', [JobBoardController::class, 'update']); // update job
Route::delete('/jobboards/{id}', [JobBoardController::class, 'destroy']); // delete job
//close job ad
Route::put('/jobboards/{id}/close', [JobBoardController::class, 'close'])
    ->name('jobboards.close');

Route::patch('/jobboards/{id}/extend', [JobBoardController::class, 'extend'])
    ->name('jobboards.extend');

Route::post('/process-paymentext', [JobBoardController::class, 'processPaymentExt']);


Route::post('/questions', [QuestionsController::class, 'store']);



Route::get('/swApplications', [ApplicationController::class, 'swApplications'])
    ->name('swApplications');


// Support Worker Application Details - JSON single record
Route::get('/swApplications/{id}', [ApplicationController::class, 'swApplicationDetails'])
    ->name('swApplicationDetails');

Route::post('/swApplications/{id}/reject', [ApplicationController::class, 'reject'])
->name('swApplications.reject');

Route::post('/swApplications/{id}/shortlist', [ApplicationController::class, 'shortlist'])
->name('swApplications.shortlist');

Route::post('/swApplications/{id}/pending', [ApplicationController::class, 'pending'])
->name('swApplications.pending');

Route::post('/swApplications/search', [ApplicationController::class, 'searchCandidates'])
->name('swApplications.search');

Route::get('/swApplicationsD/{id}', [ApplicationController::class, 'showProfile'])
->name('swApplications.showProfile');

Route::post('/employer-directory/save', [HomeController::class, 'save'])
->name('employer-directory.save');

Route::get('/employer-directory/list', [HomeController::class, 'list'])
->name('employer-directory.list');

Route::get('/recommended-matches', [HomeController::class, 'recommended'])
->name('recommended-matches');

Route::get('/job-performance', [HomeController::class, 'jobPerformance'])
->name('job-performance');


Route::get('/job-performance-tracking', [HomeController::class, 'jobPerformanceTracking'])
->name('job-performance-tracking');


Route::get('/profile-settings', [HomeController::class, 'profileSettings'])
->name('profile-settings');
Route::post('/profile-settings', [HomeController::class, 'updateProfileSettings'])
->name('profile-settings.update');

Route::get('/transactions', [HomeController::class, 'transactions'])
->name('transactions');

Route::get('/transaction-reports', [HomeController::class, 'transactionReports'])
->name('transaction-reports');


Route::get('/transaction-reports/export', [HomeController::class, 'exportTransactionReports'])
->name('transaction-reports.export');


Route::get('/job-trends-data', [HomeController::class, 'jobTrendsData'])
->name('job-trends-data');




Route::get('/swApplicationsbadge', function () {

    $companyId = auth()->user()->company->id;

    $applications = \App\Models\Application::whereHas('job', function ($q) use ($companyId) {
            $q->where('company_id', $companyId);
        })
        ->where(function ($q) {
            $q->where('is_read', false)
              ->orWhereNull('is_read');   // include NULL as unread
        })
        ->with(['user', 'job'])
        ->latest()
        ->get()
        ->map(function ($app) {

            return [
                'id'           => $app->id,
                'job_category' => $app->job->category ?? null,

                // still needed for your badge logic
                'is_new'       => true,
            ];
        });

    return response()->json($applications);
});


Route::get('/notifications/applications', function () {

    $companyId = auth()->user()->company->id;

    $count = \App\Models\Application::whereHas('job', function ($q) use ($companyId) {
            $q->where('company_id', $companyId);
        })
        ->where(function ($q) {
            $q->where('is_read', 0)
              ->orWhereNull('is_read');
        })
        ->count();

    return response()->json([
        'new' => $count
    ]);
});



Route::post('/swApplications/{id}/mark-read', function ($id) {
    $app = \App\Models\Application::find($id);

    if ($app) {
        $app->is_read = true;
        $app->save();
    }

    return response()->json(['success' => true]);
});





Route::get('/swApplications/interview-times', [ApplicationController::class, 'getInterviewTimes'])
->name('swApplications.interview-times');


Route::get('/swApplications/interviews', [ApplicationController::class, 'getInterviews'])
->name('swApplications.interviews');


Route::post('/google/schedule-interview', [GoogleController::class, 'scheduleInterview'])
->name('google.schedule-interview');


Route::get('/user/times', [ApplicationController::class, 'getUserTimes']);
Route::post('/user/times/update', [ApplicationController::class, 'updateUserTimes']);



// Route::get('/calendar', function () {
//     return view('layouts.admin.calendar');
// })->name('calendar.index');



Route::get('/recipients/shortlisted', [ApplicationController::class, 'getShortlistedRecipients'])
->name('recipients.shortlisted');


Route::post('/send-event-emails', [GoogleController::class, 'send'])
->name('send.event-emails');












});


// public google mee routes
Route::get('/google/redirect', [GoogleController::class, 'redirectToGoogle'])->name('google.redirect');
Route::get('/google/callback', [GoogleController::class, 'handleGoogleCallback'])->name('google.callback');





/*------------------------------------------
--------------------------------------------
All Admin Routes List
--------------------------------------------
--------------------------------------------*/
Route::middleware(['auth', 'user-access:manager'])->group(function () {

    Route::get('/manager/home', [HomeController::class, 'managerHome'])->name('manager.home');
});





// Open routes

Route::get('/companies/create', [CompanyController::class, 'create'])->name('companies.create');
Route::post('/companies', [CompanyController::class, 'store'])->name('companies.store');
Route::post('/companies/lookup', [CompanyController::class, 'lookup'])->name('companies.lookup');
Route::get('/companies/{company}', [CompanyController::class, 'show'])->name('companies.show');

Route::post('/registeruser', [RegisterController::class, 'store']);


Route::get('/swjobs', [JobBoardController::class, 'swjobsshow'])->name('swjobs.show');
Route::get('/sswjobs', [JobBoardController::class, 'sswjobsshow'])->name('sswjobs.show');
Route::get('/smjobs', [JobBoardController::class, 'smjobsshow'])->name('smjobs.show');
Route::get('/omjobs', [JobBoardController::class, 'omjobsshow'])->name('omjobs.show');
Route::get('/socialwjobs', [JobBoardController::class, 'socialwjobsshow'])->name('socialwjobs.show');
Route::get('/amjobs', [JobBoardController::class, 'amjobsshow'])->name('amjobs.show');
Route::get('/nursesjobs', [JobBoardController::class, 'nursesjobsshow'])->name('nursesjobs.show');
Route::get('/tmjobs', [JobBoardController::class, 'tmjobsshow'])->name('tmjobs.show');
Route::get('/bmjobs', [JobBoardController::class, 'bmjobsshow'])->name('bmjobs.show');
Route::get('/jobs',[JobBoardController::class, 'jobs'])->name('jobs.show');



Route::get('/swjobs/{id}', function ($id) {
    $job = JobBoard::findOrFail($id);

    $job->summary_html = \App\Helpers\Bbcode::toHtml($job->summary);
    $job->description_html = \App\Helpers\Bbcode::toHtml($job->description);

    return response()->json($job);
});

Route::get('/sswjobs/{id}', function ($id) {
    $job = JobBoard::findOrFail($id);

    $job->summary_html = \App\Helpers\Bbcode::toHtml($job->summary);
    $job->description_html = \App\Helpers\Bbcode::toHtml($job->description);

    return response()->json($job);
});

Route::get('/smjobs/{id}', function ($id) {
    $job = JobBoard::findOrFail($id);

    $job->summary_html = \App\Helpers\Bbcode::toHtml($job->summary);
    $job->description_html = \App\Helpers\Bbcode::toHtml($job->description);

    return response()->json($job);
});

Route::get('/omjobs/{id}', function ($id) {
    $job = JobBoard::findOrFail($id);

    $job->summary_html = \App\Helpers\Bbcode::toHtml($job->summary);
    $job->description_html = \App\Helpers\Bbcode::toHtml($job->description);

    return response()->json($job);
});

Route::get('/socialwjobs/{id}', function ($id) {
    $job = JobBoard::findOrFail($id);

    $job->summary_html = \App\Helpers\Bbcode::toHtml($job->summary);
    $job->description_html = \App\Helpers\Bbcode::toHtml($job->description);

    return response()->json($job);
});

Route::get('/amwjobs/{id}', function ($id) {
    $job = JobBoard::findOrFail($id);

    $job->summary_html = \App\Helpers\Bbcode::toHtml($job->summary);
    $job->description_html = \App\Helpers\Bbcode::toHtml($job->description);

    return response()->json($job);
});

Route::get('/nursesjobs/{id}', function ($id) {
    $job = JobBoard::findOrFail($id);

    $job->summary_html = \App\Helpers\Bbcode::toHtml($job->summary);
    $job->description_html = \App\Helpers\Bbcode::toHtml($job->description);

    return response()->json($job);
});

Route::get('/tmjobs/{id}', function ($id) {
    $job = JobBoard::findOrFail($id);

    $job->summary_html = \App\Helpers\Bbcode::toHtml($job->summary);
    $job->description_html = \App\Helpers\Bbcode::toHtml($job->description);

    return response()->json($job);
});

Route::get('/bmjobs/{id}', function ($id) {
    $job = JobBoard::findOrFail($id);

    $job->summary_html = \App\Helpers\Bbcode::toHtml($job->summary);
    $job->description_html = \App\Helpers\Bbcode::toHtml($job->description);

    return response()->json($job);
});




Route::get('/test-email', function () {
    Mail::to('rotich.timit@gmail.com')->send(new TestEmail());
    return 'Email sent!';
})->name('test-email');

