<script src="https://js.stripe.com/v3/"></script>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<table class="table table-striped">
    <thead>
    <tr>
        <th>Job ID</th>
        <th>Category</th>
        <th>Date Published</th>
        <th>Expiring In</th>
        <th>Expiry Date</th>
        <th>Status</th>
     
    </tr>
    </thead>
    <tbody>

<?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr style="cursor:pointer;"
        onclick="openactiveadDetailsCanvase(<?php echo e(json_encode($job)); ?>)">
        <td><?php echo e($job->id); ?></td>
        <td><?php echo e($job->category); ?></td>
        <td><?php echo e($job->created_at->format('d M Y')); ?></td>
        <td><?php echo e(round(abs(\Carbon\Carbon::parse($job->expiry_date)->diffInDays($job->created_at, false)))); ?> days</td>
        <td><?php echo e($job->expiry_date); ?></td>
        <td>
            <?php switch($job->status):
                case ('active'): ?>
                    <span class="badge bg-primary">Active</span>
                    <?php break; ?>

                <?php case ('open'): ?>
                    <span class="badge bg-success">Open</span>
                    <?php break; ?>

                <?php case ('expired'): ?>
                    <span class="badge bg-danger">Expired</span>
                    <?php break; ?>

                <?php case ('closed'): ?>
                    <span class="badge bg-secondary">Closed</span>
                    <?php break; ?>

                <?php default: ?>
                    <span class="badge bg-dark"><?php echo e(ucfirst($job->status)); ?></span>
            <?php endswitch; ?>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </tbody>
</table>


 
<div class="offcanvas offcanvas-end offcanvas-75 shadow-lg rounded-start" tabindex="-1" id="openadDetailsCanvase">
    <div class="offcanvas-header bg-gradient-primary text-white py-3 px-4">
        <h5 class="offcanvas-title fw-bold">
            <i class="fa fa-info-circle me-2"></i> Ad Details
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body p-4 bg-light">

        <div class="row mb-3 align-items-center justify-content-between">
    <!-- Left side: Title -->
    <div class="col-auto">
        <h6 class="fw-bold text-primary mb-0">
            <i class="fa fa-list me-2"></i> Job Ad Information
        </h6>
    </div>

    <!-- Right side: Expiry Button -->
    <div class="col-auto">
        <button class="btn btn-outline-danger btn-sm fw-semibold">
            Expiring in: <span id="days_left_dispalye">30</span> Days
        </button>
    </div>
</div>


        <div>
            <hr>
        </div>

        <div>
            <row class="mb-4">
                <div class="col">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="offcanvas">
                        <i class="fa fa-arrow-left me-2"></i> Back to Job Listings
                    </button>
                    <!-- Edit Job Ad Button -->





<!-- Delete button -->
<button id="deleteBtn" type="button" class="btn btn-danger btn-sm ms-2" onclick="deleteAd()">
  <i class="fa fa-trash me-2"></i> Delete Job Ad
</button>

                    
    <!-- Close Job Ad button -->
<button id="closeBtn" type="button" class="btn btn-warning btn-sm ms-2" onclick="closeAd()">
  <i class="fa fa-times me-2"></i> Close Job Ad
</button>

    <button type="button" class="btn btn-info btn-sm ms-2" onclick="openExtendedPeriodPanel()">
    <i class="fa fa-refresh me-2"></i> Renew Job Ad
</button>


                    
                </div>
            </row>
        </div>

        <br>

        <div class="row g-4">
            <!-- Ad Type -->
<div class="col-md-12">
    <div class="card" 
         style="border: none; border-radius: 16px; 
                background: linear-gradient(135deg, #f0f8ff, #e6f7ff); 
                box-shadow: 0 8px 20px rgba(0,0,0,0.15); 
                transition: all 0.4s ease; overflow: hidden;">
        <div class="card-body d-flex align-items-center justify-content-between" 
             style="dispalye: flex; align-items: center; justify-content: space-between; padding: 20px;">
            
            <!-- Left side: Icon + Title -->
            <div style="dispalye: flex; align-items: center; gap: 14px;">
              
                <div>
                    <h5 style="margin: 0; font-weight: 700; 
                               background: linear-gradient(90deg, #007bff, #00c6ff); 
                               -webkit-background-clip: text; 
                               -webkit-text-fill-color: transparent;">
                        Ad Type
                    </h5>
                    <p id="ad_type_dispalye" 
                       style="margin: 0; font-size: 1.1rem; font-weight: 600; color: #333;">
                        Basic
                    </p>
                </div>
            </div>

            <!-- Right side: Status badge -->
            <span id="ad_status_displaye" style="background: linear-gradient(90deg, #36c95f, #2f8f4e); 
                         color: #fff; font-weight: 600; 
                         padding: 8px 16px; border-radius: 20px; 
                         box-shadow: 0 4px 12px rgba(47,143,78,0.4); 
                         font-size: 0.9rem; letter-spacing: 0.5px;">
           Status
            </span>
        </div>
    </div>
</div>



            <!-- Job Title -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Job Title</h5>
                        <p class="card-text" id="job_title_dispalye">Software Engineer</p>
                    </div>
                </div>
            </div>

            <!-- Company -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Company</h5>
                        <p class="card-text" id="company_dispalye">Tech Solutions Inc.</p>
                    </div>
                </div>
            </div>

            <!-- Category -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Category</h5>
                        <p class="card-text" id="category_dispalye">Information Technology</p>
                    </div>
                </div>
            </div>

            <!-- Location -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Location</h5>
                        <p class="card-text" id="location_dispalye">New York, NY</p>
                    </div>
                </div>
            </div>

            <!-- Workplace -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Workplace</h5>
                        <p class="card-text" id="workplace_dispalye">Remote</p>
                    </div>
                </div>
            </div>

            <!-- Type of Work -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Type of Work</h5>
                        <p class="card-text" id="work_type_dispalye">Full-time</p>
                    </div>
                </div>
            </div>

            <!-- Pay Type -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Pay Type</h5>
                        <p class="card-text" id="pay_type_dispalye">Hourly</p>
                    </div>
                </div>
            </div>

            <!-- Pay Min -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Pay Min</h5>
                        <p class="card-text" id="pay_min_dispalye">$25</p>
                    </div>
                </div>
            </div>

            <!-- Pay Max -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Pay Max</h5>
                        <p class="card-text" id="pay_max_dispalye">$40</p>
                    </div>
                </div>
            </div>

            <!-- Pay Visibility -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Pay Visibility</h5>
                        <p class="card-text" id="pay_visibility_dispalye">Visible</p>
                    </div>
                </div>
            </div>

            <!-- Job Description -->
            <div class="col-md-12">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Job Description</h5>
                      <div id="description_dispalye"></div>
                        
                    </div>
                </div>
            </div>

            <!-- Job Summary -->
            <div class="col-md-12">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Job Summary</h5>
              <div id="summary_dispalye"></div>
                        
                    </div>
                </div>
            </div>

        <!-- Logo -->
<div class="col-md-6" id="logo_field_dispalye">
    <div class="card shadow-sm">
        <div class="card-body text-center">
            <h5 class="card-title">Logo</h5>
            <img id="logo_dispalye" src="" alt="Company Logo" 
                 style="max-width: 150px; height: auto; border-radius: 8px;">
        </div>
    </div>
</div>

<!-- Overview -->
<div class="col-md-6" id="overview_field_dispalye">
    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="card-title">Overview</h5>
            <p class="card-text" id="overview_dispalye"></p>
        </div>
    </div>
</div>

<!-- Social Media -->
<div class="col-md-6" id="social_media_field_dispalye">
    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="card-title">Social Media</h5>
            <p class="card-text" id="social_media_dispalye"></p>
        </div>
    </div>
</div>

<!-- Video -->
<div class="col-md-6" id="video_field_dispalye">
    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="card-title">Video</h5>
            <a id="video_dispalye" href="#" target="_blank">Watch Video</a>
        </div>
    </div>
</div>


            <!-- Questions -->
     <div class="col-md-12">
  <div class="card shadow-sm">
    <div class="card-body">
      <h5 class="card-title">Questions to Candidates</h5>
      <div id="questionsWrappere" class="row">
        <!-- Questions will be injected here -->
      </div>
    </div>
  </div>
</div>

        </div>

        <!-- Close Button -->
        <div class="mt-4 text-end">
            <button type="button" class="btn btn-danger" data-bs-dismiss="offcanvas">Close</button>
        </div>
    </div>
</div>






<style>
    /* Slide-in animation */
.swal2-offcanvas {
    animation: epanelSlideIn 0.35s ease-out;
    border-radius: 0;
    height: 100vh;
    overflow: hidden;
    padding: 0;
}

@keyframes epanelSlideIn {
    from { transform: translateX(100%); opacity: 0; }
    to { transform: translateX(0); opacity: 1; }
}

/* Popup container */
.epanel-popup {
    border-radius: 0;
    padding: 0 !important;
    overflow: hidden;
    box-shadow: -4px 0 12px rgba(0,0,0,0.15);
}

/* Header styling */
.epanel-title {
    background: rgb(113,16,62) !important;
    color: white !important;
    font-size: 1.2rem !important;
    font-weight: 600 !important;
    text-align: left !important;
}

/* Body styling */
.epanel-body {
    padding: 20px;
}

.epanel-label {
    font-weight: 600;
    color: #4a4a4a;
}

.epanel-select {
    border-radius: 6px;
    border: 1px solid #ccc;
}

/* Buttons */
.epanel-confirm {
    background: rgb(113,16,62) !important;
    border: none !important;
    padding: 10px 20px !important;
    border-radius: 6px !important;
    font-weight: 600 !important;
}

.epanel-cancel {
    background: #ddd !important;
    color: #333 !important;
    border-radius: 6px !important;
    padding: 10px 20px !important;
    font-weight: 600 !important;
}

/* Pricing table container */
/* Pricing table container */
.pricing-row {
    display: flex;
    gap: 10px;
    justify-content: space-between;
}

/* Each card */
.pricing-card {
    flex: 1;
    border: 1px solid #e5e5e5;
    border-radius: 12px;
    padding: 12px 10px;
    cursor: pointer;
    transition: 0.25s ease;
    background: linear-gradient(180deg, #ffffff 0%, #faf7f8 100%);
    text-align: center;
    position: relative;
    box-shadow: 0 1px 3px rgba(0,0,0,0.05);
}

/* Hover effect */
.pricing-card:hover {
    border-color: rgb(113,16,62);
    box-shadow: 0 6px 14px rgba(113,16,62,0.15);
    transform: translateY(-3px);
}

/* Hide radio input */
.pricing-card input {
    display: none;
}

/* Selected state */
.pricing-card input:checked + .pricing-content {
    background: rgba(113,16,62,0.10);
    border: 1px solid rgb(113,16,62);
    box-shadow: 0 0 0 3px rgba(113,16,62,0.25);
    transform: scale(1.02);
}

/* Inner content */
.pricing-content {
    border-radius: 10px;
    padding: 10px 6px;
    transition: 0.25s ease;
}

/* Title */
.pricing-content h4 {
    margin: 0;
    font-size: 0.85rem;
    font-weight: 700;
    color: rgb(113,16,62);
    letter-spacing: 0.3px;
}

/* Price */
.price {
    margin-top: 6px;
    font-size: 0.95rem;
    font-weight: 700;
    color: #222;
}

/* Features (optional small text) */
.features {
    margin-top: 6px;
    font-size: 0.75rem;
    color: #666;
    line-height: 1.2;
}

.selected-badge {
    display: none;
    position: absolute;
    top: -8px;
    right: -8px;
    background: rgb(113,16,62);
    color: white;
    font-size: 0.65rem;
    font-weight: 700;
    padding: 3px 8px;
    border-radius: 12px;
    box-shadow: 0 2px 6px rgba(113,16,62,0.3);
    z-index: 5;
}

.feature-list {
    background: #fafafa;
    border: 1px solid #e5e5e5;
    border-radius: 10px;
    padding: 12px;
    margin-top: 12px;
}

.feature-title {
    font-size: 0.85rem;
    font-weight: 700;
    color: rgb(113,16,62);
    margin-bottom: 6px;
}

.feature-ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.feature-ul li {
    font-size: 0.78rem;
    color: #444;
    margin-bottom: 4px;
    display: flex;
    align-items: center;
}

.feature-ul li i {
    color: rgb(113,16,62);
    margin-right: 6px;
    font-size: 0.75rem;
}
.swal2-offcanvas-left {
    animation: slideInLeft 0.35s ease-out;
    height: 100vh;
    border-radius: 0;
    padding: 0 !important;
}

@keyframes slideInLeft {
    from { transform: translateX(-100%); opacity: 0; }
    to { transform: translateX(0); opacity: 1; }
}

.summary-box {
    background: #fafafa;
    border: 1px solid #e5e5e5;
    border-radius: 10px;
    padding: 15px;
}

.summary-title {
    font-size: 1rem;
    font-weight: 700;
    color: rgb(113,16,62);
    margin-bottom: 10px;
}

.summary-row {
    display: flex;
    justify-content: space-between;
    margin-bottom: 6px;
    font-size: 0.85rem;
}

.summary-row.total {
    margin-top: 10px;
    font-size: 1rem;
    font-weight: 700;
    color: rgb(113,16,62);
}

.swal2-offcanvas-right {
    animation: slideInRight 0.35s ease-out;
    height: 100vh;
    border-radius: 0;
    padding: 0 !important;
}

@keyframes slideInRight {
    from { transform: translateX(100%); opacity: 0; }
    to { transform: translateX(0); opacity: 1; }
}

.payment-panel {
    padding: 10px;
}

.summary-box {
    background: #fafafa;
    border: 1px solid #e5e5e5;
    border-radius: 10px;
    padding: 12px;
}

.summary-title {
    font-size: 1rem;
    font-weight: 700;
    color: rgb(113,16,62);
    margin-bottom: 8px;
}

.summary-row {
    display: flex;
    justify-content: space-between;
    font-size: 0.85rem;
    margin-bottom: 4px;
}

.summary-row.total {
    margin-top: 8px;
    font-size: 1rem;
    font-weight: 700;
    color: rgb(113,16,62);
}

.custom-input {
    width: 100% !important;
    margin: 5px 0 !important;
}

.card-row {
    display: flex;
    gap: 10px;
}



</style>



<script>

function openactiveadDetailsCanvase(ad) {
    console.log(ad);

    sessionStorage.setItem('selectedAd', JSON.stringify(ad));

    console.log("Ad data saved to sessionStorage.", ad);    



    // Populate the fields with the ad details
    document.getElementById('ad_status_displaye').innerText = ad.status || 'N/A';
    document.getElementById('ad_type_dispalye').innerText = ad.ad_type || 'N/A';
    document.getElementById('job_title_dispalye').innerText = ad.job_title || 'N/A';
    document.getElementById('company_dispalye').innerText = ad.company || 'N/A';
    document.getElementById('category_dispalye').innerText = ad.category || 'N/A';
    document.getElementById('location_dispalye').innerText = ad.location || 'N/A';
    document.getElementById('workplace_dispalye').innerText = ad.workplace || 'N/A';
    document.getElementById('work_type_dispalye').innerText = ad.work_type || 'N/A';
    document.getElementById('pay_type_dispalye').innerText = ad.pay_type || 'N/A';
    document.getElementById('pay_min_dispalye').innerText = ad.pay_min !== undefined ? `$${ad.pay_min}` : 'N/A';
    document.getElementById('pay_max_dispalye').innerText = ad.pay_max !== undefined ? `$${ad.pay_max}` : 'N/A';
    document.getElementById('pay_visibility_dispalye').innerText = ad.pay_visibility || 'N/A';
    document.getElementById('description_dispalye').innerHTML = ad.description_html || 'N/A';
    document.getElementById('summary_dispalye').innerHTML = ad.summary_html || 'N/A';

    // --- Conditional dispalye based on ad_type ---
    const logoField = document.getElementById('logo_field_dispalye');
    const overviewField = document.getElementById('overview_field_dispalye');
    const socialField = document.getElementById('social_media_field_dispalye');
    const videoField = document.getElementById('video_field_dispalye');
 

    // Hide all by default
    logoField.style.dispalye = 'none';
    overviewField.style.dispalye = 'none';
    socialField.style.dispalye = 'none';
    videoField.style.dispalye = 'none';

    if (ad.ad_type === "basic") {
        // Show only overview + social
        // overviewField.style.dispalye = 'block';
        // socialField.style.dispalye = 'block';
    } else if (ad.ad_type === "premium") {
        // Show logo, overview, social (hide video)
        logoField.style.dispalye = 'block';
        overviewField.style.dispalye = 'block';
        socialField.style.dispalye = 'block';
    } else if (ad.ad_type === "platinum") {
        // Show everything
        logoField.style.dispalye = 'block';
        overviewField.style.dispalye = 'block';
        socialField.style.dispalye = 'block';
        videoField.style.dispalye = 'block';
    }

    // --- Populate values ---
    // Logo (image)
    if (ad.logo) {
        const logoImg = document.getElementById('logo_dispalye');
        logoImg.src = ad.logo;
        logoImg.alt = ad.company || "Company Logo";
    }

    // Overview
    if (ad.overview) {
        document.getElementById('overview_dispalye').innerText = ad.overview;
    }

    // Social Media
    if (ad.social_media) {
        document.getElementById('social_media_dispalye').innerText = ad.social_media;
    }

    // Video
    if (ad.video) {
        document.getElementById('video_dispalye').href = ad.video;
        document.getElementById('video_dispalye').innerText = "Watch Video";
    }

    // --- Days left until expiry ---
    const today = new Date();
    const expiryDate = new Date(ad.expiry_date);
    const timeDiff = expiryDate - today;
    const daysLeft = Math.ceil(timeDiff / (1000 * 60 * 60 * 24));
    document.getElementById('days_left_dispalye').innerText = daysLeft > 0 ? daysLeft : '0';
  // --- Populate Questions ---// --- Populate questions ---
const questionsWrapper = document.getElementById('questionsWrappere');
questionsWrapper.innerHTML = ''; // Clear previous questions

const questions = ad.questions || [];

// Split into two roughly equal halves
const half = Math.ceil(questions.length / 2);
const col1 = questions.slice(0, half);
const col2 = questions.slice(half);

// Create column containers
const col1Div = document.createElement('div');
col1Div.className = 'col-md-6';
const col2Div = document.createElement('div');
col2Div.className = 'col-md-6';

// Add questions with ticks
col1.forEach(question => {
  const p = document.createElement('p');
  p.innerHTML = `<i class="fa fa-check text-success me-2"></i> ${question.label}`;
  col1Div.appendChild(p);
});

col2.forEach(question => {
  const p = document.createElement('p');
  p.innerHTML = `<i class="fa fa-check text-success me-2"></i> ${question.label}`;
  col2Div.appendChild(p);
});

// Append both columns to wrapper
questionsWrapper.appendChild(col1Div);
questionsWrapper.appendChild(col2Div);



    // --- Show the ad details canvas ---
    const offcanvas = new bootstrap.Offcanvas(document.getElementById('openadDetailsCanvase'));
    offcanvas.show();
}

function closeOtherOffcanvas() {
    // Close Ad Details offcanvas if open
    const openadDetailsCanvas = bootstrap.Offcanvas.getInstance(document.getElementById('openadDetailsCanvase'));
      if (openadDetailsCanvas) openadDetailsCanvas.hide();

    // Close Active Jobs offcanvas if open
    const jobOffcanvas = bootstrap.Offcanvas.getInstance(document.getElementById('jobOffcanvas-active'));
  
    if (jobOffcanvas) jobOffcanvas.hide();
}








// Function to collect updated data
function saveAdChanges() {
    const saveBtn = document.getElementById('saveBtn');

    // Disable button and show circle spinner inside it
    saveBtn.disabled = true;
    saveBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span> Saving Changes...';

    // Retrieve the selected ad
    const adData = sessionStorage.getItem('selectedAd');
    const originalAd = adData ? JSON.parse(adData) : {};

    const updatedAd = {
        id:            originalAd.id,
        workplace:     document.getElementById('edit_workplace').value.trim(),
        work_type:     document.getElementById('edit_work_type').value.trim(),
        pay_type:      document.getElementById('edit_pay_type').value.trim(),
        pay_min:       parseFloat(document.getElementById('edit_pay_min').value) || null,
        pay_max:       parseFloat(document.getElementById('edit_pay_max').value) || null,
        description:   document.getElementById('edit_description').value.trim(),
        summary:       document.getElementById('edit_summary').value.trim(),
        logo:          document.getElementById('edit_logo').value.trim(),
        social_media:  document.getElementById('edit_social_media').value.trim(),
        video:         document.getElementById('edit_video').value.trim(),
        overview:      document.getElementById('edit_overview').value.trim()
    };

    fetch(`/jobboards/${updatedAd.id}`, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify(updatedAd)
    })
    .then(res => {
        if (!res.ok) throw new Error(`Server error: ${res.status}`);
        return res.json();
    })
    .then(data => {
        Notiflix.Notify.success('Job updated successfully!');
        sessionStorage.setItem('selectedAd', JSON.stringify(updatedAd));

        // Close offcanvas and redirect
        const offcanvasEl = document.getElementById('editAdCanvas');
        const offcanvas = bootstrap.Offcanvas.getInstance(offcanvasEl);
        if (offcanvas) offcanvas.hide();
        window.location.href = '/admin/home';
    })
    .catch(err => {
        Notiflix.Notify.failure(`Update failed: ${err.message}`);
    })
    .finally(() => {
        // Restore button state
        saveBtn.disabled = false;
        saveBtn.innerHTML = '<i class="fa fa-save me-2"></i> Save Changes';
    });
}

// Function to delete the selected ad
function deleteAd() {
    const adData = sessionStorage.getItem('selectedAd');
    const ad = adData ? JSON.parse(adData) : null;

    if (!ad || !ad.id) {
        Notiflix.Notify.failure('No job ad selected to delete.');
        return;
    }

    // Fancy Confirm dialog
    Notiflix.Confirm.show(
        // Title with FA icon
        '<i class="fa fa-exclamation-triangle text-danger me-2"></i> <span style="color:#dc3545;font-weight:bold;">Confirm Delete</span>',
        
        // Message with styled text
        '<span style="font-size:15px;color:#333;">Are you sure you want to <b style="color:#dc3545;">delete</b> this job ad?</span>',
        
        // OK button text with FA icon
        '<i class="fa fa-trash me-2"></i> Yes, Delete',
        
        // Cancel button text with FA icon
        '<i class="fa fa-times me-2"></i> Cancel',
        
        function okCb() {
            // Configure loader appearance
            Notiflix.Loading.init({
                svgSize: '36px',
                messageFontSize: '14px',
                cssAnimationDuration: 4000
            });

            // Show dotted circle loader
            Notiflix.Loading.circle('Deleting job ad...');

            const start = Date.now();
            const minDuration = 3000; // 3 seconds minimum

            fetch(`/jobboards/${ad.id}`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(res => {
                if (!res.ok) throw new Error(`Server error: ${res.status}`);
                return res.json();
            })
            .then(data => {
                const elapsed = Date.now() - start;
                const remaining = Math.max(0, minDuration - elapsed);

                setTimeout(() => {
                    Notiflix.Loading.remove();
                    Notiflix.Notify.init({
                        timeout: 3000,
                        clickToClose: true,
                        pauseOnHover: true
                    });
                    Notiflix.Notify.success('Job ad deleted successfully!');
                    sessionStorage.removeItem('selectedAd');
                    window.location.href = '/admin/home';
                }, remaining);
            })
            .catch(err => {
                const elapsed = Date.now() - start;
                const remaining = Math.max(0, minDuration - elapsed);

                setTimeout(() => {
                    Notiflix.Loading.remove();
                    Notiflix.Notify.failure(`Delete failed: ${err.message}`);
                }, remaining);
            });
        },
        function cancelCb() {
            Notiflix.Notify.info('Delete cancelled.');
        },
        {
            // Extra styling for buttons
            okButtonBackground: '#dc3545',   // red delete button
            okButtonColor: '#fff',
            cancelButtonBackground: '#6c757d', // grey cancel button
            cancelButtonColor: '#fff',
            borderRadius: '8px',
            width: '360px'
        }
    );
}


// Function to close other offcanvas elements
function closeAd() {
    const adData = sessionStorage.getItem('selectedAd');
    const ad = adData ? JSON.parse(adData) : null;

    if (!ad || !ad.id) {
        Notiflix.Notify.failure('No job ad selected to close.');
        return;
    }

    // Fancy confirm dialog
    Notiflix.Confirm.show(
        '<i class="fa fa-exclamation-circle text-warning me-2"></i> <span style="color:#ffc107;font-weight:bold;">Confirm Close</span>',
        '<span style="font-size:15px;color:#333;">Are you sure you want to <b style="color:#ffc107;">close</b> this job ad?</span>',
        '<i class="fa fa-check me-2"></i> Yes, Close',
        '<i class="fa fa-times me-2"></i> Cancel',
        function okCb() {
            // Show loader
            Notiflix.Loading.init({
                svgSize: '36px',
                messageFontSize: '14px'
            });
            Notiflix.Loading.circle('Closing job ad...');

            fetch(`/jobboards/${ad.id}/close`, {
                method: 'PUT',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(res => {
                if (!res.ok) throw new Error(`Server error: ${res.status}`);  
                return res.json();
            })
            .then(data => {
                Notiflix.Loading.remove();
                Notiflix.Notify.init({
                    timeout: 3000,
                    clickToClose: true,
                    pauseOnHover: true
                });
                Notiflix.Notify.success('Job ad closed successfully!');
                // Optionally redirect
                window.location.href = '/admin/home';
            })
            .catch(err => {
                Notiflix.Loading.remove();
                Notiflix.Notify.failure(`Close failed: ${err.message}`);
            });
        },
        function cancelCb() {
            Notiflix.Notify.info('Close cancelled.');
        },
        {
            okButtonBackground: '#ffc107',   // yellow close button
            okButtonColor: '#000',
            cancelButtonBackground: '#6c757d',
            cancelButtonColor: '#fff',
            borderRadius: '8px',
            width: '360px'
        }
    );
}

function forceCloseOffcanvas(id) {
    const el = document.getElementById(id);
    if (!el) return;

    // Get existing instance OR create one if missing
    let instance = bootstrap.Offcanvas.getInstance(el);
    if (!instance) {
        instance = new bootstrap.Offcanvas(el);
    }

    instance.hide();

    // Remove leftover backdrop if Bootstrap bug leaves it behind
    document.querySelectorAll('.offcanvas-backdrop').forEach(b => b.remove());
}
// function openExtendedPeriodPanel() {

//     closeOtherOffcanvas();
//     forceCloseOffcanvas('jobOffcanvas-expired');

//     Swal.fire({
//         title: 'Extend Job Duration',
//         html: `
//             <div class="epanel-body">

//                 <label class="form-label epanel-label">Select Duration</label>
//                 <select id="extendedPeriodSelect" class="form-select epanel-select mt-2">
//                     <optgroup label="Weeks">
//                         <option value="1_week">1 week</option>
//                         <option value="2_weeks">2 weeks</option>
//                         <option value="3_weeks">3 weeks</option>
//                     </optgroup>
//                     <optgroup label="Months">
//                         <option value="1_month">1 month</option>
//                         <option value="2_months">2 months</option>
//                         <option value="3_months">3 months</option>
//                         <option value="4_months">4 months</option>
//                         <option value="5_months">5 months</option>
//                         <option value="6_months">6 months</option>
//                         <option value="7_months">7 months</option>
//                         <option value="8_months">8 months</option>
//                         <option value="9_months">9 months</option>
//                         <option value="10_months">10 months</option>
//                         <option value="11_months">11 months</option>
//                         <option value="12_months">12 months</option>
//                     </optgroup>
//                 </select>

//                 <div id="pricingTable" class="pricing-table mt-4"></div>
//                 <div id="featureList" class="feature-list mt-3"></div>

//             </div>
//         `,
//         showCancelButton: true,
//         confirmButtonText: '<i class="fa fa-save me-2"></i> Proceed to Payment',
//         cancelButtonText: '<i class="fa fa-times me-2"></i> Cancel',
//         customClass: {
//             popup: 'swal2-offcanvas epanel-popup',
//             title: 'epanel-title',
//             confirmButton: 'epanel-confirm',
//             cancelButton: 'epanel-cancel'
//         },
//         backdrop: false,
//         position: 'top-end',
//         width: '420px',
//         didOpen: () => {
//             const popup = Swal.getPopup();
//             popup.querySelector('#extendedPeriodSelect')
//                 .addEventListener('change', updatePricingTable);

//             updatePricingTable();
//         }
//     }).then(result => {
//         if (!result.isConfirmed) return;

//         const popup = Swal.getPopup();
//    const duration = popup.querySelector('#extendedPeriodSelect')?.value;
// const adType = adTypeInput.value;
// const price = adTypeInput.dataset.price;

// // Save for later use
// sessionStorage.setItem("extend_duration", duration);
// sessionStorage.setItem("extend_adType", adType);
// sessionStorage.setItem("extend_price", price);

//         if (!duration || !adTypeInput) {
//             Notiflix.Notify.failure('Please select duration and ad type.');
//             return;
//         }

//         const adType = adTypeInput.value;
//         const price = adTypeInput.dataset.price;

//         openPaymentPanel(duration, adType, price);
//     });
// }


// /* ---------- Pricing table + features ---------- */

// function updatePricingTable() {
//     const popup = Swal.getPopup();
//     if (!popup) return;

//     const duration = popup.querySelector('#extendedPeriodSelect')?.value;
//     const pricingDiv = popup.querySelector('#pricingTable');

//     if (!duration || !pricingDiv) return;

//     const isMonthly = duration.includes('month');

//     // Extract number (e.g., "2_weeks" → 2)
//     const multiplier = parseInt(duration);

//     const weeklyPrices = {
//         basic: 10.99,
//         premium: 24.99,
//         platinum: 49.99
//     };

//     const monthlyPrices = {
//         basic: 49.99,
//         premium: 99.99,
//         platinum: 199.99
//     };

//     const basePrices = isMonthly ? monthlyPrices : weeklyPrices;

//     const prices = {
//         basic: basePrices.basic * multiplier,
//         premium: basePrices.premium * multiplier,
//         platinum: basePrices.platinum * multiplier
//     };

//     pricingDiv.innerHTML = `
//         <div class="pricing-row">
//             ${createPricingCard('Basic', prices.basic, 'basic')}
//             ${createPricingCard('Premium', prices.premium, 'premium')}
//             ${createPricingCard('Platinum', prices.platinum, 'platinum')}
//         </div>
//     `;

//     // Re-bind change handlers for radios (because we just re-rendered)
//     popup.querySelectorAll('input[name="adType"]').forEach(input => {
//         input.addEventListener('change', () => {
//             updateSelectedBadge();
//             updateFeatureList(input.value);
//         });
//     });

//     // Clear feature list when duration changes (until user re-selects ad type)
//     const featureDiv = popup.querySelector('#featureList');
//     if (featureDiv) featureDiv.innerHTML = '';
// }

// function createPricingCard(title, price, key) {
//     return `
//         <label class="pricing-card">
//             <input type="radio" name="adType" value="${key}" data-price="${price.toFixed(2)}">
//             <div class="pricing-content">
//                 <div class="selected-badge">Selected</div>
//                 <h4>${title}</h4>
//                 <div class="price">$${price.toFixed(2)}</div>
//             </div>
//         </label>
//     `;
// }

// function updateSelectedBadge() {
//     const popup = Swal.getPopup();
//     if (!popup) return;

//     popup.querySelectorAll('.selected-badge').forEach(badge => {
//         badge.style.display = 'none';
//     });

//     const selected = popup.querySelector('input[name="adType"]:checked');
//     if (selected) {
//         const badge = selected.parentElement.querySelector('.selected-badge');
//         if (badge) badge.style.display = 'block';
//     }
// }

// function updateFeatureList(plan) {
//     const popup = Swal.getPopup();
//     if (!popup) return;

//     const featureDiv = popup.querySelector('#featureList');
//     if (!featureDiv) return;

//     const features = {
//         basic: [
//             'Extended exclusive job description',
//             'Exclusive job summary'
//         ],
//         premium: [
//             'Extended exclusive job description',
//             'Exclusive job summary',
//             'Exclusive video conferencing',
//             'Featured listing',
//             'Applicant tracking system'
//         ],
//         platinum: [
//             'Extended exclusive job description',
//             'Exclusive job summary',
//             'Exclusive video conferencing',
//             'Featured listing',
//             'Applicant tracking system',
//             'Video job description',
//             'Priority support',
//             'Custom branding',
//             'Job ad analytics',
//             'Candidate matching'
//         ]
//     };

//     const selected = features[plan] || [];

//     featureDiv.innerHTML = `
//         <div class="feature-title">Included Features</div>
//         <ul class="feature-ul">
//             ${selected
//                 .map(
//                     f => `<li><i class="fa fa-check"></i> ${f}</li>`
//                 )
//                 .join('')}
//         </ul>
//     `;
// }

// function openPaymentPanel(duration, adType, price) {

//     Swal.fire({
//         title: 'Confirm Payment',
//         html: `
//             <div class="epanel-body">

//                 <div class="summary-box">
//                     <h4 class="summary-title">Order Summary</h4>

//                     <div class="summary-row">
//                         <span>Duration:</span>
//                         <strong>${duration.replace('_', ' ')}</strong>
//                     </div>

//                     <div class="summary-row">
//                         <span>Ad Type:</span>
//                         <strong>${adType.charAt(0).toUpperCase() + adType.slice(1)}</strong>
//                     </div>

//                     <div class="summary-row total">
//                         <span>Total Price:</span>
//                         <strong>$${price}</strong>
//                     </div>
//                 </div>

//                 <p class="mt-3" style="font-size:0.85rem;color:#555;">
//                     You will be redirected to our secure payment gateway to complete your purchase.
//                 </p>

//             </div>
//         `,
//         showCancelButton: true,
//         confirmButtonText: '<i class="fa fa-credit-card me-2"></i> Pay Now',
//         cancelButtonText: '<i class="fa fa-arrow-left me-2"></i> Back',
//         customClass: {
//             popup: 'swal2-offcanvas-left epanel-popup',
//             title: 'epanel-title',
//             confirmButton: 'epanel-confirm',
//             cancelButton: 'epanel-cancel'
//         },
//         backdrop: false,
//         position: 'top-start',
//         width: '420px'
//     }).then(result => {
//         if (result.isConfirmed) {
//             // Redirect to Stripe Checkout
//             startStripeCheckout(duration, adType, price);
//         }
//     });
// }
// function startStripeCheckout(duration, adType, price) {

//     Swal.fire({
//         title: 'Payment Details',
//         html: `
//             <div class="payment-panel">

//                 <div class="summary-box">
//                     <h4 class="summary-title">Order Summary</h4>

//                     <div class="summary-row">
//                         <span>Duration:</span>
//                         <strong>${duration.replace('_', ' ')}</strong>
//                     </div>

//                     <div class="summary-row">
//                         <span>Ad Type:</span>
//                         <strong>${adType.charAt(0).toUpperCase() + adType.slice(1)} Ad</strong>
//                     </div>

//                     <div class="summary-row total">
//                         <span>Total:</span>
//                         <strong>AUD $${price}</strong>
//                     </div>
//                 </div>

//                 <div class="card-form mt-3">
//                     <label class="form-label">Cardholder Name</label>
//                     <input id="cardholder-name" class="swal2-input custom-input" placeholder="John Doe">

//                     <label class="form-label">Card Details</label>
//                     <div id="card-element" class="card-element-box"></div>

//                     <div id="card-errors" style="color:red; margin-top:6px;"></div>
//                 </div>

//             </div>
//         `,
//         showCancelButton: true,
//         confirmButtonText: '<i class="fa fa-lock me-2"></i> Pay Securely',
//         cancelButtonText: '<i class="fa fa-arrow-left me-2"></i> Back',
//         customClass: {
//             popup: 'swal2-offcanvas-right epanel-popup',
//             title: 'epanel-title',
//             confirmButton: 'epanel-confirm',
//             cancelButton: 'epanel-cancel'
//         },
//         backdrop: false,
//         position: 'top-end',
//         width: '420px',

//         didOpen: () => {
//             // ⭐ Initialize Stripe Elements INSIDE SweetAlert
//             const stripe = Stripe("pk_test_51RlN3fRdXeSPt59V4Xjqhy4kyxqHvZ0IFifFRc1k829QVVbAeIKomP9FyM7QZqHQe1bm27rFRftdIFW0KkWsSXkP00NIM8r37F");
//             const elements = stripe.elements();

//             const cardElement = elements.create("card", {
//                 hidePostalCode: true,
//                 style: {
//                     base: {
//                         fontSize: "16px",
//                         color: "#333"
//                     }
//                 }
//             });

//             cardElement.mount("#card-element");

//             // Save for preConfirm
//             Swal.stripe = stripe;
//             Swal.cardElement = cardElement;
//         },

//         preConfirm: async () => {
//             const popup = Swal.getPopup();
//             const cardholderName = popup.querySelector("#cardholder-name").value;

//             if (!cardholderName) {
//                 Notiflix.Notify.failure("Enter cardholder name.");
//                 return false;
//             }

//             // ⭐ Create token manually
//             const { token, error } = await Swal.stripe.createToken(Swal.cardElement, {
//                 name: cardholderName
//             });

//             if (error) {
//                 popup.querySelector("#card-errors").textContent = error.message;
//                 Notiflix.Notify.failure(error.message);
//                 return false;
//             }

//             // ⭐ Send token to backend
//             const response = await fetch("/process-paymentext", {
//                 method: "POST",
//                 headers: {
//                     "Content-Type": "application/json",
//                     "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content
//                 },
//                 body: JSON.stringify({
//                     token: token.id,
//                     amount: price,
//                     adType: adType,
//                     company: "Your Company",
//                     company_id: 1
//                 })
//             });

//             const data = await response.json();

//             if (!data.success) {
//                 Notiflix.Notify.failure("Payment failed: " + data.error);
//                 return false;
//             }

//             Notiflix.Notify.success("Payment successful!");
//             extendAd();
//             return true;
//         },

//         allowOutsideClick: false
//     });
// }







// /* ---------- Extend ad (Notiflix + backend) ---------- */

// function extendAd() {
//     const adData = sessionStorage.getItem('selectedAd');
//     const ad = adData ? JSON.parse(adData) : null;

//     if (!ad || !ad.id) {
//         Notiflix.Notify.failure('No job ad selected to extend.');
//         return;
//     }

//     // ⭐ FIX: Read values saved BEFORE payment
//     const duration = sessionStorage.getItem("extend_duration");
//     const newAdType = sessionStorage.getItem("extend_adType");
//     const newPrice = sessionStorage.getItem("extend_price");

//     if (!duration || !newAdType || !newPrice) {
//         Notiflix.Notify.failure('Missing extension data.');
//         return;
//     }

//     Notiflix.Confirm.show(
//         '<i class="fa fa-clock text-primary me-2"></i> <span style="color:#0d6efd;font-weight:bold;">Confirm Extension</span>',
//         `<span style="font-size:15px;color:#333;">
//             Extend this job ad by <b>${duration.replace('_', ' ')}</b>?<br>
//             ${
//                 newAdType !== ad.ad_type
//                     ? `<span style="color:#0d6efd;">Ad type will change from <b>${ad.ad_type}</b> to <b>${newAdType}</b>.</span>`
//                     : `<span style="color:#198754;">Ad type remains <b>${newAdType}</b>.</span>`
//             }
//             <br><br>
//             <b>Total Cost:</b> $${newPrice}
//         </span>`,
//         '<i class="fa fa-check me-2"></i> Yes, Extend',
//         '<i class="fa fa-times me-2"></i> Cancel',
//         function okCb() {

//             Notiflix.Loading.circle('Updating job ad...');

//             fetch(`/jobboards/${ad.id}/extend`, {
//                 method: 'PATCH',
//                 headers: {
//                     'Content-Type': 'application/json',
//                     'X-CSRF-TOKEN': document
//                         .querySelector('meta[name="csrf-token"]')
//                         .getAttribute('content')
//                 },
//                 body: JSON.stringify({
//                     duration: duration,
//                     ad_type: newAdType,
//                     price: newPrice
//                 })
//             })
//                 .then(res => {
//                     if (!res.ok) throw new Error(`Server error: ${res.status}`);
//                     return res.json();
//                 })
//                 .then(data => {
//                     Notiflix.Loading.remove();
//                     Notiflix.Notify.success('Job ad extended successfully!');

//                     ad.ad_type = newAdType;
//                     sessionStorage.setItem('selectedAd', JSON.stringify(ad));

//                     window.location.reload();
//                 })
//                 .catch(err => {
//                     Notiflix.Loading.remove();
//                     Notiflix.Notify.failure(`Extension failed: ${err.message}`);
//                 });
//         },
//         function cancelCb() {
//             Notiflix.Notify.info('Extension cancelled.');
//         },
//         {
//             okButtonBackground: '#0d6efd',
//             okButtonColor: '#fff',
//             cancelButtonBackground: '#6c757d',
//             cancelButtonColor: '#fff',
//             borderRadius: '8px',
//             width: '360px'
//         }
//     );
// }

/* ---------- Open main extension panel ---------- */

function openExtendedPeriodPanel() {

    closeOtherOffcanvas();
    forceCloseOffcanvas('jobOffcanvas-expired');

    Swal.fire({
        title: 'Extend Job Duration',
        html: `
            <div class="epanel-body">

                <label class="form-label epanel-label">Select Duration</label>
                <select id="extendedPeriodSelect" class="form-select epanel-select mt-2">
                    <optgroup label="Weeks">
                        <option value="1_week">1 week</option>
                        <option value="2_weeks">2 weeks</option>
                        <option value="3_weeks">3 weeks</option>
                    </optgroup>
                    <optgroup label="Months">
                        <option value="1_month">1 month</option>
                        <option value="2_months">2 months</option>
                        <option value="3_months">3 months</option>
                        <option value="4_months">4 months</option>
                        <option value="5_months">5 months</option>
                        <option value="6_months">6 months</option>
                        <option value="7_months">7 months</option>
                        <option value="8_months">8 months</option>
                        <option value="9_months">9 months</option>
                        <option value="10_months">10 months</option>
                        <option value="11_months">11 months</option>
                        <option value="12_months">12 months</option>
                    </optgroup>
                </select>

                <div id="pricingTable" class="pricing-table mt-4"></div>
                <div id="featureList" class="feature-list mt-3"></div>

            </div>
        `,
        showCancelButton: true,
        confirmButtonText: '<i class="fa fa-save me-2"></i> Proceed to Payment',
        cancelButtonText: '<i class="fa fa-times me-2"></i> Cancel',
        customClass: {
            popup: 'swal2-offcanvas epanel-popup',
            title: 'epanel-title',
            confirmButton: 'epanel-confirm',
            cancelButton: 'epanel-cancel'
        },
        backdrop: false,
        position: 'top-end',
        width: '420px',

        didOpen: () => {
            const popup = Swal.getPopup();
            popup.querySelector('#extendedPeriodSelect')
                .addEventListener('change', updatePricingTable);

            updatePricingTable();
        },

        // Collect duration + adType safely here
        preConfirm: () => {
            const popup = Swal.getPopup();
            const duration = popup.querySelector('#extendedPeriodSelect')?.value;
            const adTypeInput = popup.querySelector('input[name="adType"]:checked');

            if (!duration || !adTypeInput) {
                Notiflix.Notify.failure('Please select duration and ad type.');
                return false;
            }

            const adType = adTypeInput.value;
            const price = adTypeInput.dataset.price;

            // Save for later (used by extendAd and payment)
            sessionStorage.setItem("extend_duration", duration);
            sessionStorage.setItem("extend_adType", adType);
            sessionStorage.setItem("extend_price", price);

            return { duration, adType, price };
        }
    }).then(result => {
        if (!result.isConfirmed || !result.value) return;

        const { duration, adType, price } = result.value;
        openPaymentPanel(duration, adType, price);
    });
}


/* ---------- Pricing table + features ---------- */

function updatePricingTable() {
    const popup = Swal.getPopup();
    if (!popup) return;

    const duration = popup.querySelector('#extendedPeriodSelect')?.value;
    const pricingDiv = popup.querySelector('#pricingTable');

    if (!duration || !pricingDiv) return;

    const isMonthly = duration.includes('month');
    const multiplier = parseInt(duration, 10);

    const weeklyPrices = {
        basic: 10.99,
        premium: 24.99,
        platinum: 49.99
    };

    const monthlyPrices = {
        basic: 49.99,
        premium: 99.99,
        platinum: 199.99
    };

    const basePrices = isMonthly ? monthlyPrices : weeklyPrices;

    const prices = {
        basic: basePrices.basic * multiplier,
        premium: basePrices.premium * multiplier,
        platinum: basePrices.platinum * multiplier
    };

    pricingDiv.innerHTML = `
        <div class="pricing-row">
            ${createPricingCard('Basic', prices.basic, 'basic')}
            ${createPricingCard('Premium', prices.premium, 'premium')}
            ${createPricingCard('Platinum', prices.platinum, 'platinum')}
        </div>
    `;

    // Bind radio change handlers
    popup.querySelectorAll('input[name="adType"]').forEach(input => {
        input.addEventListener('change', () => {
            updateSelectedBadge();
            updateFeatureList(input.value);
        });
    });

    // Clear feature list when duration changes
    const featureDiv = popup.querySelector('#featureList');
    if (featureDiv) featureDiv.innerHTML = '';
}

function createPricingCard(title, price, key) {
    return `
        <label class="pricing-card">
            <input type="radio" name="adType" value="${key}" data-price="${price.toFixed(2)}">
            <div class="pricing-content">
                <div class="selected-badge">Selected</div>
                <h4>${title}</h4>
                <div class="price">$${price.toFixed(2)}</div>
            </div>
        </label>
    `;
}

function updateSelectedBadge() {
    const popup = Swal.getPopup();
    if (!popup) return;

    popup.querySelectorAll('.selected-badge').forEach(badge => {
        badge.style.display = 'none';
    });

    const selected = popup.querySelector('input[name="adType"]:checked');
    if (selected) {
        const badge = selected.parentElement.querySelector('.selected-badge');
        if (badge) badge.style.display = 'block';
    }
}

function updateFeatureList(plan) {
    const popup = Swal.getPopup();
    if (!popup) return;

    const featureDiv = popup.querySelector('#featureList');
    if (!featureDiv) return;

    const features = {
        basic: [
            'Extended exclusive job description',
            'Exclusive job summary'
        ],
        premium: [
            'Extended exclusive job description',
            'Exclusive job summary',
            'Exclusive video conferencing',
            'Featured listing',
            'Applicant tracking system'
        ],
        platinum: [
            'Extended exclusive job description',
            'Exclusive job summary',
            'Exclusive video conferencing',
            'Featured listing',
            'Applicant tracking system',
            'Video job description',
            'Priority support',
            'Custom branding',
            'Job ad analytics',
            'Candidate matching'
        ]
    };

    const selected = features[plan] || [];

    featureDiv.innerHTML = `
        <div class="feature-title">Included Features</div>
        <ul class="feature-ul">
            ${selected
                .map(f => `<li><i class="fa fa-check"></i> ${f}</li>`)
                .join('')}
        </ul>
    `;
}


/* ---------- Payment confirmation panel ---------- */

function openPaymentPanel(duration, adType, price) {

    Swal.fire({
        title: 'Confirm Payment',
        html: `
            <div class="epanel-body">

                <div class="summary-box">
                    <h4 class="summary-title">Order Summary</h4>

                    <div class="summary-row">
                        <span>Duration:</span>
                        <strong>${duration.replace('_', ' ')}</strong>
                    </div>

                    <div class="summary-row">
                        <span>Ad Type:</span>
                        <strong>${adType.charAt(0).toUpperCase() + adType.slice(1)} Ad</strong>
                    </div>

                    <div class="summary-row total">
                        <span>Total Price:</span>
                        <strong>AUD $${price}</strong>
                    </div>
                </div>

                <p class="mt-3" style="font-size:0.85rem;color:#555;">
                    You will enter your payment details securely to complete your purchase.
                </p>

            </div>
        `,
        showCancelButton: true,
        confirmButtonText: '<i class="fa fa-credit-card me-2"></i> Pay Now',
        cancelButtonText: '<i class="fa fa-arrow-left me-2"></i> Back',
        customClass: {
            popup: 'swal2-offcanvas-left epanel-popup',
            title: 'epanel-title',
            confirmButton: 'epanel-confirm',
            cancelButton: 'epanel-cancel'
        },
        backdrop: false,
        position: 'top-start',
        width: '420px'
    }).then(result => {
        if (result.isConfirmed) {
            startStripeCheckout(duration, adType, price);
        }
    });
}


/* ---------- Stripe Elements payment panel ---------- */

function startStripeCheckout(duration, adType, price) {

    Swal.fire({
        title: 'Payment Details',
        html: `
            <div class="payment-panel">

                <div class="summary-box">
                    <h4 class="summary-title">Order Summary</h4>

                    <div class="summary-row">
                        <span>Duration:</span>
                        <strong>${duration.replace('_', ' ')}</strong>
                    </div>

                    <div class="summary-row">
                        <span>Ad Type:</span>
                        <strong>${adType.charAt(0).toUpperCase() + adType.slice(1)} Ad</strong>
                    </div>

                    <div class="summary-row total">
                        <span>Total:</span>
                        <strong>AUD $${price}</strong>
                    </div>
                </div>

                <div class="card-form mt-3">
                    <label class="form-label">Cardholder Name</label>
                    <input id="cardholder-name" class="swal2-input custom-input" placeholder="John Doe">

                    <label class="form-label">Card Details</label>

                    <!-- ⭐ THIS MUST EXIST EXACTLY LIKE THIS -->
                    <div id="card-element" style="
                        padding: 12px;
                        border: 1px solid #ccc;
                        border-radius: 6px;
                        background: white;
                        margin-top: 8px;
                    "></div>

                    <div id="card-errors" style="color:red; margin-top:6px;"></div>
                </div>

            </div>
        `,
        showCancelButton: true,
        confirmButtonText: '<i class="fa fa-lock me-2"></i> Pay Securely',
        cancelButtonText: '<i class="fa fa-arrow-left me-2"></i> Back',
        customClass: {
            popup: 'swal2-offcanvas-right epanel-popup',
            title: 'epanel-title',
            confirmButton: 'epanel-confirm',
            cancelButton: 'epanel-cancel'
        },
        backdrop: false,
        position: 'top-end',
        width: '420px',

        didOpen: () => {
            // ⭐ FIX: Stripe Elements MUST mount here
            const stripe = Stripe("pk_test_51RlN3fRdXeSPt59V4Xjqhy4kyxqHvZ0IFifFRc1k829QVVbAeIKomP9FyM7QZqHQe1bm27rFRftdIFW0KkWsSXkP00NIM8r37F");
            const elements = stripe.elements();

            const cardElement = elements.create("card", {
                hidePostalCode: true,
                style: {
                    base: {
                        fontSize: "16px",
                        color: "#333",
                        '::placeholder': { color: '#888' }
                    }
                }
            });

            cardElement.mount("#card-element");

            Swal.stripe = stripe;
            Swal.cardElement = cardElement;
        },

        preConfirm: async () => {
            const popup = Swal.getPopup();
            const cardholderName = popup.querySelector("#cardholder-name").value;

            if (!cardholderName) {
                Notiflix.Notify.failure("Enter cardholder name.");
                return false;
            }

            const { token, error } = await Swal.stripe.createToken(Swal.cardElement, {
                name: cardholderName
            });

            if (error) {
                popup.querySelector("#card-errors").textContent = error.message;
                Notiflix.Notify.failure(error.message);
                return false;
            }

            const response = await fetch("/process-paymentext", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content
                },
                body: JSON.stringify({
                    token: token.id,
                    amount: price,
                    adType: adType,
                    company: "Your Company",
                    company_id: 1
                })
            });

            const data = await response.json();

            if (!data.success) {
                Notiflix.Notify.failure("Payment failed: " + data.error);
                return false;
            }

            Notiflix.Notify.success("Payment successful!");
            extendAd();
            return true;
        },

        allowOutsideClick: false
    });
}



/* ---------- Extend ad (Notiflix + backend) ---------- */
function extendAd() {
    const adData = sessionStorage.getItem('selectedAd');
    const ad = adData ? JSON.parse(adData) : null;

    if (!ad || !ad.id) {
        Swal.fire({
            icon: 'error',
            title: 'No Job Selected',
            text: 'No job ad selected to extend.'
        });
        return;
    }

    const duration = sessionStorage.getItem("extend_duration");
    const newAdType = sessionStorage.getItem("extend_adType");
    const newPrice = sessionStorage.getItem("extend_price");

    if (!duration || !newAdType || !newPrice) {
        Swal.fire({
            icon: 'error',
            title: 'Missing Data',
            text: 'Extension details are missing.'
        });
        return;
    }

    // ⭐ Directly execute the PATCH request — no confirmation modal
    fetch(`/jobboards/${ad.id}/extend`, {
        method: 'PATCH',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document
                .querySelector('meta[name="csrf-token"]')
                .getAttribute('content')
        },
        body: JSON.stringify({
            duration: duration,
            ad_type: newAdType,
            price: newPrice
        })
    })
    .then(res => {
        if (!res.ok) throw new Error(`Server error: ${res.status}`);
        return res.json();
    })
    .then(data => {

        // Update stored ad type
        ad.ad_type = newAdType;
        sessionStorage.setItem('selectedAd', JSON.stringify(ad));

        // ⭐ SUCCESS SWEETALERT
        Swal.fire({
            icon: 'success',
            title: 'Job Ad Renewed!',
            html: `
                <div style="text-align:left;font-size:15px;color:#333;">
                    <p>
                        <i class="fa fa-check" style="color:#28a745;margin-right:6px;"></i>
                        Your job ad has been renewed for <b>${duration.replace('_', ' ')}</b>.
                    </p>

                    <p>
                        <i class="fa fa-check" style="color:#28a745;margin-right:6px;"></i>
                        Payment receipt has been sent to your email.
                    </p>
                </div>
            `,
            confirmButtonText: 'OK',
            confirmButtonColor: '#0d6efd'
        }).then(() => {
            window.location.reload();
        });

    })
    .catch(err => {
        Swal.fire({
            icon: 'error',
            title: 'Extension Failed',
            text: err.message,
            confirmButtonColor: '#dc3545'
        });
    });
}
















</script>
<?php /**PATH E:\CareerJobs\resources\views\components\expiredjobs.blade.php ENDPATH**/ ?>