<div style="
    font-family: 'Segoe UI', Arial, sans-serif;
    background: #f7f7f9;
    padding: 30px;
">
    <div style="
        max-width: 600px;
        margin: auto;
        background: white;
        border-radius: 12px;
        padding: 30px 35px;
        box-shadow: 0 4px 18px rgba(0,0,0,0.08);
        line-height: 1.7;
        font-size: 16px;
        color: #333;
    ">

        <!-- Header -->
        <h2 style="
            margin-top: 0;
            color: rgb(113,16,62);
            font-weight: 700;
            font-size: 22px;
            text-align: center;
            letter-spacing: 0.5px;
        ">
            Your Interview Has Been Scheduled
        </h2>

        <p style="margin-top: 25px;">Hi <?php echo e($applicant); ?>,</p>

        <p>
            Congratulations! You have been scheduled for an online interview with 
            <strong><?php echo e($sender); ?></strong>. We’re excited to meet you and learn more about your experience.
        </p>

        <!-- Details Box -->
        <div style="
            background: #faf0f5;
            border-left: 4px solid rgb(113,16,62);
            padding: 12px 18px;
            margin: 20px 0;
            border-radius: 6px;
        ">
            <p style="margin: 0;">
                <strong>Date:</strong> <?php echo e($date); ?><br>
                <strong>Time:</strong> <?php echo e($time); ?>

            </p>
        </div>

        <p>You can join the meeting using the button below:</p>

        <!-- CTA Button -->
        <p style="text-align: center; margin: 30px 0;">
            <a href="<?php echo e($meetUrl); ?>" 
               style="
                    display: inline-block;
                    padding: 14px 22px;
                    background: rgb(113,16,62);
                    color: white;
                    text-decoration: none;
                    border-radius: 8px;
                    font-weight: 600;
                    font-size: 16px;
                    letter-spacing: 0.3px;
               ">
                Join Google Meet
            </a>
        </p>

        <p>
            You can also log in to your account and find this interview under 
            <strong>Upcoming Interviews</strong>.
        </p>

        <p>We look forward to speaking with you soon.</p>

        <p style="margin-top: 35px;">
            Regards,<br>
            <strong><?php echo e($sender); ?></strong>
        </p>

        <!-- Footer -->
        <div style="
            margin-top: 40px;
            text-align: center;
            font-size: 13px;
            color: #777;
        ">
            © <?php echo e(date('Y')); ?> CareerJobs. All rights reserved.
        </div>

    </div>
</div>
<?php /**PATH E:\CareerJobs\resources\views\emails\interview_scheduled.blade.php ENDPATH**/ ?>