<!-- Closed Jobs Offcanvas -->
<div class="offcanvas offcanvas-end offcanvas-75 shadow-lg rounded-start" tabindex="-1" id="jobOffcanvas-closed">
    <div class="offcanvas-header bg-gradient-secondary text-white py-3 px-4">
        <h5 class="offcanvas-title fw-bold">
            <i class="fa fa-lock me-2"></i> Closed Jobs
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body p-4 bg-light">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <h6 class="fw-bold mb-3 text-secondary">
                    <i class="fa fa-list me-2"></i> Job Listings
                </h6>

                <?php if($closedJobs->isEmpty()): ?>
                    <div class="text-center py-5">
                        <i class="fa fa-info-circle fa-3x text-muted mb-3"></i>
                        <h5 class="fw-bold text-secondary">No Closed Jobs</h5>
                        <p class="text-muted mb-4">You don’t have any closed job ads yet.</p>
                        <a href="javascript:void(0)"
                           class="btn btn-danger"
                           data-bs-toggle="offcanvas"
                           data-bs-target="#jobFormCanvasUnique">
                            <i class="fa fa-plus me-2"></i> Post a Job Ad
                        </a>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <?php echo $__env->make('components.closedjobs', ['jobs' => $closedJobs], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div><?php /**PATH E:\CareerJobs\resources\views\components\closedjobsoffcanvas.blade.php ENDPATH**/ ?>