<!-- Load Google Maps JS with Places library -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyACo1W7kVL0SRaMfxkHmQrbv0G-ELGCVFk&libraries=places&callback=initSuburbAutocomplete" async defer></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>










<!-- Offcanvas full height from top -->
<div class="offcanvas offcanvas-top job-offcanvas" tabindex="-1" id="jobFormCanvasUnique">
    <div class="offcanvas-header" style="background-color: rgb(113, 16, 62)">
        <h5 class="offcanvas-title text-white">Add Job</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <form class="row g-3" id="jobForm">
            <!-- Category -->
            <div class="col-md-3">
                <label class="form-label" for="category">Select Category <span class="text-danger">*</span></label>
                <select class="form-select" id="category" required>
                    <option selected disabled value="">Select category</option>
                    <option value="Support Workers">Support Workers</option>
                    <option value="Senior Support Workers">Senior Support Workers</option>
                    <option value="Service Managers">Service Managers</option>
                    <option value="Operations Managers">Operations Managers</option>
                    <option value="Social Workers">Social Workers</option>
                    <option value="Administration Officers">Administration Officers</option>
                    <option value="Nurses">Nurses</option>
                    <option value="Team Leaders">Team Leaders</option>
                    <option value="Business Managers">Business Managers</option>
                </select>
            </div>

            <!-- Job Title -->
            <div class="col-md-3">
                <label class="form-label" for="jobTitle">Job Title <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="jobTitle" placeholder="Enter job title" required>
            </div>

            <div class="col-md-3">
                <label class="form-label" for="location">Location <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="location" placeholder="Enter suburb" required autocomplete="off">
            </div>


            <!-- Workplace -->
            <div class="col-md-3">
                <label class="form-label" for="workplace">Workplace <span class="text-danger">*</span></label>
                <select class="form-select" id="workplace" required>
                    <option selected disabled value="">Select workplace</option>
                    <option>On-site</option>
                    <option>Remote</option>
                    <option>Hybrid</option>
                </select>
            </div>

            <!-- Type of Work -->
            <div class="col-md-3">
                <label class="form-label" for="workType">Type of Work <span class="text-danger">*</span></label>
                <select class="form-select" id="workType" required>
                    <option selected disabled value="">Select type of work</option>
                    <option>Full-time</option>
                    <option>Part-time</option>
                    <option>Casual</option>
                    <option>Contract</option>
                    <option>Temporary</option>
                    <option>Internship</option>
                    <option>Volunteer</option>
                </select>
            </div>

            <!-- Pay Type -->
            <div class="col-md-3">
                <label class="form-label" for="payType">Pay Type <span class="text-danger">*</span></label>
                <select class="form-select" id="payType" required>
                    <option selected disabled value="">Select pay type</option>
                    <option>Hourly</option>
                    <option>Salary</option>
                    <option>Contract</option>
                </select>
            </div>

            <!-- Pay Range -->
            <div class="col-md-3">
                <label class="form-label" for="payMin">Pay Min <span class="text-danger">*</span></label>
                <input type="number" class="form-control" id="payMin" placeholder="Minimum" required>
            </div>
            <div class="col-md-3">
                <label class="form-label" for="payMax">Pay Max <span class="text-danger">*</span></label>
                <input type="number" class="form-control" id="payMax" placeholder="Maximum" required>
            </div>

            <!-- Show/Hide Pay -->
            <div class="col-md-3">
                <label class="form-label">Pay Visibility <span class="text-danger">*</span></label>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="payVisibility" id="showPay" value="show" required>
                    <label class="form-check-label" for="showPay">Show pay on ad</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="payVisibility" id="hidePay" value="hide">
                    <label class="form-check-label" for="hidePay">Hide pay on ad</label>
                </div>
            </div>


            <!-- Submit -->
            <div class="col-12">
                <button type="submit" id="saveJobBtn"
                        style="background-color: rgb(113, 16, 62);
           color: #fff;
           border: none;
           width: 100%;
           padding: 10px;
           border-radius: 6px;
           display: flex;
           align-items: center;
           justify-content: center;">
                    <i class="fas fa-arrow-right me-2"></i> Next
                </button>
            </div>

        </form>
    </div>
</div>


<!-- Offcanvas panel for Search Candidates -->
<div class="offcanvas offcanvas-top" tabindex="-1" id="searchCandidatesPanel" style="height: 100vh"!important>
    <div class="offcanvas-header" style="background-color: rgb(113, 16, 62) " >
        <h5 class="offcanvas-title">
            <i class="fa fa-search me-2 text-primary"></i> Search Candidates
        </h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body">
        <!-- Search form -->
        <form id="candidateSearchForm" class="mb-3">
            
            <div class="mb-3">
                <label for="candidateRole" class="form-label">Job Title</label>
                <select id="candidateRole" class="form-select">
                    <option value="">Select job title</option>
                    <option value="Support Workers">Support Workers</option>
                    <option value="Senior Support Workers">Senior Support Workers</option>
                    <option value="Service Managers">Service Managers</option>
                    <option value="Operations Managers">Operations Managers</option>
                    <option value="Social Workers">Social Workers</option>
                    <option value="Administration Officers">Administration Officers</option>
                    <option value="Nurses">Nurses</option>
                    <option value="Team Leaders">Team Leaders</option>
                    <option value="Business Managers">Business Managers</option>
                </select>
            </div>
            <div class="mb-3">
                <label for="candidateLocation" class="form-label">Location</label>
               <input type="text" class="form-control" id="locationSearch" placeholder="Enter Suburb" required autocomplete="off">
            </div>

         <button type="submit"
    class="btn w-100"
    style="
        background: linear-gradient(90deg, #71103E, #9A1A57);
        border: none;
        padding: 12px;
        font-weight: 600;
        letter-spacing: .4px;
        border-radius: 10px;
        color: white;
        box-shadow: 0 3px 10px rgba(0,0,0,0.15);
        transition: 0.2s ease-in-out;
    "
    onmouseover="this.style.opacity='0.92'"
    onmouseout="this.style.opacity='1'"
>
    <i class="fa fa-search me-2"></i> Search Candidates
</button>

        </form>

        <!-- Results placeholder -->
     <div id="searchResults" 
     style="
        display:grid;
        grid-template-columns: repeat(auto-fill, minmax(260px, 1fr));
        gap:16px;
        padding-top:10px;
     ">
            <p class="text-muted">Search results will appear here...</p>
        </div>
    </div>
</div>


<!-- Saved Profiles Offcanvas -->
<div class="offcanvas offcanvas-top" tabindex="-1" id="savedProfilesPanel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title text-white">
            <i class="fa fa-bookmark me-2 text-white"></i> Saved Profiles
        </h5>
        <button type="button" class="btn-close" style="filter: invert(1);" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body no-scroll">
        <div class="row g-3">
            <!-- Example saved profile cards -->
            <div class="col-md-4">
                <div class="card border-0 shadow-sm h-100 bg-light">
                    <div class="card-body text-center">
                        <i class="fa fa-user fa-2x text-primary mb-2"></i>
                        <h6 class="fw-bold text-uppercase">Support Worker</h6>
                        <p class="small mb-0">Profile saved for review</p>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card border-0 shadow-sm h-100 bg-light">
                    <div class="card-body text-center">
                        <i class="fa fa-stethoscope fa-2x text-success mb-2"></i>
                        <h6 class="fw-bold text-uppercase">Allied Health Professional</h6>
                        <p class="small mb-0">Profile saved for review</p>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card border-0 shadow-sm h-100 bg-light">
                    <div class="card-body text-center">
                        <i class="fa fa-hands-helping fa-2x text-warning mb-2"></i>
                        <h6 class="fw-bold text-uppercase">Support Coordination</h6>
                        <p class="small mb-0">Profile saved for review</p>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card border-0 shadow-sm h-100 bg-light">
                    <div class="card-body text-center">
                        <i class="fa fa-clipboard-list fa-2x text-info mb-2"></i>
                        <h6 class="fw-bold text-uppercase">Plan Manager</h6>
                        <p class="small mb-0">Profile saved for review</p>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card border-0 shadow-sm h-100 bg-light">
                    <div class="card-body text-center">
                        <i class="fa fa-users fa-2x text-danger mb-2"></i>
                        <h6 class="fw-bold text-uppercase">Community Services</h6>
                        <p class="small mb-0">Profile saved for review</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Ad Type Offcanvas -->
<div class="offcanvas offcanvas-top adtype-offcanvas" tabindex="-1" id="adTypeCanvas">
    <div class="offcanvas-header"
         style="background-color: rgb(113, 16, 62); color: #fff; padding: 12px; border-radius: 6px 6px 0 0;">
        <h5 class="offcanvas-title" style="margin:0; font-weight:600;">Choose the ad type that best fits you</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <form>

            <div class="row">


                <div class="col-md-4">
                    <label class="ad-card" style="display:block; padding:20px; border:2px solid #007bff; border-radius:8px; background:#f9f9f9; transition:all 0.3s ease;">
                        <input type="radio" name="adType" value="basic" class="card-radio">
                        <h5 class="ad-title" style="font-weight:600; margin-bottom:10px; color:#333;">Basic Job Ads</h5>

                        <!-- Price Tag -->
                        <div class="ad-price" style="margin:10px 0; padding:8px 12px; background:#007bff; color:#fff; font-size:1.1rem; font-weight:bold; border-radius:6px; display:inline-block;">
                            <span class="price-label" style="font-weight:400; margin-right:5px; opacity:0.9;">Price:</span>
                            <span class="price-value" style="font-weight:700;">AUD $99</span>
                        </div>

                        <ul class="ad-features" style="margin-top:10px; padding-left:20px; color:#555;">
                            <li>Job Title: Clear and concise title.</li>
                            <li>Company Name: Name of the hiring company.</li>
                            <li>Job Description: Brief overview of responsibilities and requirements.</li>
                            <li>Location: Job location (remote, on-site, hybrid).</li>
                            <li>Salary Range: Optional salary information.</li>
                        </ul>
                    </label>
                </div>

                <!-- Premium -->
                <div class="col-md-4">
                    <label class="ad-card premium" style="position:relative; display:block; padding:20px; border:2px solid #28a745; border-radius:8px; background:#f9f9f9; transition:all 0.3s ease;">

                        <!-- Recommended Badge -->
                        <div style="position:absolute; top:-10px; right:-10px; background:#ffc107; color:#000; font-size:0.9rem; font-weight:bold; padding:6px 12px; border-radius:4px; box-shadow:0 2px 6px rgba(0,0,0,0.2);">
                            Recommended
                        </div>

                        <input type="radio" name="adType" value="premium" class="card-radio">
                        <h5 class="ad-title" style="font-weight:600; margin-bottom:10px; color:#333;">Premium Job Ads</h5>

                        <!-- Price Tag -->
                        <div class="ad-price" style="margin:10px 0; padding:8px 12px; background:#28a745; color:#fff; font-size:1.1rem; font-weight:bold; border-radius:6px; display:inline-block;">
                            <span class="price-label" style="font-weight:400; margin-right:5px; opacity:0.9;">Price:</span>
                            <span class="price-value" style="font-weight:700;">$AUD 149</span>
                        </div>

                        <p class="ad-desc" style="margin-top:10px; color:#555;">Includes all Basic features plus:</p>
                        <ul class="ad-features" style="margin-top:10px; padding-left:20px; color:#555;">
                            <li>Enhanced Job Description: More detailed responsibilities and qualifications.</li>
                            <li>Company Logo: Display of the company’s logo.</li>
                            <li>Featured Listing: Job ad appears at the top of search results.</li>
                            <li>Social Media Sharing: Easy sharing options on social media platforms.</li>
                            <li>Applicant Tracking Integration: Integration with ATS (Applicant Tracking Systems).</li>
                            <li>Company Overview: Brief about the company culture and values.</li>
                        </ul>
                    </label>
                </div>

                <!-- Platinum -->
                <div class="col-md-4">
                    <label class="ad-card platinum" style="display:block; padding:20px; border:2px solid #6f42c1; border-radius:8px; background:#f9f9f9; transition:all 0.3s ease;">
                        <input type="radio" name="adType" value="platinum" class="card-radio">
                        <h5 class="ad-title" style="font-weight:600; margin-bottom:10px; color:#333;">Platinum Job Ads</h5>

                        <!-- Price Tag -->
                        <div class="ad-price" style="margin:10px 0; padding:8px 12px; background:#6f42c1; color:#fff; font-size:1.1rem; font-weight:bold; border-radius:6px; display:inline-block;">
                            <span class="price-label" style="font-weight:400; margin-right:5px; opacity:0.9;">Price:</span>
                            <span class="price-value" style="font-weight:700;">AUD $199</span>
                        </div>

                        <p class="ad-desc" style="margin-top:10px; color:#555;">Includes all Premium features plus:</p>
                        <ul class="ad-features" style="margin-top:10px; padding-left:20px; color:#555;">
                            <li>Video Job Description: Option to include a video introducing the role or company.</li>
                            <li>Priority Support: Dedicated support for posting and managing ads.</li>
                            <li>Custom Branding: More customization options for the job ad layout.</li>
                            <li>Extended Reach: Distribution to multiple job boards and platforms.</li>
                            <li>Analytics Dashboard: Insights on ad performance (views, applications, etc.).</li>
                            <li>Candidate Matching: Advanced algorithms to match candidates with job requirements.</li>
                        </ul>
                    </label>
                </div>
            </div>



            <!-- Submit -->
            <button type="button" id="nxtBtn"
                    style="background-color: rgb(113, 16, 62); color: #fff; border: none; width: 100%; padding: 12px; border-radius: 6px; font-weight: 600; display: flex; align-items: center; justify-content: center; margin-top: 20px;">
                <i class="fas fa-check" style="margin-right: 8px;"></i> Next
            </button>
        </form>
    </div>
</div>


<div id="dimOverlay"></div>


<!-- Second Offcanvas -->
<div class="offcanvas offcanvas-top" tabindex="-1" id="detailsCanvas">
    <div class="offcanvas-header d-flex align-items-center justify-content-between"
         style="background-color: rgb(113, 16, 62); color: #fff;">

        <!-- Left: Back button -->
        <button type="button"
                id="backBtn"
                class="btn btn-outline-light btn-sm d-flex align-items-center me-3 ms-2 mt-1 mb-1">
            <i class="fas fa-arrow-left me-2"></i> Back
        </button>

        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const backBtn = document.getElementById('backBtn');
                const detailsCanvas = document.getElementById('detailsCanvas'); // current offcanvas
                const adTypeCanvas = document.getElementById('adTypeCanvas');   // target offcanvas

                backBtn.addEventListener('click', function () {
                    // Hide the current offcanvas
                    const detailsInstance = bootstrap.Offcanvas.getInstance(detailsCanvas);
                    if (detailsInstance) detailsInstance.hide();

                    // Show the target offcanvas
                    const adTypeInstance = new bootstrap.Offcanvas(adTypeCanvas);
                    adTypeInstance.show();

                    // Add Notiflix notification
                    Notiflix.Notify.info('Select an Ad type that fits you.', {
                        position: 'center-top',
                        timeout: 3000,
                        clickToClose: true,
                        cssAnimationStyle: 'from-top',
                    });
                });



            });
        </script>


        <!-- Center: Title -->
        <h4 class="offcanvas-title mb-0 text-white fw-semibold">Ad Details</h4>

        <!-- Right: Close button -->
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body" id="detailsBody">
        <!-- Dynamic fields injected here -->
    </div>
</div>






<style>
    .job-offcanvas {
        height: 80vh !important;
        overflow: auto;
        border-radius: 12px;
    }

    /* Ad type offcanvas */
    .adtype-offcanvas {
        height: 100vh !important;
        overflow-y: auto;
        background-color: #f9f9f9;
        border-radius: 0 0 12px 12px;
        padding: 20px;
        z-index: 1050; /* keep above overlay */
    }

    .ad-card {
        display: block;
        cursor: pointer;
        background: #fff;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        padding: 20px;
        margin-bottom: 20px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.05);
        transition: all 0.2s ease;
        height: 100%;
        position: relative;
    }

    .ad-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }

    .card-radio {
        position: absolute;
        top: 16px;
        right: 16px;
        accent-color: rgb(113, 16, 62);
    }

    .ad-features {
        list-style: none;
        padding-left: 0;
        font-size: 0.9rem;
        color: #333;
    }

    .ad-features li {
        margin-bottom: 6px;
        position: relative;
        padding-left: 20px;
    }

    .ad-features li::before {
        content: "✔";
        color: rgb(113, 16, 62);
        position: absolute;
        left: 0;
    }

    /* Highlight when selected */
    .ad-card input[type="radio"]:checked ~ .ad-title,
    .ad-card input[type="radio"]:checked ~ .ad-desc,
    .ad-card input[type="radio"]:checked ~ .ad-features {
        color: rgb(113, 16, 62);
        font-weight: 600;
    }

    .ad-card.premium { border: 2px solid #007bff; }
    .ad-card.platinum { border: 2px solid #ff9800; }

    /* Second offcanvas sits highest */
    #detailsCanvas {
        z-index: 1061; /* higher than first offcanvas */
    }

    /* Overlay dims background only */
    #dimOverlay {
        position: fixed;
        top: 0; left: 0;
        width: 100%; height: 100%;
        background: rgba(0,0,0,0.3);
        z-index: 1049; /* below first offcanvas */
        display: none;
    }
    #detailsCanvas {
        height: 100vh;   /* adjust height */
        border-radius: 0 0 12px 12px; /* rounded bottom corners */
    }

    .offcanvas-75 {
        width: 75vw !important;
    }

    .bg-gradient-primary {
        background: rgb(113, 16, 62);
    }

    .offcanvas .card {
        border-radius: 0.75rem;
    }

    .offcanvas .table {
        border-radius: 0.5rem;
        overflow: hidden;
    }

    .bg-gradient-success {
        background: rgb(113, 16, 62);
    }
    .bg-gradient-danger {
        background: rgb(113, 16, 62);
    }
    .bg-gradient-secondary {
        background: rgb(113, 16, 62);
    }
    /* Force Google autocomplete dropdown above Bootstrap offcanvas */
.pac-container {
  z-index: 2000 !important; /* higher than .offcanvas (1045) */
}


/* candidates Profile css */
/* Make top offcanvas tall and premium */
.sw-profile-offcanvas {
    height: 90vh !important;        /* Increase height */
    max-height: 90vh !important;    /* Prevent overflow */
    border-bottom-left-radius: 18px;
    border-bottom-right-radius: 18px;
    overflow-y: auto;               /* Scroll inside */
    box-shadow: 0 8px 25px rgba(0,0,0,0.25);
}

/* Smooth slide animation */
.sw-profile-offcanvas.offcanvas-top {
    transform: translateY(-100%);
    transition: transform 0.35s ease-in-out;
}

.sw-profile-offcanvas.show {
    trans
    form: translateY(0);
}


.settings-card {
    background: white;
    padding: 24px;
    border-radius: 14px;
    border: 1px solid #e5e5e5;
    box-shadow: 0 4px 12px rgba(0,0,0,0.06);
}

.settings-title {
    color: #71103E;
    font-weight: 700;
    margin-bottom: 20px;
}

.company-logo {
    width: 130px;
    height: 130px;
    object-fit: cover;
    border-radius: 14px;
    border: 2px solid #ddd;
    box-shadow: 0 4px 10px rgba(0,0,0,0.1);
}

.btn-change-logo {
    margin-top: 12px;
    background: #71103E;
    color: white;
    padding: 8px 18px;
    border: none;
    border-radius: 6px;
    font-weight: 600;
}

.status-badge {
    padding: 6px 14px;
    border-radius: 20px;
    font-size: 14px;
    font-weight: 600;
    color: white;
}

.status-badge.active {
    background: #28a745;
}

.status-badge.inactive {
    background: #dc3545;
}

.btn-save-settings {
    width: 100%;
    background: #71103E;
    color: white;
    padding: 16px;
    border: none;
    border-radius: 10px;
    font-size: 18px;
    font-weight: 700;
    margin-top: 28px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

/* MOBILE FRIENDLY */
@media (max-width: 768px) {
    .settings-grid {
        grid-template-columns: 1fr !important;
    }
}
.transaction-table th {
    background: #71103E;
    color: white;
    font-weight: 600;
}

.transaction-row {
    cursor: pointer;
}

.transaction-row:hover {
    background: #f3e6ef;
}

.status-badge {
    padding: 4px 10px;
    border-radius: 20px;
    font-size: 12px;
    color: white;
    text-transform: capitalize;
}

.status-badge.approved {
    background: #28a745;
}

.status-badge.pending {
    background: #ffc107;
    color: #333;
}

.status-badge.rejected {
    background: #dc3545;
}

.detail-card {
    background: white;
    padding: 20px;
    border-radius: 12px;
    border: 1px solid #e5e5e5;
    box-shadow: 0 4px 12px rgba(0,0,0,0.06);
}
.status-badge {
    padding: 6px 14px;
    border-radius: 20px;
    font-size: 14px;
    font-weight: 600;
    color: rgb(27, 243, 117);
}

.reports-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 16px;
}

.report-card {
    background: white;
    padding: 18px;
    border-radius: 12px;
    border: 1px solid #e5e5e5;
    box-shadow: 0 4px 12px rgba(0,0,0,0.06);
}

.report-title {
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    color: #777;
    margin-bottom: 6px;
}

.report-value {
    font-size: 22px;
    font-weight: 700;
    color: #71103E;
}

.report-subtext {
    font-size: 13px;
    color: #777;
}

.transaction-table th {
    background: #71103E;
    color: white;
    font-weight: 600;
    border-color: #71103E;
}

.transaction-row {
    cursor: pointer;
}

.transaction-row:hover {
    background: #f3e6ef;
}

.status-badge {
    padding: 4px 10px;
    border-radius: 20px;
    font-size: 12px;
    color: rgb(240, 245, 242);
    text-transform: capitalize;
}

.status-badge.paid { background: #28a745; }

.status-badge.approved {
    background: #28a745;
}

.status-badge.pending {
    background: #ffc107;
    color: #333;
}

.status-badge.rejected {
    background: #dc3545;
}

.detail-card {
    background: white;
    padding: 20px;
    border-radius: 12px;
    border: 1px solid #e5e5e5;
    box-shadow: 0 4px 12px rgba(0,0,0,0.06);
}

/* Mobile */
@media (max-width: 768px) {
    .reports-grid {
        grid-template-columns: 1fr;
    }
}



</style>



<div class="offcanvas offcanvas-top shadow-lg"
     tabindex="-1"
     id="candidateProfilePanel"
     style="
        height: 80vh;
        overflow: hidden;
        border-bottom-left-radius: 14px;
        border-bottom-right-radius: 14px;
     ">

    <!-- Header -->
    <div class="offcanvas-header"
         style="
            background: linear-gradient(90deg, #71103E, #9A1A57);
            color: white;
            padding: 18px 24px;
            border-bottom: 1px solid rgba(255,255,255,0.15);
         ">
        <h5 class="offcanvas-title fw-semibold" style="letter-spacing: .5px;">
            Candidate Profile
        </h5>

        <button type="button"
                class="btn-close btn-close-white"
                data-bs-dismiss="offcanvas"
                style="filter: brightness(0.9);">
        </button>
    </div>

    <!-- Body -->
    <div class="offcanvas-body"
         id="candidateProfileContent"
         style="
            padding: 28px;
            overflow-y: auto;
            background: #F8F6F8;
         ">

        <!-- Default loading state -->
        <div class="text-center py-5">
            <div class="spinner-border text-primary mb-3" role="status"></div>
            <p class="text-muted">Loading candidate details…</p>
        </div>

    </div>

</div>




<div class="offcanvas offcanvas-end shadow-lg"
     tabindex="-1"
     id="savedDirectoryPanel"
     style="width: 450px; border-left: 3px solid #71103E;">

    <!-- Header -->
    <div class="offcanvas-header"
         style="
            background: linear-gradient(90deg, #71103E, #9A1A57);
            color: white;
            padding: 18px 24px;
         ">
        <h5 class="offcanvas-title fw-semibold">
            <i class="bi bi-bookmark-star me-2"></i> Saved Candidates
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <!-- Body -->
    <div class="offcanvas-body"
         id="savedDirectoryContent"
         style="padding: 20px; overflow-y: auto; background:#F8F6F8;">
         
        <div class="text-center py-4">
            <div class="spinner-border text-primary mb-3"></div>
            <p class="text-muted">Loading saved candidates…</p>
        </div>

    </div>
</div>



<div class="offcanvas offcanvas-end shadow-lg"
     tabindex="-1"
     id="recommendedMatchesPanel"
     style="
        width: 100%;
        max-width: 700px;
        height: 100vh;
        border-left: 3px solid #71103E;
        overflow: hidden;
     ">

    <!-- Header -->
    <div class="offcanvas-header"
         style="
            background: linear-gradient(90deg, #71103E, #9A1A57);
            color: white;
            padding: 18px 24px;
         ">
        <h5 class="offcanvas-title fw-semibold">
            <i class="bi bi-stars me-2"></i> Recommended Matches
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <!-- Search Bar -->
    <div style="padding: 16px; background:#F1ECF2; border-bottom:1px solid #ddd;">
        <input id="recommendedSearchInput"
               type="text"
               class="form-control"
               placeholder="Search candidates by name, location, or category..."
               oninput="swFilterRecommendedMatches()">
    </div>

    <!-- Body -->
    <div class="offcanvas-body"
         id="recommendedMatchesContent"
         style="
            padding: 20px;
            overflow-y: auto;
            background:#F8F6F8;
         ">

        <div class="text-center py-4">
            <div class="spinner-border text-primary mb-3"></div>
            <p class="text-muted">Loading recommended matches…</p>
        </div>

    </div>
</div>





<div class="offcanvas offcanvas-end shadow-lg"
     tabindex="-1"
     id="jobPerformancePanel"
     style="
        width: 100%;
        max-width: 900px;
        height: 100vh;
        border-left: 3px solid #71103E;
        overflow: hidden;
     ">

    <!-- Header -->
    <div class="offcanvas-header"
         style="
            background: linear-gradient(90deg, #71103E, #9A1A57);
            color: white;
            padding: 18px 24px;
         ">
        <h5 class="offcanvas-title fw-semibold">
            <i class="bi bi-graph-up-arrow me-2"></i> Job Performance & Analysis
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <div style="padding: 16px; background:#F1ECF2; border-bottom:1px solid #ddd;">
    <input id="jobPerformanceSearchInput"
           type="text"
           class="form-control"
           placeholder="Search jobs by title, location, or category..."
           oninput="swFilterJobPerformance()">
</div>


    <!-- Body -->
    <div class="offcanvas-body"
         id="jobPerformanceContent"
         style="
            padding: 20px;
            overflow-y: auto;
            background:#F8F6F8;
         ">

        <div class="text-center py-4">
            <div class="spinner-border text-primary mb-3"></div>
            <p class="text-muted">Loading job performance data…</p>
        </div>

    </div>
</div>


<div class="offcanvas offcanvas-end shadow-lg"
     tabindex="-1"
     id="jobPerformancePanelTracking"
     style="
        width: 100%;
        max-width: 900px;
        height: 100vh;
        border-left: 3px solid #71103E;
        overflow: hidden;
     ">

    <!-- Header -->
    <div class="offcanvas-header"
         style="
            background: linear-gradient(90deg, #71103E, #9A1A57);
            color: white;
            padding: 18px 24px;
         ">
        <h5 class="offcanvas-title fw-semibold">
            <i class="bi bi-graph-up-arrow me-2"></i> Job Performance & Analysis
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <div style="padding: 16px; background:#F1ECF2; border-bottom:1px solid #ddd;">
    <input id="jobPerformanceSearchInput"
           type="text"
           class="form-control"
           placeholder="Search jobs by title, location, or category..."
           oninput="swFilterJobPerformance()">
</div>


    <!-- Body -->
    <div class="offcanvas-body"
         id="jobPerformanceContentTracking"
         style="
            padding: 20px;
            overflow-y: auto;
            background:#F8F6F8;
         ">

        <div class="text-center py-4">
            <div class="spinner-border text-primary mb-3"></div>
            <p class="text-muted">Loading job performance data…</p>
        </div>

    </div>
</div>




<div class="offcanvas offcanvas-top shadow-lg"
     tabindex="-1"
     id="profileSettingsPanel"
     style="
        height: 100%;
        max-height: 100%;
        border-bottom: 3px solid #71103E;
     ">

    <div class="offcanvas-header"
         style="background:#71103E; color:white; padding:18px 24px;">
        <h4 class="offcanvas-title fw-semibold">Profile Settings</h4>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body"
         id="profileSettingsContent"
         style="
            padding:30px;
            background:#F8F6F8;
            overflow-y:auto;
            height: calc(100% - 80px);
         ">
    </div>
</div>


<div class="offcanvas offcanvas-top shadow-lg"
     tabindex="-1"
     id="transactionsPanel"
     style="
        height: 100%;
        max-height: 100%;
        border-bottom: 3px solid #71103E;
     ">

    <div class="offcanvas-header"
         style="background:#71103E; color:white; padding:18px 24px;">
        <h4 class="offcanvas-title fw-semibold">
            <i class="fa-solid fa-receipt me-2"></i> Transactions
        </h4>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <!--  SEARCH BAR -->
    <div style="padding:15px; background:#F0EDF0; border-bottom:1px solid #ddd;">
        <div class="input-group">
            <span class="input-group-text" style="background:white;">
                <i class="fa-solid fa-magnifying-glass"></i>
            </span>
            <input type="text"
                   id="transactionsSearch"
                   class="form-control"
                   placeholder="Search transactions..."
                   onkeyup="swFilterTransactions()"
                   style="border-left:0;">
        </div>
    </div>

    <div class="offcanvas-body"
         id="transactionsContent"
         style="
            padding:30px;
            background:#F8F6F8;
            overflow-y:auto;
            height: calc(100% - 140px);
         ">
    </div>
</div>





<div class="offcanvas offcanvas-end shadow-lg"
     tabindex="-1"
     id="transactionDetailsPanel"
     style="width:100%; max-width:500px; border-left:3px solid #71103E;">

    <div class="offcanvas-header" style="background:#71103E; color:white;">
        <h5 class="offcanvas-title fw-semibold">
            <i class="fa-solid fa-file-invoice-dollar me-2"></i> Transaction Details
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body"
         id="transactionDetailsContent"
         style="padding:20px; background:#F8F6F8;">
    </div>
</div>




<div class="offcanvas offcanvas-top shadow-lg"
     tabindex="-1"
     id="reportsPanel"
     style="height: 100%; max-height: 100%; border-bottom: 3px solid #71103E;">

    <div class="offcanvas-header" style="background:#71103E; color:white; padding:18px 24px;">
        <h4 class="offcanvas-title fw-semibold">
            <i class="fa-solid fa-chart-line me-2"></i> Reports & Analytics
        </h4>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body"
         id="reportsContent"
         style="padding:30px; background:#F8F6F8; overflow-y:auto; height: calc(100% - 80px);">
    </div>
</div>





<div class="offcanvas offcanvas-end shadow-lg"
     tabindex="-1"
     id="reportTransactionDetailsPanel"
     style="width:100%; max-width:500px; border-left:3px solid #71103E;">

    <div class="offcanvas-header" style="background:#71103E; color:white;">
        <h5 class="offcanvas-title fw-semibold">
            <i class="fa-solid fa-file-invoice-dollar me-2"></i> Transaction Details
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body" id="reportTransactionDetailsContent"
         style="padding:20px; background:#F8F6F8;">
    </div>
</div>










<script>


    // Initialize Google Places Autocomplete for suburb input
    function initSuburbAutocomplete() {
    const input = document.getElementById('location');
     if (!input) {
    console.warn('No #location input found');
    return;
  }

    // Australia bounds (rough box) to help relevance
    const ausBounds = new google.maps.LatLngBounds(
      new google.maps.LatLng(-44.0, 112.0), // SW
      new google.maps.LatLng(-10.0, 154.0)  // NE
    );

    const autocomplete = new google.maps.places.Autocomplete(input, {
      // Regions returns localities, sublocalities, etc.
      types: ['(regions)'],
      componentRestrictions: { country: 'au' },
      fields: ['address_components', 'formatted_address', 'name', 'geometry'],
      bounds: ausBounds,
      strictBounds: true
    });

    autocomplete.addListener('place_changed', () => {
      const place = autocomplete.getPlace();
      console.log('Selected suburb:', place.formatted_address);
      if (!place || !place.address_components) return;

      // Extract suburb (locality or sublocality_level_1), state, postcode
      let suburb = '';
      let state = '';
      let postcode = '';

      place.address_components.forEach(c => {
        const types = c.types || [];
        if (types.includes('locality')) suburb = c.long_name;
        if (types.includes('sublocality') || types.includes('sublocality_level_1')) {
          // Some suburbs are provided as sublocality
          suburb = suburb || c.long_name;
        }
        if (types.includes('administrative_area_level_1')) state = c.short_name; // e.g., QLD, NSW
        if (types.includes('postal_code')) postcode = c.long_name;
      });

      // Accept only if we got a suburb-like value
      if (suburb) {
        const display = `${suburb}${state ? ', ' + state : ''}${postcode ? ' ' + postcode : ''}`;
        input.value = display;
        input.setCustomValidity('');
      } else {
        // Not a suburb: prompt user to pick a suburb
        input.setCustomValidity('Please select a suburb in Australia (not a street or business).');
        input.reportValidity();
      }
    });

    // Optional: prevent form submit on Enter before a place is selected
    input.addEventListener('keydown', (e) => {
      if (e.key === 'Enter') e.preventDefault();
    });
  }



//   Search Candidates
  function initSuburbAutocomplete() {
    const input = document.getElementById('locationSearch');
     if (!input) {
    console.warn('No #location input found');
    return;
  }

    // Australia bounds (rough box) to help relevance
    const ausBounds = new google.maps.LatLngBounds(
      new google.maps.LatLng(-44.0, 112.0), // SW
      new google.maps.LatLng(-10.0, 154.0)  // NE
    );

    const autocomplete = new google.maps.places.Autocomplete(input, {
      // Regions returns localities, sublocalities, etc.
      types: ['(regions)'],
      componentRestrictions: { country: 'au' },
      fields: ['address_components', 'formatted_address', 'name', 'geometry'],
      bounds: ausBounds,
      strictBounds: true
    });

    autocomplete.addListener('place_changed', () => {
      const place = autocomplete.getPlace();
      console.log('Selected suburb:', place.formatted_address);
      if (!place || !place.address_components) return;

      // Extract suburb (locality or sublocality_level_1), state, postcode
      let suburb = '';
      let state = '';
      let postcode = '';

      place.address_components.forEach(c => {
        const types = c.types || [];
        if (types.includes('locality')) suburb = c.long_name;
        if (types.includes('sublocality') || types.includes('sublocality_level_1')) {
          // Some suburbs are provided as sublocality
          suburb = suburb || c.long_name;
        }
        if (types.includes('administrative_area_level_1')) state = c.short_name; // e.g., QLD, NSW
        if (types.includes('postal_code')) postcode = c.long_name;
      });

      // Accept only if we got a suburb-like value
      if (suburb) {
        const display = `${suburb}${state ? ', ' + state : ''}${postcode ? ' ' + postcode : ''}`;
        input.value = display;
        input.setCustomValidity('');
      } else {
        // Not a suburb: prompt user to pick a suburb
        input.setCustomValidity('Please select a suburb in Australia (not a street or business).');
        input.reportValidity();
      }
    });

    // Optional: prevent form submit on Enter before a place is selected
    input.addEventListener('keydown', (e) => {
      if (e.key === 'Enter') e.preventDefault();
    });
  }



document.addEventListener("DOMContentLoaded", function () {

    const form = document.getElementById('candidateSearchForm');

    form.addEventListener('submit', function(e) {
        e.preventDefault();

        const role = document.getElementById('candidateRole').value;
        const location = document.getElementById('locationSearch').value;

        // Show Notiflix loading
        Notiflix.Loading.circle('Searching candidates...');

        fetch('/swApplications/search', {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({
                candidateRole: role,
                locationSearch: location
            })
        })
        .then(res => res.json())
        .then(data => {

            // Remove loader
            Notiflix.Loading.remove();

            const resultsEl = document.getElementById('searchResults');

            // Search failed
            if (!data.success) {
                Notiflix.Notify.failure('Search failed. Please try again.');
                resultsEl.innerHTML = `<p class="text-danger">Search failed.</p>`;
                return;
            }

            // No results
            if (data.results.length === 0) {
                Notiflix.Notify.info('No candidates found.');
                resultsEl.innerHTML = `<p class="text-muted">No candidates found.</p>`;
                return;
            }

            // Success
            Notiflix.Notify.success('Candidates loaded successfully.');

            let html = '';

            data.results.forEach(app => {
                html += `
                   <div onclick="swOpenCandidateProfile(${app.id})"
                        style="
                            background:#ffffff;
                            border-radius:14px;
                            padding:18px;
                            border:1px solid #e5e5e5;
                            box-shadow:0 2px 8px rgba(0,0,0,0.06);
                            transition:all .25s ease;
                            cursor:pointer;
                        "
                        onmouseenter="this.style.background='#faf5f8'; this.style.boxShadow='0 6px 18px rgba(0,0,0,0.12)'"
                        onmouseleave="this.style.background='#ffffff'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.06)'"
                    >

                        <div style="display:flex; flex-direction:column; gap:6px;">
                            <div style="font-size:18px; font-weight:600; color:#222;">
                                ${app.user.name}
                            </div>

                            <div style="font-size:14px; color:#666;">
                                ${app.job.location}
                            </div>

                            <div style="
                                background:#71103E;
                                color:#fff;
                                padding:4px 12px;
                                border-radius:20px;
                                font-size:12px;
                                width:max-content;
                                font-weight:500;
                            ">
                                ${app.job.category}
                            </div>
                        </div>

                    </div>
                `;
            });

            resultsEl.innerHTML = html;
        })
        .catch(err => {
            Notiflix.Loading.remove();
            Notiflix.Notify.failure('Something went wrong.');
            console.error(err);
        });
    });

});


function swOpenCandidateProfile(appId) {

    // Initialize and open the offcanvas panel
    const panel = bootstrap.Offcanvas.getOrCreateInstance('#candidateProfilePanel');
    panel.show();

    // Loading state
    const container = document.getElementById('candidateProfileContent');
    container.innerHTML = `
        <div class="text-center py-4">
            <div class="spinner-border text-primary mb-3" role="status"></div>
            <p class="text-muted mb-0">Fetching candidate profile…</p>
        </div>
    `;

    // Fetch candidate details
    fetch(`/swApplicationsD/${appId}`)
        .then(res => res.json())
        .then(data => {

            const { application: app } = data;
            const { user, job } = app;

            const html = `
                <div class="container py-2">

                    <!-- Header -->
                    <div class="row align-items-center mb-3">
                        <div class="col">
                            <h3 class="fw-bold mb-1">Name:${user.name}</h3>
                            <p class="text-muted mb-1">Location:${job.location}</p>
                            <span class="badge bg-success px-3 py-2">
                                <strong>Category:</strong> ${job.category}
                            </span>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="d-flex gap-2 mb-4">

                        <button 
                            class="btn btn-primary px-4 py-2"
                            style="
                                border-radius: 8px;
                                background: linear-gradient(90deg, #71103E, #9A1A57);
                                border: none;
                                font-weight: 600;
                                letter-spacing: .3px;
                            "
                            onclick="swSendJobOffer(${app.id})">
                            <i class="bi bi-briefcase-fill me-1"></i> Send Job Offer
                        </button>

                        <button 
                            class="btn btn-outline-dark px-4 py-2"
                            style="
                                border-radius: 8px;
                                font-weight: 600;
                                letter-spacing: .3px;
                                border-color: #444;
                            "
                            onclick="swSaveToDirectory(${user.id})">
                            <i class="bi bi-bookmark-star me-1"></i> Save to Employer Directory
                        </button>

                    </div>

                    <hr class="my-4">

                    <!-- Contact Information -->
                    <section class="mb-4">
                        <h5 class="fw-semibold mb-3">Contact Information</h5>
                        <p class="mb-1"><strong>Email:</strong> ${user.email}</p>
                    </section>

                    <hr class="my-4">

                    <!-- Documents -->
                    <section>
                        <h5 class="fw-semibold mb-3">Documents</h5>

                        <button class="btn btn-outline-primary btn-sm me-2"
                            onclick="swShowResumed('${app.resume_path}')">
                            View Resume
                        </button>

                        ${app.cover_letter_path ? `
                            <button class="btn btn-outline-secondary btn-sm"
                                onclick="swShowCoverd('${app.cover_letter_path}')">
                                View Cover Letter
                            </button>
                        ` : ''}
                    </section>

                </div>
            `;

            container.innerHTML = html;
        })
        .catch(() => {
            container.innerHTML = `
                <div class="alert alert-danger mt-3">
                    Unable to load candidate profile. Please try again.
                </div>
            `;
        });
}



function swShowResumed(path) {
    Swal.fire({
        title: 'Candidate Resume',
        width: '80%',
        padding: '1rem',
        html: `
            <iframe src="/storage/${path}" 
                style="width:100%; height:75vh; border:none; border-radius:8px;">
            </iframe>
        `,
        showCloseButton: true,
        showConfirmButton: false,
        background: '#fff',
    });
}






function swShowCoverd(path) {
    Swal.fire({
        title: 'Candidate Cover Letter',
        width: '80%',
        background:'rgb(113,16,62)',
        padding: '1rem',
        html: `
            <iframe src="/storage/${path}" 
                style="width:100%; height:75vh; border:none; border-radius:8px;">
            </iframe>
        `,
        showCloseButton: true,
        showConfirmButton: false,
        background: '#fff',
    });
}



function swSaveToDirectory(userId) {

    // Show loading overlay
    Notiflix.Loading.circle('Saving to directory...');

    fetch('/employer-directory/save', {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({
            user_id: userId
        })
    })
    .then(res => res.json())
    .then(data => {

        Notiflix.Loading.remove();

        if (!data.success) {
            Notiflix.Notify.failure(data.message || 'Unable to save candidate.');
            return;
        }

        Notiflix.Notify.success('Candidate saved to your directory.');
    })
    .catch(err => {
        Notiflix.Loading.remove();
        Notiflix.Notify.failure('Something went wrong.');
        console.error(err);
    });
}



function swOpenSavedDirectory() {

    const panel = bootstrap.Offcanvas.getOrCreateInstance('#savedDirectoryPanel');
    panel.show();

    const container = document.getElementById('savedDirectoryContent');

    // Loading state
    container.innerHTML = `
        <div class="text-center py-4">
            <div class="spinner-border text-primary mb-3"></div>
            <p class="text-muted">Loading saved candidates…</p>
        </div>
    `;

    fetch('/employer-directory/list')
        .then(res => res.json())
        .then(data => {

            if (!data.success || data.results.length === 0) {
                container.innerHTML = `
                    <p class="text-muted text-center mt-3">No saved candidates yet.</p>
                `;
                return;
            }

            let html = `<div style="display:flex; flex-direction:column; gap:14px;">`;

            data.results.forEach(c => {
                html += `
                    <div 
                        onclick="swOpenCandidateProfile(${c.application_id})"
                        style="
                            background:white;
                            border-radius:12px;
                            padding:16px;
                            border:1px solid #e5e5e5;
                            box-shadow:0 2px 8px rgba(0,0,0,0.06);
                            cursor:pointer;
                            transition:all .25s ease;
                        "
                        onmouseenter="this.style.background='#faf5f8'; this.style.boxShadow='0 6px 18px rgba(0,0,0,0.12)'"
                        onmouseleave="this.style.background='white'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.06)'"
                    >
                        <div style="font-size:17px; font-weight:600; color:#222;">
                            ${c.name}
                        </div>

                        <div style="font-size:14px; color:#666;">
                            ${c.location}
                        </div>

                        <div style="
                            background:#71103E;
                            color:white;
                            padding:4px 10px;
                            border-radius:20px;
                            font-size:12px;
                            width:max-content;
                            margin-top:6px;
                        ">
                            ${c.category}
                        </div>
                    </div>
                `;
            });

            html += `</div>`;
            container.innerHTML = html;
        })
        .catch(err => {
            container.innerHTML = `<p class="text-danger">Failed to load directory.</p>`;
            console.error(err);
        });
}


let recommendedCache = []; // store results for searching

function swOpenRecommendedMatches() {

    const panel = bootstrap.Offcanvas.getOrCreateInstance('#recommendedMatchesPanel');
    panel.show();

    const container = document.getElementById('recommendedMatchesContent');

    container.innerHTML = `
        <div class="text-center py-4">
            <div class="spinner-border text-primary mb-3"></div>
            <p class="text-muted">Loading recommended matches…</p>
        </div>
    `;

    Notiflix.Loading.circle('Finding recommended matches...');

    fetch('/recommended-matches')
        .then(res => res.json())
        .then(data => {

            Notiflix.Loading.remove();

            if (!data.success || data.results.length === 0) {
                container.innerHTML = `
                    <p class="text-muted text-center mt-3">No recommended matches found.</p>
                `;
                return;
            }

            // Remove duplicates by candidate_id
            const unique = Array.from(
                new Map(data.results.map(item => [item.candidate_id, item])).values()
            );

            recommendedCache = unique; // store for search

            swRenderRecommendedMatches(unique);
        })
        .catch(err => {
            Notiflix.Loading.remove();
            container.innerHTML = `<p class="text-danger">Failed to load recommended matches.</p>`;
            console.error(err);
        });
}



function swRenderRecommendedMatches(list) {
    const container = document.getElementById('recommendedMatchesContent');

    let html = `
        <div style="
            display:grid;
            grid-template-columns: repeat(auto-fill, minmax(260px, 1fr));
            gap:16px;
        ">
    `;

    list.forEach(c => {
        html += `
            <div 
                onclick="swOpenCandidateProfile(${c.application_id})"
                style="
                    background:white;
                    border-radius:12px;
                    padding:16px;
                    border:1px solid #e5e5e5;
                    box-shadow:0 2px 8px rgba(0,0,0,0.06);
                    cursor:pointer;
                    transition:all .25s ease;
                "
                onmouseenter="this.style.background='#faf5f8'; this.style.boxShadow='0 6px 18px rgba(0,0,0,0.12)'"
                onmouseleave="this.style.background='white'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.06)'"
            >
                <div style="font-size:17px; font-weight:600; color:#222;">
                    ${c.name}
                </div>

                <div style="font-size:14px; color:#666;">
                    ${c.location}
                </div>

                <div style="
                    background:#71103E;
                    color:white;
                    padding:4px 10px;
                    border-radius:20px;
                    font-size:12px;
                    width:max-content;
                    margin-top:6px;
                ">
                    ${c.category}
                </div>
            </div>
        `;
    });

    html += `</div>`;
    container.innerHTML = html;
}


function swFilterRecommendedMatches() {
    const q = document.getElementById('recommendedSearchInput').value.toLowerCase();

    const filtered = recommendedCache.filter(c =>
        c.name.toLowerCase().includes(q) ||
        c.location.toLowerCase().includes(q) ||
        c.category.toLowerCase().includes(q)
    );

    swRenderRecommendedMatches(filtered);
}




let jobPerformanceCache = []; // store results for searching

function swOpenJobPerformance() {

    const panel = bootstrap.Offcanvas.getOrCreateInstance('#jobPerformancePanel');
    panel.show();

    const container = document.getElementById('jobPerformanceContent');

    container.innerHTML = `
        <div class="text-center py-4">
            <div class="spinner-border text-primary mb-3"></div>
            <p class="text-muted">Loading job performance data…</p>
        </div>
    `;

    Notiflix.Loading.circle('Analyzing job performance...');

    fetch('/job-performance')
        .then(res => res.json())
        .then(data => {

            Notiflix.Loading.remove();

            if (!data.success || data.results.length === 0) {
                container.innerHTML = `
                    <p class="text-muted text-center mt-3">No performance data available.</p>
                `;
                return;
            }

            // Cache results for search
            jobPerformanceCache = data.results;

            // Render initial results
            swRenderJobPerformance(jobPerformanceCache);

        })
        .catch(err => {
            Notiflix.Loading.remove();
            container.innerHTML = `<p class="text-danger">Failed to load job performance data.</p>`;
            console.error(err);
        });
}

function swRenderJobPerformance(list) {
    const container = document.getElementById('jobPerformanceContent');

    let html = `
        <div style="
            display:grid;
            grid-template-columns: repeat(auto-fill, minmax(260px, 1fr));
            gap:16px;
        ">
    `;

    list.forEach(job => {
        html += `
            <div 
                class="job-analytics-card"
                onclick='swShowJobAnalytics(${JSON.stringify(job)})'
                style="
                    background:white;
                    border-radius:12px;
                    padding:16px;
                    border:1px solid #e5e5e5;
                    box-shadow:0 2px 8px rgba(0,0,0,0.06);
                    transition:all .25s ease;
                    cursor:pointer;
                "
                onmouseenter="this.style.background='#f7eef3'; this.style.boxShadow='0 6px 18px rgba(0,0,0,0.12)'"
                onmouseleave="this.style.background='white'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.06)'"
            >
                <h6 class="fw-bold mb-1">${job.job_title}</h6>
                <p class="text-muted mb-1">${job.location}</p>

                <div class="mt-2">
                    <span class="badge bg-primary">Applications: ${job.applications}</span>
                </div>

                <div class="mt-2">
                    <span class="badge bg-success">Shortlisted: ${job.shortlisted}</span>
                </div>

                <div class="mt-2">
                    <span class="badge bg-secondary">Pending: ${job.pending}</span>
                </div>

                <div class="mt-2">
                    <span class="badge bg-warning text-dark">Interview: ${job.interview}</span>
                </div>

                <div class="mt-2">
                    <span class="badge bg-danger">Rejected: ${job.rejected}</span>
                </div>
            </div>
        `;
    });

    html += `</div>`;
    container.innerHTML = html;
}


function swFilterJobPerformance() {
    const q = document.getElementById('jobPerformanceSearchInput').value.toLowerCase();

    const filtered = jobPerformanceCache.filter(job =>
        job.job_title.toLowerCase().includes(q) ||
        job.location.toLowerCase().includes(q) ||
        job.category.toLowerCase().includes(q)
    );

    swRenderJobPerformance(filtered);
}

function swShowJobAnalytics(job) {

    Swal.fire({
        title: job.job_title,
        width: 700,
        background: '#fff',
        confirmButtonColor: '#71103E',
        html: `
            <p class="text-muted">${job.location}</p>

            <!-- Trend Arrow -->
            <div id="trendArrow" style="font-size:18px; margin-bottom:10px;"></div>

            <!-- Fancy Bar Chart -->
            <h6 class="mt-3">Job Performance Overview</h6>
            <canvas id="barChart" style="width:100%; height:260px;"></canvas>

            <!-- AI Insights -->
            <div id="aiInsight" 
                 style="margin-top:20px; padding:12px; background:#f7eef3; border-radius:8px; color:#71103E; font-weight:500;">
            </div>
        `,
        didOpen: () => {

            // Trend Arrow
            const trend = job.applications > job.last_week ? "up" : "down";
            document.getElementById("trendArrow").innerHTML =
                trend === "up"
                    ? `<span style="color:green;">↑ ${job.applications - job.last_week} this week</span>`
                    : `<span style="color:red;">↓ ${job.last_week - job.applications} this week</span>`;

            // Fancy Gradient Bar Chart
            const ctx = document.getElementById('barChart').getContext('2d');

            const gradient = ctx.createLinearGradient(0, 0, 0, 300);
            gradient.addColorStop(0, '#71103E');
            gradient.addColorStop(1, '#C94F8A');

            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: ['Applications', 'Shortlisted', 'Pending', 'Interview', 'Rejected'],
                    datasets: [{
                        label: 'Count',
                        data: [
                            job.applications,
                            job.shortlisted,
                            job.pending,
                            job.interview,
                            job.rejected
                        ],
                        backgroundColor: gradient,
                        borderRadius: 10,
                        borderSkipped: false,
                        hoverBackgroundColor: '#9A1A57'
                    }]
                },
                options: {
                    responsive: true,
                    animation: {
                        duration: 900,
                        easing: 'easeOutQuart'
                    },
                    plugins: {
                        legend: { display: false },
                        tooltip: {
                            backgroundColor: '#71103E',
                            titleColor: '#fff',
                            bodyColor: '#fff',
                            padding: 12,
                            borderWidth: 0,
                            cornerRadius: 8
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: { color: '#444' },
                            grid: { color: '#eee' }
                        },
                        x: {
                            ticks: { color: '#444' },
                            grid: { display: false }
                        }
                    }
                }
            });

            // AI Insight
            let insight = "";
            if (job.rejected > job.shortlisted) {
                insight = "This job is underperforming — too many rejections compared to shortlisted candidates.";
            } else if (job.pending > 10) {
                insight = "High pending count — consider reviewing applications faster.";
            } else if (job.shortlisted > job.applications * 0.5) {
                insight = "Strong candidate pool — this job is attracting high‑quality applicants.";
            } else {
                insight = "Performance is stable. No major issues detected.";
            }

            document.getElementById("aiInsight").innerHTML = insight;
        }
    });
}



function swOpenJobPerformanceTracking() {

    const panel = bootstrap.Offcanvas.getOrCreateInstance('#jobPerformancePanelTracking');
    panel.show();

    const container = document.getElementById('jobPerformanceContentTracking');

    container.innerHTML = `
        <div class="text-center py-4">
            <div class="spinner-border text-primary mb-3"></div>
            <p class="text-muted">Loading job performance…</p>
        </div>
    `;

    fetch('/job-performance-tracking')
        .then(res => res.json())
        .then(data => {

            if (!data.success || data.results.length === 0) {
                container.innerHTML = `<p class="text-muted text-center mt-3">No job performance data found.</p>`;
                return;
            }

            let html = `
                <div style="display:grid; grid-template-columns:repeat(auto-fill,minmax(240px,1fr)); gap:16px;">
            `;

            data.results.forEach(job => {
                html += `
                    <div 
                        onclick='swShowJobViewAnalytics(${JSON.stringify(job)})'
                        style="
                            background:white;
                            border-radius:12px;
                            padding:16px;
                            border:1px solid #e5e5e5;
                            box-shadow:0 2px 8px rgba(0,0,0,0.06);
                            transition:0.25s;
                            cursor:pointer;
                        "
                        onmouseenter="this.style.background='#f7eef3'; this.style.boxShadow='0 6px 18px rgba(0,0,0,0.12)'"
                        onmouseleave="this.style.background='white'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.06)'"
                    >
                        <h6 class="fw-bold mb-1">${job.job_title}</h6>
                        <p class="text-muted mb-1">${job.location}</p>

                        <span class="badge bg-primary">Views: ${job.views}</span>
                    </div>
                `;
            });

            html += `</div>`;
            container.innerHTML = html;
        });
}


function swShowJobViewAnalytics(job) {

    Swal.fire({
        title: job.job_title,
        width: 650,
        background: '#fff',
        confirmButtonColor: '#71103E',
        html: `
            <p class="text-muted">${job.location}</p>

            <h6 class="mt-3">Job View Performance</h6>
            <canvas id="viewChart" style="width:100%; height:260px;"></canvas>

            <div id="aiInsightViews"
                 style="margin-top:20px; padding:12px; background:#f7eef3;
                        border-radius:8px; color:#71103E; font-weight:500;">
            </div>
        `,
        didOpen: () => {

            // Fancy gradient bar chart
            const ctx = document.getElementById('viewChart').getContext('2d');

            const gradient = ctx.createLinearGradient(0, 0, 0, 300);
            gradient.addColorStop(0, '#71103E');
            gradient.addColorStop(1, '#C94F8A');

            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: ['Total Views'],
                    datasets: [{
                        label: 'Views',
                        data: [job.views],
                        backgroundColor: gradient,
                        borderRadius: 12,
                        borderSkipped: false,
                        hoverBackgroundColor: '#9A1A57'
                    }]
                },
                options: {
                    responsive: true,
                    animation: { duration: 900, easing: 'easeOutQuart' },
                    plugins: {
                        legend: { display: false },
                        tooltip: {
                            backgroundColor: '#71103E',
                            titleColor: '#fff',
                            bodyColor: '#fff',
                            padding: 12,
                            cornerRadius: 8
                        }
                    },
                    scales: {
                        y: { beginAtZero: true, ticks: { color: '#444' }, grid: { color: '#eee' }},
                        x: { ticks: { color: '#444' }, grid: { display: false }}
                    }
                }
            });

        // Insights
            let insight = "";
            if (job.views > 100) {
                insight = "This job is getting strong attention — high visibility!";
            } else if (job.views > 30) {
                insight = "This job is performing well with steady engagement.";
            } else if (job.views > 10) {
                insight = "Moderate engagement — consider boosting visibility.";
            } else {
                insight = "Low engagement — consider improving title, location, or Hourly Rate.";
            }

            document.getElementById("aiInsightViews").innerHTML = insight;
        }
    });
}

function swOpenProfileSettings() {

    const panel = bootstrap.Offcanvas.getOrCreateInstance('#profileSettingsPanel');
    panel.show();

    const container = document.getElementById('profileSettingsContent');

    container.innerHTML = `
        <div class="text-center py-4">
            <div class="spinner-border text-primary mb-3"></div>
            <p class="text-muted">Loading profile…</p>
        </div>
    `;

    fetch('/profile-settings')
        .then(res => res.json())
        .then(data => {

            if (!data.success) {
                container.innerHTML = `<p class="text-danger">Failed to load profile.</p>`;
                return;
            }

            const user = data.user;
            const company = data.company;

            container.innerHTML = `
                <div style="
                    display: grid;
                    grid-template-columns: 1fr 1fr;
                    gap: 24px;
                    padding-bottom: 40px;
                " class="settings-grid">

                    <!-- USER DETAILS -->
                    <div class="settings-card">
                        <h5 class="settings-title">
                            <i class="fa-solid fa-user-gear me-2"></i> User Details
                        </h5>

                        <label class="fw-bold mt-2"><i class="fa-solid fa-id-card me-1"></i> Full Name</label>
                        <input id="ps_name" type="text" class="form-control mb-3" value="${user.name ?? ''}">

                        <label class="fw-bold mt-2"><i class="fa-solid fa-envelope me-1"></i> Email</label>
                        <input id="ps_email" type="email" class="form-control mb-3" value="${user.email ?? ''}">
                    </div>

                    <!-- COMPANY DETAILS -->
                    <div class="settings-card">
                        <h5 class="settings-title">
                            <i class="fa-solid fa-building me-2"></i> Company Details
                        </h5>

                        <!-- LOGO -->
                        <div class="text-center mb-4">
                            <img id="ps_logo_preview"
                                src="${company.logo_url ?? '/default-logo.png'}"
                                class="company-logo">

                            <input type="file" id="ps_logo" accept="image/*"
                                style="display:none;" onchange="swPreviewLogo(event)">

                            <button onclick="document.getElementById('ps_logo').click()" class="btn-change-logo">
                                <i class="fa-solid fa-camera me-1"></i> Change Logo
                            </button>
                        </div>

                        <!-- STATUS BADGE -->
                        <div class="mb-3">
                            <span class="status-badge ${company.status === 'Active' ? 'active' : 'inactive'}">
                                <i class="fa-solid fa-circle-check me-1"></i> ${company.status}
                            </span>
                        </div>

                        <label class="fw-bold mt-2"><i class="fa-solid fa-briefcase me-1"></i> Company Name</label>
                        <input id="ps_company_name" type="text" class="form-control mb-3" value="${company.name ?? ''}">

                        <label class="fw-bold mt-2"><i class="fa-solid fa-hashtag me-1"></i> ABN</label>
                        <input type="text" class="form-control mb-3" value="${company.abn ?? ''}" disabled>

                        <label class="fw-bold mt-2"><i class="fa-solid fa-industry me-1"></i> Industry</label>
                        <input id="ps_industry" type="text" class="form-control mb-3" value="${company.industry ?? ''}">

                        <label class="fw-bold mt-2"><i class="fa-solid fa-globe me-1"></i> Website</label>
                        <input id="ps_website" type="text" class="form-control mb-3" value="${company.website ?? ''}">

                        <label class="fw-bold mt-2"><i class="fa-solid fa-location-dot me-1"></i> Postal Address</label>
                        <input id="ps_address" type="text" class="form-control mb-3" value="${company.address ?? ''}">

                        <label class="fw-bold mt-2"><i class="fa-solid fa-phone me-1"></i> Phone Number</label>
                        <input id="ps_company_phone" type="text" class="form-control mb-3" value="${company.phone ?? ''}">
                    </div>

                </div>

                <!-- SAVE BUTTON -->
                <button onclick="swSaveProfileSettings()" class="btn-save-settings">
                    <i class="fa-solid fa-floppy-disk me-2"></i> Save Changes
                </button>
            `;

            // Initialize Google Autocomplete AFTER DOM loads
            setTimeout(() => initAddressAutocomplete(), 300);
        });
}


let psAddressAutocomplete;

function initAddressAutocomplete() {
    const input = document.getElementById('ps_address');
    if (!input) return;

    psAddressAutocomplete = new google.maps.places.Autocomplete(input, {
        types: ['address'],
        componentRestrictions: { country: 'au' } // Australia only
    });

    psAddressAutocomplete.addListener('place_changed', () => {
        const place = psAddressAutocomplete.getPlace();
        console.log("Selected address:", place.formatted_address);

        // Ensure the field gets the formatted address
        document.getElementById('ps_address').value = place.formatted_address;
    });
}




function swPreviewLogo(event) {
    const file = event.target.files[0];
    if (!file) return;

    const preview = document.getElementById('ps_logo_preview');
    preview.src = URL.createObjectURL(file);
}

function swSaveProfileSettings() {

    const formData = new FormData();

    // Company fields
    formData.append('company_name', document.getElementById('ps_company_name').value);
    formData.append('industry', document.getElementById('ps_industry').value);
    formData.append('website', document.getElementById('ps_website').value);
    formData.append('address', document.getElementById('ps_address').value);
    formData.append('company_phone', document.getElementById('ps_company_phone').value);

    // User fields
    formData.append('name', document.getElementById('ps_name').value);
    formData.append('email', document.getElementById('ps_email').value);

    // Logo
    const logoFile = document.getElementById('ps_logo').files[0];
    if (logoFile) formData.append('logo', logoFile);

    fetch('/profile-settings', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: formData
    })
    .then(res => res.json())
    .then(data => {

        console.log("SAVE RESPONSE:", data);

        if (!data.success) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Failed to update profile.'
            });
            return;
        }

        Swal.fire({
            icon: 'success',
            title: 'Profile Updated',
            text: 'Your company and account details have been saved successfully.',
            confirmButtonColor: '#71103E'
        }).then(() => {

            // CLOSE THE OFFCANVAS HERE
            const panel = bootstrap.Offcanvas.getInstance('#profileSettingsPanel');
            if (panel) panel.hide();

        });
    })
    .catch(err => {
        console.error("SAVE ERROR:", err);
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Something went wrong.'
        });
    });
}



function swOpenTransactions() {

    const panel = bootstrap.Offcanvas.getOrCreateInstance('#transactionsPanel');
    panel.show();

    const container = document.getElementById('transactionsContent');

    container.innerHTML = `
        <div class="text-center py-5">
            <div class="spinner-border text-primary mb-3"></div>
            <p class="text-muted">Loading transactions…</p>
        </div>
    `;

    fetch('/transactions')
        .then(res => res.json())
        .then(data => {

            if (!data.success) {
                container.innerHTML = `
                    <div class="alert alert-danger text-center">
                        <i class="fa-solid fa-triangle-exclamation me-2"></i>
                        Failed to load transactions.
                    </div>
                `;
                return;
            }

            const list = data.transactions;

            if (list.length === 0) {
                container.innerHTML = `
                    <div class="text-center py-5 text-muted">
                        <i class="fa-solid fa-file-invoice-dollar fa-3x mb-3"></i>
                        <p>No transactions found.</p>
                    </div>
                `;
                return;
            }

            let html = `
                <table class="table table-hover transaction-table">
                    <thead>
                        <tr>
                            <th><i class="fa-solid fa-file-invoice-dollar me-1"></i>Transaction ID</th>
                            <th><i class="fa-solid fa-briefcase me-1"></i> Job Title</th>
                            <th><i class="fa-solid fa-tag me-1"></i> Type</th>
                            <th><i class="fa-solid fa-location-dot me-1"></i> Location</th>
                            <th><i class="fa-solid fa-calendar me-1"></i> Date</th>
                            <th><i class="fa-solid fa-circle-check me-1"></i> Status</th>
                        </tr>
                    </thead>
                    <tbody>
            `;

            list.forEach((t, index) => {
                html += `
                    <tr onclick="swShowTransactionDetails(${index})" class="transaction-row">
                        <td>${t.id}</td>
                        <td>${t.job_title}</td>
                        <td>${t.ad_type}</td>
                        <td>${t.location}</td>
                        <td>${t.transaction_date}</td>
                        <td>
                               <span class="status-badge ${t.ad_rev_status}">
                                        ${t.ad_rev_status === 'paid' 
                                            ? '<i class="fa-solid fa-circle-check me-1"></i> Paid' 
                                            : t.ad_rev_status.charAt(0).toUpperCase() + t.ad_rev_status.slice(1)
                                        }
                                    </span>
                        </td>
                    </tr>
                `;
            });

            html += `
                    </tbody>
                </table>
            `;

            container.innerHTML = html;

            // Store list globally for detail view
            window.__transactions = list;
        });
}




function toggleTransactionDetails(id) {
    const el = document.getElementById(`transaction-details-${id}`);
    el.style.display = el.style.display === "block" ? "none" : "block";
}

function swShowTransactionDetails(index) {
    const t = window.__transactions[index];

    const panel = bootstrap.Offcanvas.getOrCreateInstance('#transactionDetailsPanel');
    panel.show();

    const box = document.getElementById('transactionDetailsContent');

    box.innerHTML = `
        <div class="detail-card">

            <h5 class="fw-bold mb-3" style="color:#71103E;">
                <i class="fa-solid fa-briefcase me-2"></i> ${t.job_title}
            </h5>

            <p><strong>Ad Type:</strong> ${t.ad_type}</p>
            <p><strong>Location:</strong> ${t.location}</p>
            <p><strong>Transaction Date:</strong> ${t.transaction_date}</p>

            <hr>

            <p><strong>Price:</strong> $${t.ad_price}</p>
            <p><strong>Duration:</strong> ${t.ad_duration} days</p>
            <p><strong>Payment Intent ID:</strong><br>${t.payment_intent_id}</p>

            <hr>

            <p><strong>Status:</strong> 
                  <span class="status-badge ${t.ad_rev_status}">
                                        ${t.ad_rev_status === 'paid' 
                                            ? '<i class="fa-solid fa-circle-check me-1"></i> Paid' 
                                            : t.ad_rev_status.charAt(0).toUpperCase() + t.ad_rev_status.slice(1)
                                        }
                                    </span>
            </p>
        </div>
    `;
}


function swOpenReports(year = '', month = '') {
    const panel = bootstrap.Offcanvas.getOrCreateInstance('#reportsPanel');
    panel.show();

    const container = document.getElementById('reportsContent');
    container.innerHTML = `
        <div class="text-center py-5">
            <div class="spinner-border text-primary mb-3"></div>
            <p class="text-muted">Loading reports…</p>
        </div>
    `;

    fetch(`/transaction-reports?year=${year}&month=${month}`)
        .then(res => res.json())
        .then(data => {

            if (!data.success) {
                container.innerHTML = `
                    <div class="alert alert-danger text-center">
                        <i class="fa-solid fa-triangle-exclamation me-2"></i>
                        Failed to load reports.
                    </div>
                `;
                return;
            }

            const years = data.years;
            const months = data.months;
            const filtered = data.transactions;
            const totalSpent = data.total_spent;

            container.innerHTML = `
                <!-- FILTER BAR -->
                <div class="d-flex gap-3 flex-wrap mb-4">

                    <div>
                        <label class="form-label fw-bold">Year</label>
                        <select id="reportYear" class="form-select" onchange="swReloadReports()">
                            <option value="">All Years</option>
                            ${years.map(y => `
                                <option value="${y}" ${y == year ? 'selected' : ''}>${y}</option>
                            `).join('')}
                        </select>
                    </div>

                    <div>
                        <label class="form-label fw-bold">Month</label>
                        <select id="reportMonth" class="form-select" onchange="swReloadReports()">
                            <option value="">All Months</option>
                            <option value="1" ${month == 1 ? 'selected' : ''}>January</option>
                            <option value="2" ${month == 2 ? 'selected' : ''}>February</option>
                            <option value="3" ${month == 3 ? 'selected' : ''}>March</option>
                            <option value="4" ${month == 4 ? 'selected' : ''}>April</option>
                            <option value="5" ${month == 5 ? 'selected' : ''}>May</option>
                            <option value="6" ${month == 6 ? 'selected' : ''}>June</option>
                            <option value="7" ${month == 7 ? 'selected' : ''}>July</option>
                            <option value="8" ${month == 8 ? 'selected' : ''}>August</option>
                            <option value="9" ${month == 9 ? 'selected' : ''}>September</option>
                            <option value="10" ${month == 10 ? 'selected' : ''}>October</option>
                            <option value="11" ${month == 11 ? 'selected' : ''}>November</option>
                            <option value="12" ${month == 12 ? 'selected' : ''}>December</option>
                        </select>
                    </div>

                </div>

                <!-- TOTAL SPENT -->
                <div class="report-card mb-4" style="border-left:4px solid #71103E;">
                    <h6 class="report-title">
                        <i class="fa-solid fa-sack-dollar me-2"></i> Total Spent
                    </h6>
                    <div class="report-value">$${totalSpent.toFixed(2)}</div>
                    <div class="report-subtext">${filtered.length} transactions</div>
                </div>

                <!-- TRANSACTION TABLE -->
                <div class="table-responsive mt-3">
                    <table class="table table-hover transaction-table">
                        <thead>
                            <tr>
                                <th>Job Title</th>
                                <th>Type</th>
                                <th>Location</th>
                                <th>Date</th>
                                <th>Price</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${filtered.map((t, index) => `
                                <tr onclick="swShowTransactionReportDetails(${index})" class="transaction-row">
                                    <td>${t.job_title}</td>
                                    <td>${t.ad_type}</td>
                                    <td>${t.location}</td>
                                    <td>${t.transaction_date}</td>
                                    <td>$${t.ad_price}</td>
                                    <td>
                                        <span class="status-badge ${t.ad_rev_status}">
                                            ${t.ad_rev_status === 'paid'
                                                ? '<i class="fa-solid fa-circle-check me-1"></i> Paid'
                                                : t.ad_rev_status.charAt(0).toUpperCase() + t.ad_rev_status.slice(1)
                                            }
                                        </span>
                                    </td>
                                </tr>
                            `).join('')}
                        </tbody>
                    </table>
                </div>
            `;

            window.__reportTransactions = filtered;
        })
        .catch(err => {
            console.error(err);
            container.innerHTML = `
                <div class="alert alert-danger text-center">
                    <i class="fa-solid fa-circle-xmark me-2"></i>
                    Something went wrong.
                </div>
            `;
        });
}




function swShowTransactionReportDetails(index) {
    const t = window.__reportTransactions[index];

    const panel = bootstrap.Offcanvas.getOrCreateInstance('#reportTransactionDetailsPanel');
    panel.show();

    const box = document.getElementById('reportTransactionDetailsContent');

    box.innerHTML = `
        <div class="detail-card">
            <h5 class="fw-bold mb-3" style="color:#71103E;">
                <i class="fa-solid fa-briefcase me-2"></i> ${t.job_title}
            </h5>

            <p><strong>Ad Type:</strong> ${t.ad_type}</p>
            <p><strong>Location:</strong> ${t.location}</p>
            <p><strong>Transaction Date:</strong> ${t.transaction_date}</p>

            <hr>

            <p><strong>Price:</strong> $${t.ad_price}</p>
            <p><strong>Duration:</strong> ${t.ad_duration} days</p>
            <p><strong>Payment Intent ID:</strong><br>${t.payment_intent_id}</p>

            <hr>

           <p><strong>Status:</strong> 
    <span class="status-badge ${t.ad_rev_status}">
        ${t.ad_rev_status === 'paid' 
            ? '<i class="fa-solid fa-circle-check me-1"></i> Paid' 
            : t.ad_rev_status.charAt(0).toUpperCase() + t.ad_rev_status.slice(1)
        }
    </span>
</p>

        </div>
    `;
}

function swFilterTransactions() {
    const query = document.getElementById('transactionsSearch').value.toLowerCase();
    const rows = document.querySelectorAll("#transactionsContent table tbody tr");

    rows.forEach(row => {
        const text = row.innerText.toLowerCase();
        row.style.display = text.includes(query) ? "" : "none";
    });
}

function swReloadReports() {
    const year = document.getElementById('reportYear').value;
    const month = document.getElementById('reportMonth').value;

    swOpenReports(year, month);
}








</script>





<?php /**PATH E:\CareerJobs\resources\views/components/offcanvas.blade.php ENDPATH**/ ?>