<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(config('app.name', 'Laravel')); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss', 'resources/js/app.js']); ?>
     <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">






    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #eff1f3; 
        }

        /* Sidebar base */
#sidebar {
    padding: 8px;
    background-color: rgb(85, 6, 43);
    backdrop-filter: blur(10px);
    border-right: 1px solid rgba(0, 0, 0, 0.1);
    z-index: 1000;
    min-height: 100vh;
    position: fixed;
    margin-top: 36px;
    left: 0;
    transition: left 0.3s ease;
    overflow: visible; /* allow dropdowns */

}

.navbar {
            background-color: rgb(113, 16, 62) !important;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000; /* Ensure it stays above other content */
        }


        /* Nav link styles */
        .nav-link {
            display: flex;
            align-items: center;
            color: white; /* White text color for links */
            text-decoration: none;
            padding: 10px 15px;
            transition: background-color 0.3s;
            white-space: nowrap;
        }

        .nav-link:hover {
            background-color:rgb(113, 16, 62) ; /* Light background on hover */
        }

       .nav-item {
    position: relative;
}

        .nav-item i {
            margin-right: 1px;
        }

        /* Dropdown panel styles */
     .dropdown-panel {
    display: none;
    position: absolute;
    left: 100%; /* or left:0; top:100% for below */
    top: 0;
    background: rgba(113, 16, 62, 0.9);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.5);
    border-radius: 12px;
    width: 250px;
    z-index: 1000;
    padding: 10px;
}

      .nav-item:hover .dropdown-panel,
.dropdown-panel:hover {
    display: block;
}

        .dropdown-panel .text-muted {
            color:white  !important; /* Dark text color for dropdown items */
        }

        .dropdown-panel a:hover {
            /* background-color: white; Light green hover for dropdown items */
            color: black; /* Change text color on hover */
        }

        /* Desktop: always visible */
        @media (min-width: 769px) {
            #sidebar {
                width: 200px;
                height: auto;
            }

            #sidebar-overlay {
                display: none !important;
            }

            .toggle-sidebar {
                display: none !important;
            }
        }

        /* Mobile: hidden by default, slides in */
        @media (max-width: 768px) {
            #sidebar {
                left: -250px; /* Hidden */
                width: 250px;
                height: 100vh;
            }

            #sidebar.active {
                left: 0; /* Slide in */
            }

            #sidebar-overlay {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0, 0, 0, 0.4);
                z-index: 900;
            }

            #sidebar.active + #sidebar-overlay {
                display: block;
            }

            .toggle-sidebar {
                display: block;
                position: fixed;
                top: 10px;
                left: 10px;
                z-index: 1100;
            }
        }
        .off-categories.offcanvas-top {
    height: 100vh !important;
    max-height: 100vh !important;
    border-bottom-left-radius: 0 !important;
    border-bottom-right-radius: 0 !important;
}
.off-categories.offcanvas-top {
    transform: translateY(-100%);
    transition: transform .35s ease-in-out;
}

.off-categories.offcanvas-top.show {
    transform: translateY(0);
}
.bg-purple {
  background: #6f42c1 !important;
}

.bg-teal {
  background: #20c997 !important;
}
.notification-badge {
    position: absolute;
    right: -20px;
    padding: 4px 7px;
    font-size: 0.7rem;
    font-weight: 700;
    animation: pulseBadge 1.2s infinite ease-in-out;
}

@keyframes pulseBadge {
    0% { transform: scale(0.9); opacity: 0.7; }
    50% { transform: scale(1.15); opacity: 1; }
    100% { transform: scale(0.9); opacity: 0.7; }
}


.blink {
    animation: blink 1s ease-in-out infinite;
}

.app-card {
    background: #ffffff;
    border-radius: 10px;
    padding: 25px 20px;
    text-align: center;
    cursor: pointer;
    transition: all 0.25s ease;
    border: 1px solid #eee;
    color: #333;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
}

.app-card i {
    color: rgb(113, 16, 62);
    transition: color 0.25s ease;
}

.app-card:hover {
    border-color: rgb(113, 16, 62);
    box-shadow: 0 4px 14px rgba(113, 16, 62, 0.25);
    transform: translateY(-3px);
}

.app-card:hover i,
.app-card:hover h6 {
    color: rgb(113, 16, 62);
}

.app-card:hover p {
    color: #444;
}

.app-card {
    position: relative;
}

/* Blinking notification dot */
.app-card-badge {
    position: absolute;
    top: 10px;
    right: 12px;
    background: rgb(255, 0, 0);
    color: white;
    padding: 2px 8px;
    font-size: 0.70rem;
    font-weight: 700;
    border-radius: 10px;
    display: none;
    animation: blink 1s infinite ease-in-out;
    box-shadow: 0 0 8px rgba(255, 0, 0, 0.8);
    text-transform: uppercase;
}


@keyframes blink {
    0% { opacity: 0.2; transform: scale(0.8); }
    50% { opacity: 1; transform: scale(1.2); }
    100% { opacity: 0.2; transform: scale(0.8); }
}





    </style>
</head>
<body class="bg-light">
    <div id="app" class="d-flex flex-column min-vh-100">
        <!-- Toggle button (mobile only) -->
        <button class="toggle-sidebar btn btn-primary" onclick="toggleSidebar()">
            <i class="fa fa-bars"></i>
        </button>

        <!-- Sidebar -->
        <nav id="sidebar" class="sidebar">
            <ul class="nav flex-column">
                <!-- Dashboard -->
                <li class="nav-item">
                    <a class="nav-link active" href="/admin/home">
  <i class="fa fa-tachometer-alt text-white"></i> Dashboard
</a>

                </li>












                <!-- Job Management -->
                <li class="nav-item">
                    <a class="nav-link" href="#"><i class="fa fa-briefcase text-white"></i> Job Management</a>
                    <div class="dropdown-panel">
                        <ul class="nav flex-column">
                            <li><a class="nav-link text-muted"  data-bs-toggle="offcanvas" data-bs-target="#jobFormCanvasUnique"  href="#">Post a Job</a></li>
                            <li><a class="nav-link text-muted" data-bs-toggle="offcanvas"
                     data-bs-target="#jobOffcanvas-open" href="#">Open Jobs</a></li>
                     <li><a class="nav-link text-muted" data-bs-toggle="offcanvas"
                      data-bs-target="#jobOffcanvas-active" href="#">Active Jobs</a></li>
                      <li><a class="nav-link text-muted" data-bs-toggle="offcanvas"
                        data-bs-target="#jobOffcanvas-closed" href="#">Closed Jobs</a></li>
                            <li><a class="nav-link text-muted" data-bs-toggle="offcanvas"
                      data-bs-target="#jobOffcanvas-expired" href="#">Expired</a></li>
                        </ul>
                    </div>
                </li>

                <!-- Applications -->
<!-- Applications -->
<li class="nav-item mt-2 position-relative">
    <a class="nav-link d-inline-flex align-items-center gap-1" 
       href="#" 
       data-bs-toggle="offcanvas" 
       data-bs-target="#applicationsPanel">

        <i class="fa fa-file-alt text-white"></i>
        <span>Applications</span>

        <span id="applicationsBadge" 
              class="badge bg-danger notification-badge d-none">0</span>
    </a>
</li>





                <!-- Candidates -->
                <li class="nav-item mt-2">
                    <a class="nav-link" href="#"><i class="fa fa-users text-white"></i> Candidates</a>
                    <div class="dropdown-panel">
                        <ul class="nav flex-column">
                            <li>
                                <a class="nav-link text-muted" href="#" data-bs-toggle="offcanvas" data-bs-target="#searchCandidatesPanel">
                                    Candidates Pool
                                </a>
                                </li>
                            <li>
                             <a class="nav-link text-muted"
                                    href="#"
                                    onclick="swOpenSavedDirectory()">
                               Saved Directory
                                    </a>
                            </li>
                           <li>
                                <a class="nav-link text-muted"
                                href="#"
                                style="cursor:pointer; transition:0.2s;"
                                onmouseover="this.style.color='#71103E'"
                                onmouseout="this.style.color='#6c757d'"
                                onclick="swOpenRecommendedMatches()">
                                Recommended Matches
                                </a>
                            </li>

                        </ul>
                    </div>
                </li>

                <!-- Employers -->
                

                <!-- Analytics -->
                <li class="nav-item mt-2">
                    <a class="nav-link" href="#"><i class="fa fa-chart-line text-white"></i> Analytics</a>
                    <div class="dropdown-panel">
                        <ul class="nav flex-column">
                          <li>
                            <a class="nav-link text-muted"
                            href="#"
                            style="cursor:pointer; transition:0.2s;"
                            onmouseover="this.style.color='#71103E'"
                            onmouseout="this.style.color='#6c757d'"
                            onclick="swOpenJobPerformance()">
                            Job Performance and Analysis
                            </a>
                        </li>

                            <li>
                        <a class="nav-link text-muted"
                        href="#"
                        onclick="swOpenJobPerformanceTracking()">
                        Job Posting Performance
                        </a>
                    </li>

                            
                            
                        </ul>
                    </div>
                </li>

                <!-- Messaging -->
                

                <!-- Settings -->
               <li class="nav-item mt-2">
    <a class="nav-link" href="#" onclick="swOpenProfileSettings()"><i class="fa fa-cogs text-white"></i> Settings</a>
</li>

<li class="nav-item mt-2">
    <a class="nav-link" href="#"><i class="fa fa-credit-card text-white"></i> Billing</a>
    <div class="dropdown-panel">
        <ul class="nav flex-column">
   <li>
    <a class="nav-link text-muted" href="#" onclick="swOpenTransactions()">
        <i class="fa-solid fa-receipt me-2"></i> Transactions
    </a>
</li>
<li>
    <a class="nav-link text-muted" href="#" onclick="swOpenReports()">
        <i class="fa-solid fa-chart-line me-2"></i> Reports & Analytics
    </a>
</li>


        </ul>
    </div>
</li>

<li class="nav-item">
  <a class="nav-link active" href="#"
     data-bs-toggle="offcanvas"
     data-bs-target="#calendarOffcanvas">
    <i class="fa fa-calendar-alt text-white"></i> Calendar
  </a>
</li>






                <!-- Help -->
                <li class="nav-item mt-2">
                    <a class="nav-link" href="#"><i class="fa fa-life-ring text-white"></i> Help & Support</a>
                </li>

              <li class="nav-item mt-2">
              <form method="POST" action="<?php echo e(route('logout')); ?>">
                  <?php echo csrf_field(); ?>
                  <button type="submit" class="btn nav-link text-danger d-flex align-items-center p-0 border-0 bg-transparent">
                      <i class="fa fa-sign-out-alt me-2"></i> Logout
                  </button>
              </form>
          </li>






<div class="offcanvas offcanvas-top off-categories" id="applicationsPanel"
     data-bs-scroll="true" data-bs-backdrop="true">

    <div class="offcanvas-header" style="background-color: rgb(113, 16, 62); color: white;">
        <h5 class="offcanvas-title text-white">
            <i class="fa fa-folder-open me-2 text-white"></i> Application Categories
        </h5>

        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body" style="background-color: rgb(113, 16, 62);">
        <div class="row g-3">

            <!-- CATEGORY CARD TEMPLATE -->
            <!-- Support Workers -->
            <div class="col-12 col-md-6 col-lg-4">
                <div class="app-card" onclick="swOpenApplications('Support Workers')">
                    <span class="app-card-badge" id="badge-Support-Workers"></span>
                    <i class="fa fa-user-nurse fa-2x mb-2"></i>
                    <h6 class="fw-bold text-uppercase">Support Workers</h6>
                    <p class="small mb-0">Applications for support worker roles</p>
                </div>
            </div>

            <!-- Senior Support Workers -->
            <div class="col-12 col-md-6 col-lg-4">
                <div class="app-card" onclick="swOpenApplications('Senior Support Workers')">
                    <span class="app-card-badge" id="badge-Senior-Support-Workers"></span>
                    <i class="fa fa-user-shield fa-2x mb-2"></i>
                    <h6 class="fw-bold text-uppercase">Senior Support Workers</h6>
                    <p class="small mb-0">Experienced support professionals</p>
                </div>
            </div>

            <!-- Service Managers -->
            <div class="col-12 col-md-6 col-lg-4">
                <div class="app-card" onclick="swOpenApplications('Service Managers')">
                    <span class="app-card-badge" id="badge-Service-Managers"></span>
                    <i class="fa fa-briefcase fa-2x mb-2"></i>
                    <h6 class="fw-bold text-uppercase">Service Managers</h6>
                    <p class="small mb-0">Applications for service management roles</p>
                </div>
            </div>

            <!-- Operations Managers -->
            <div class="col-12 col-md-6 col-lg-4">
                <div class="app-card" onclick="swOpenApplications('Operations Managers')">
                    <span class="app-card-badge" id="badge-Operations-Managers"></span>
                    <i class="fa fa-cogs fa-2x mb-2"></i>
                    <h6 class="fw-bold text-uppercase">Operations Managers</h6>
                    <p class="small mb-0">Applications for operational leadership</p>
                </div>
            </div>

            <!-- Social Workers -->
            <div class="col-12 col-md-6 col-lg-4">
                <div class="app-card" onclick="swOpenApplications('Social Workers')">
                    <span class="app-card-badge" id="badge-Social-Workers"></span>
                    <i class="fa fa-hands-helping fa-2x mb-2"></i>
                    <h6 class="fw-bold text-uppercase">Social Workers</h6>
                    <p class="small mb-0">Applications for social work roles</p>
                </div>
            </div>

            <!-- Administration Officers -->
            <div class="col-12 col-md-6 col-lg-4">
                <div class="app-card" onclick="swOpenApplications('Administration Officers')">
                    <span class="app-card-badge" id="badge-Administration-Officers"></span>
                    <i class="fa fa-clipboard-list fa-2x mb-2"></i>
                    <h6 class="fw-bold text-uppercase">Administration Officers</h6>
                    <p class="small mb-0">Applications for admin roles</p>
                </div>
            </div>

            <!-- Nurses -->
            <div class="col-12 col-md-6 col-lg-4">
                <div class="app-card" onclick="swOpenApplications('Nurses')">
                    <span class="app-card-badge" id="badge-Nurses"></span>
                    <i class="fa fa-user-md fa-2x mb-2"></i>
                    <h6 class="fw-bold text-uppercase">Nurses</h6>
                    <p class="small mb-0">Applications for nursing roles</p>
                </div>
            </div>

            <!-- Team Leaders -->
            <div class="col-12 col-md-6 col-lg-4">
                <div class="app-card" onclick="swOpenApplications('Team Leaders')">
                    <span class="app-card-badge" id="badge-Team-Leaders"></span>
                    <i class="fa fa-users-cog fa-2x mb-2"></i>
                    <h6 class="fw-bold text-uppercase">Team Leaders</h6>
                    <p class="small mb-0">Applications for leadership roles</p>
                </div>
            </div>

            <!-- Business Managers -->
            <div class="col-12 col-md-6 col-lg-4">
                <div class="app-card" onclick="swOpenApplications('Business Managers')">
                    <span class="app-card-badge" id="badge-Business-Managers"></span>
                    <i class="fa fa-chart-line fa-2x mb-2"></i>
                    <h6 class="fw-bold text-uppercase">Business Managers</h6>
                    <p class="small mb-0">Applications for business management</p>
                </div>
            </div>

        </div>
    </div>
</div>
                <!-- Logout -->
              
            </ul>
        </nav>

        <!-- Overlay (mobile only) -->
        <div id="sidebar-overlay" onclick="toggleSidebar()"></div>

    </div>


    

<div class="offcanvas offcanvas-end" tabindex="-1" id="interviewCalendarOffcanvas" aria-labelledby="interviewCalendarLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="interviewCalendarLabel">Interview Calendar</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body p-0">
        <div id="fullInterviewCalendar" style="height: 100vh; padding: 15px;"></div>
    </div>
</div>


    

<div class="offcanvas offcanvas-bottom" tabindex="-1" id="timeSelectOffcanvas" aria-labelledby="timeSelectLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="timeSelectLabel">Choose your Availability</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body">
        <div id="timeSlots" class="list-group"></div>
    </div>
</div>












 




    

  
  <style>
/* Namespace: sw- */

/* Offcanvas width */

.off-categories{
  width: 100% !important;
    max-width: 100vw;
}
.sw-offcanvas {
    width: 100% !important;
    max-width: 100vw;
}

/* Header styling */
.sw-offcanvas-header {
    background: rgb(113,16,62);
    color: white;
    padding: 20px;
}

.sw-offcanvas-title {
    color: white;
    font-weight: 700;
    font-size: 20px;
}

.sw-offcanvas-close {
    filter: brightness(0) invert(1);
}

/* Body */
.sw-offcanvas-body {
    padding: 20px;
}

/* Table styling */
.sw-table {
    border-radius: 10px;
    overflow: hidden;
}

.sw-table thead {
    background: rgb(113,16,62);
    color: white;
}

.sw-table tbody tr {
    transition: 0.2s ease;
}

.sw-table tbody tr:hover {
    background: rgba(113,16,62,0.1);
    cursor: pointer;
}
</style>


<style>
/* ================================
   OFFCANVAS WRAPPER
================================ */
.sw-details-offcanvas {
    width: 100% !important;
    max-width: 100vw;
    background: #ffffff;
    border-left: 0;
    box-shadow: -8px 0 40px rgba(0,0,0,0.18);
    animation: fadeSlideIn 0.35s ease;
}

/* ================================
   HEADER
================================ */
.sw-details-header {
    background: linear-gradient(135deg, rgb(113,16,62), rgb(150,30,85));
    color: white;
    padding: 28px 35px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 1px solid rgba(255,255,255,0.15);
}

.sw-details-title {
    font-size: 28px;
    font-weight: 800;
    margin: 0;
    letter-spacing: 0.5px;
}

.sw-details-close {
    filter: brightness(0) invert(1);
    opacity: 0.9;
    transition: 0.2s ease;
}

.sw-details-close:hover {
    opacity: 1;
    transform: scale(1.1);
}

/* ================================
   BODY
================================ */
.sw-details-body {
    padding: 40px;
    overflow-y: auto;
    max-height: calc(100vh - 100px);
    background: #f8f6f9;
}

/* ================================
   SECTION TITLES
================================ */
.sw-section-title {
    font-size: 21px;
    font-weight: 800;
    color: rgb(113,16,62);
    margin-top: 35px;
    margin-bottom: 15px;
    letter-spacing: 0.3px;
}

/* ================================
   VIEW RESUME / COVER LETTER BUTTONS
================================ */
.sw-viewer-btn {
    border-radius: 40px;
    padding: 12px 26px;
    font-size: 15px;
    font-weight: 700;
    transition: 0.25s ease;
    cursor: pointer;
}

.sw-viewer-btn-primary {
    background: rgb(113,16,62);
    color: white;
    border: none;
    box-shadow: 0 4px 14px rgba(113,16,62,0.35);
}

.sw-viewer-btn-primary:hover {
    background: rgb(130,20,70);
    transform: translateY(-2px);
    box-shadow: 0 6px 18px rgba(113,16,62,0.45);
}

.sw-viewer-btn-secondary {
    background: #f1f1f1;
    color: #333;
    border: none;
    box-shadow: 0 3px 10px rgba(0,0,0,0.08);
}

.sw-viewer-btn-secondary:hover {
    background: #e4e4e4;
    transform: translateY(-2px);
    box-shadow: 0 5px 14px rgba(0,0,0,0.12);
}

/* ================================
   PDF VIEWERS
================================ */
.sw-pdf-viewer {
    width: 100%;
    height: 550px;
    border-radius: 14px;
    border: 1px solid #ddd;
    display: none;
    margin-top: 25px;
    box-shadow: 0 6px 25px rgba(0,0,0,0.12);
}

/* ================================
   TWO-COLUMN GRID FOR ANSWERS
================================ */
.sw-answers-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 18px 22px;
    margin-top: 15px;
}

@media (max-width: 768px) {
    .sw-answers-grid {
        grid-template-columns: 1fr;
    }
}

/* ================================
   ANSWER ITEMS
================================ */
.sw-answer-item {
    padding: 16px 20px;
    border-radius: 12px;
    background: #ffffff;
    box-shadow: 0 3px 14px rgba(0,0,0,0.06);
    border-left: 4px solid rgba(113,16,62,0.3);
    transition: 0.25s ease;
}

.sw-answer-item:hover {
    transform: translateX(4px);
    box-shadow: 0 6px 20px rgba(0,0,0,0.08);
}

/* ================================
   APPLICANT CARD
================================ */
.sw-applicant-card {
    display: flex;
    align-items: center;
    gap: 28px;
    padding: 32px;
    background: linear-gradient(135deg, #ffffff 0%, #fdf9fc 100%);
    border-radius: 20px;
    box-shadow: 0 10px 35px rgba(0,0,0,0.08);
    border: 1px solid rgba(113,16,62,0.12);
    margin-bottom: 30px;
    animation: fadeInUp 0.45s ease;
}

.sw-applicant-name {
    font-size: 30px;
    font-weight: 900;
    margin: 0;
    color: rgb(113,16,62);
    letter-spacing: 0.4px;
}

.sw-applicant-meta {
    margin-top: 10px;
    font-size: 15px;
    line-height: 1.7;
    color: #555;
}

.sw-status-badge {
    background: rgba(113,16,62,0.12);
    color: rgb(113,16,62);
    padding: 5px 14px;
    border-radius: 25px;
    font-weight: 700;
    font-size: 13px;
    letter-spacing: 0.3px;
}

/* ================================
   ANIMATIONS
================================ */
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(12px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes fadeSlideIn {
    from { opacity: 0; transform: translateX(40px); }
    to { opacity: 1; transform: translateX(0); }
}
/* ================================
   TABLE WRAPPER
================================ */
.sw-table-wrapper {
    background: #ffffff;
    padding: 20px;
    border-radius: 16px;
    box-shadow: 0 8px 30px rgba(0,0,0,0.08);
    border: 1px solid rgba(113,16,62,0.12);
    animation: fadeInUp 0.4s ease;
}

/* ================================
   TABLE BASE
================================ */
.sw-table {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0 10px;
}

.sw-table thead tr th {
    background: #faf7fb;
    padding: 14px 18px;
    font-weight: 800;
    color: rgb(113,16,62);
    border-bottom: 2px solid rgba(113,16,62,0.15);
    font-size: 15px;
}

.sw-table tbody tr {
    background: #ffffff;
    box-shadow: 0 4px 18px rgba(0,0,0,0.06);
    border-radius: 12px;
    transition: 0.25s ease;
    cursor: pointer;
}

.sw-table tbody tr:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.10);
}

.sw-table tbody td {
    padding: 16px 18px;
    font-size: 15px;
    color: #444;
    border-top: 1px solid #f2f2f2;
}

/* ================================
   APPLICANT CELL WITH AVATAR
================================ */
.sw-applicant-cell {
    display: flex;
    align-items: center;
    gap: 12px;
}

.sw-avatar {
    width: 38px;
    height: 38px;
    border-radius: 50%;
    background: rgb(113,16,62);
    color: white;
    font-weight: 800;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 12px rgba(113,16,62,0.35);
}

/* ================================
   STATUS BADGES
================================ */
.sw-status-badge {
    padding: 6px 14px;
    border-radius: 20px;
    font-size: 13px;
    font-weight: 700;
    text-transform: capitalize;
}

.sw-status-pending {
    background: #fff3cd;
    color: #856404;
}

.sw-status-approved {
    background: #d4edda;
    color: #155724;
}

.sw-status-rejected {
    background: #f8d7da;
    color: #721c24;
}

/* ================================
   ANIMATION
================================ */
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.sw-filter-bar {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 20px;
    background: #faf7fb;
    padding: 12px 16px;
    border-radius: 12px;
    border: 1px solid rgba(113,16,62,0.12);
}

.sw-filter-label {
    font-weight: 700;
    color: rgb(113,16,62);
}

.sw-filter-select {
    padding: 8px 14px;
    border-radius: 8px;
    border: 1px solid #ccc;
    font-size: 14px;
    outline: none;
    transition: 0.2s ease;
}

.sw-filter-select:focus {
    border-color: rgb(113,16,62);
    box-shadow: 0 0 0 3px rgba(113,16,62,0.15);
}


/* SUMMARY BAR */
.sw-summary-bar {
    display: flex;
    justify-content: space-between;
    gap: 12px;
    padding: 15px 18px;
    background: #faf7fb;
    border-bottom: 1px solid rgba(113,16,62,0.12);
}

/* SUMMARY CARD BASE */
.sw-summary-item {
    flex: 1;
    text-align: center;
    padding: 14px 10px;
    border-radius: 14px;
    color: white;
    box-shadow: 0 4px 14px rgba(0,0,0,0.08);
    transition: 0.25s ease;
    cursor: pointer;
}

.sw-summary-item:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 22px rgba(0,0,0,0.12);
}

/* ICON */
.sw-summary-icon {
    font-size: 22px;
    margin-bottom: 6px;
    opacity: 0.9;
}

/* COUNT */
.sw-summary-count {
    font-size: 24px;
    font-weight: 900;
    margin-top: 4px;
}

/* LABEL */
.sw-summary-label {
    font-size: 13px;
    font-weight: 600;
    opacity: 0.9;
}

/* COLOURS */
/* SUMMARY BAR LAYOUT */
#sw-summary-bar {
    display: flex;
    gap: 12px;
    padding: 15px 20px;
    background: #ffffff;
    overflow-x: auto;
}

/* SUMMARY ITEM (WHITE CARD) */
.sw-summary-item {
    background: #ffffff;
    border: 1px solid #eee;
    border-radius: 10px;
    padding: 14px 18px;
    min-width: 140px;
    text-align: center;
    cursor: pointer;
    transition: all 0.25s ease;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
}

/* ICON */
.sw-summary-item i {
    font-size: 1.4rem;
    color: rgb(113, 16, 62);
    transition: color 0.25s ease;
}

/* COUNT */
.sw-summary-count {
    font-size: 1.3rem;
    font-weight: 700;
    margin-top: 4px;
    color: #333;
}

/* LABEL */
.sw-summary-label {
    font-size: 0.8rem;
    color: #666;
    margin-top: 2px;
}

/* HOVER EFFECT */
.sw-summary-item:hover {
    border-color: rgb(113, 16, 62);
    box-shadow: 0 4px 14px rgba(113, 16, 62, 0.18);
    transform: translateY(-3px);
}

.sw-summary-item:hover i,
.sw-summary-item:hover .sw-summary-label {
    color: rgb(113, 16, 62);
}

/* BUTTON GROUP LAYOUT */
.sw-button-group {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

/* BASE BUTTON STYLE */
.sw-viewer-btn {
    background: #ffffff;
    border: 1px solid #ddd;
    padding: 12px 16px;
    border-radius: 10px;
    font-weight: 600;
    font-size: 0.95rem;
    text-align: center;
    cursor: pointer;
    transition: all 0.25s ease;
    color: #333;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
}

/* HOVER EFFECT */
.sw-viewer-btn:hover {
    border-color: rgb(113, 16, 62);
    color: rgb(113, 16, 62);
    box-shadow: 0 4px 14px rgba(113, 16, 62, 0.18);
    transform: translateY(-2px);
}

/* PRIMARY ACTION (Resume) */
.sw-viewer-btn-primary {}

/* SECONDARY ACTION (Cover Letter) */
.sw-viewer-btn-secondary {}

/* GREEN ACTION */
.sw-btn-green {
    border-left: 4px solid #28a745;
}
.sw-btn-green:hover {
    color: #28a745;
    border-color: #28a745;
    box-shadow: 0 4px 14px rgba(40, 167, 69, 0.25);
}

/* RED ACTION */
.sw-btn-red {
    border-left: 4px solid #dc3545;
}
.sw-btn-red:hover {
    color: #dc3545;
    border-color: #dc3545;
    box-shadow: 0 4px 14px rgba(220, 53, 69, 0.25);
}

/* BLUE ACTION */
.sw-btn-blue {
    border-left: 4px solid #0d6efd;
}
.sw-btn-blue:hover {
    color: #0d6efd;
    border-color: #0d6efd;
    box-shadow: 0 4px 14px rgba(13, 110, 253, 0.25);
}

/* ORANGE ACTION */
.sw-btn-orange {
    border-left: 4px solid #fd7e14;
}
.sw-btn-orange:hover {
    color: #fd7e14;
    border-color: #fd7e14;
    box-shadow: 0 4px 14px rgba(253, 126, 20, 0.25);
}

.sw-button-group {
    display: grid;
    gap: 10px;
}

/* Mobile: 1 column */
.sw-button-group {
    grid-template-columns: 1fr;
}

/* Tablet: 2 columns */
@media (min-width: 576px) {
    .sw-button-group {
        grid-template-columns: 1fr 1fr;
    }
}

/* Desktop: 3 columns if you want */
@media (min-width: 992px) {
    .sw-button-group {
        grid-template-columns: 1fr 1fr 1fr;
    }
}


/* sweetalert */
.sw-swal-popup {
    border-radius: 18px !important;
    padding: 25px !important;
}

.sw-swal-confirm {
    background-color: #dc3545 !important;
    color: #fff !important;
    border-radius: 10px !important;
    padding: 10px 20px !important;
    font-weight: 600 !important;
}

.sw-swal-cancel {
    background-color: #ccc !important;
    color: #333 !important;
    border-radius: 10px !important;
    padding: 10px 20px !important;
    font-weight: 600 !important;
}


/* Shared header styling */
.offcanvas-header {
    background: rgb(113, 16, 62);
    color: white;
}

.offcanvas-header .btn-close {
    filter: brightness(0) invert(1); /* white close button */
}

/* Right-side offcanvas (interview calendar) */
#interviewCalendarOffcanvas {
    width: 600px !important; /* increase width */
    max-width: 90vw; /* responsive fallback */
}

/* Bottom offcanvas (time selection) */
#timeSelectOffcanvas {
    height: 60vh !important; /* increase height */
    max-height: 90vh; /* responsive fallback */
}

.swal-no-card {
    background: transparent !important;
    box-shadow: none !important;
    padding: 0 !important;
    width: auto !important;
}



/* Calendaer Styles */
  :root {
    --brand: rgb(113,16,62);
    --selection-bg: rgba(0,120,215,0.2);
    --selection-border: #0078d7;
  }
  * { box-sizing: border-box; }
  body {
    font-family: "Segoe UI", system-ui, sans-serif;
  }
  .calendar-shell {
    display: flex;
    flex-direction: column;
    height: calc(100vh - 80px);
    background: #fff;
    border-radius: 8px;
    box-shadow: 0 0 0 1px #e0e0e0;
    overflow: hidden;
  }
  .toolbar {
    padding: 6px 16px;
    border-bottom: 1px solid #ddd;
    background: #fafafa;
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 0.9rem;
  }
  .toolbar .btn-outline-secondary.active {
    background: var(--brand);
    color: #fff;
    border-color: var(--brand);
  }
  .view-container {
    flex: 1;
    display: flex;
    flex-direction: column;
    overflow: hidden;
  }
  .week-header {
    display: flex;
    border-bottom: 1px solid #ddd;
    background: #f8f8f8;
    font-size: 0.85rem;
  }
  .week-header-time { width: 70px; }
  .week-header-day {
    flex: 1;
    text-align: center;
    padding: 4px 0;
  }
  .week-header-day .day-name { font-weight: 600; }
  .week-header-day .day-date {
    font-size: 0.8rem;
    color: #555;
  }
  .week-header-day.today {
    background: #e6f2ff;
    border-bottom: 2px solid #0078d7;
  }
  .grid {
    flex: 1;
    overflow-y: auto;
    position: relative;
  }
  .row-slot {
    display: flex;
    height: 40px;
    border-bottom: 1px solid #eee;
    position: relative;
  }
  .row-time {
    width: 70px;
    font-size: 0.7rem;
    color: #666;
    text-align: right;
    padding-right: 4px;
    padding-top: 4px;
    background: #fafafa;
  }
  .row-cells { flex: 1; display: flex; }
  .cell {
    flex: 1;
    border-left: 1px solid #eee;
    position: relative;
    cursor: pointer;
  }
  .cell:hover { background: rgba(113,16,62,0.04); }
  .event-block {
    position: absolute;
    left: 3px;
    right: 3px;
    background: rgba(113,16,62,0.15);
    border-left: 3px solid var(--brand);
    border-radius: 3px;
    font-size: 0.7rem;
    padding: 2px 4px;
    overflow: hidden;
    box-sizing: border-box;
    box-shadow: 0 1px 2px rgba(0,0,0,0.15);
  }
  .event-title {
    font-weight: 600;
    white-space: nowrap;
    text-overflow: ellipsis;
    overflow: hidden;
  }
  .event-resize-handle {
    position: absolute;
    left: 0;
    right: 0;
    bottom: 0;
    height: 4px;
    cursor: ns-resize;
    background: rgba(113,16,62,0.5);
  }
  .event-dragging {
    opacity: 0.7;
    box-shadow: 0 0 0 1px var(--brand);
  }
  .selection-block {
    position: absolute;
    background: var(--selection-bg);
    border-left: 3px solid var(--selection-border);
    border-radius: 3px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.25);
    pointer-events: none;
    opacity: 0;
    transition: opacity 0.12s ease-out;
  }
  .selection-block.visible { opacity: 1; }

  .day-view-header {
    border-bottom: 1px solid #ddd;
    padding: 4px 12px;
    background: #f8f8f8;
    font-weight: 600;
  }

  .month-grid {
    flex: 1;
    display: grid;
    grid-template-columns: repeat(7, 1fr);
    grid-auto-rows: minmax(90px, 1fr);
    border-top: 1px solid #ddd;
    border-left: 1px solid #ddd;
    font-size: 0.75rem;
    overflow-y: auto;
  }
  .month-cell {
    border-right: 1px solid #ddd;
    border-bottom: 1px solid #ddd;
    padding: 2px 4px;
    position: relative;
    cursor: pointer;
  }
  .month-cell-header {
    font-weight: 600;
    font-size: 0.75rem;
  }
  .month-cell-header.muted { color: #aaa; }
  .month-events { margin-top: 2px; }
  .month-event {
    font-size: 0.7rem;
    padding: 1px 3px;
    border-radius: 2px;
    background: rgba(113,16,62,0.12);
    margin-bottom: 1px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }
  .month-more {
    font-size: 0.7rem;
    color: #0078d7;
    cursor: pointer;
  }

  .recipients-container {
    border: 1px solid #ced4da;
    border-radius: 4px;
    padding: 4px;
    display: flex;
    flex-wrap: wrap;
    gap: 4px;
    cursor: text;
    min-height: 38px;
  }
  .recipient-chip {
    background: #e6e6e6;
    border-radius: 16px;
    padding: 2px 8px;
    font-size: 0.8rem;
    display: inline-flex;
    align-items: center;
    gap: 4px;
  }
  .recipient-chip button {
    border: none;
    background: transparent;
    font-size: 0.8rem;
    line-height: 1;
    cursor: pointer;
  }
  .recipients-input {
    border: none;
    outline: none;
    flex: 1;
    min-width: 120px;
    font-size: 0.85rem;
  }

  .ai-suggestion {
    font-size: 0.8rem;
    color: #555;
    margin-top: 4px;
    padding: 4px 6px;
    border-radius: 4px;
    background: #f3f6ff;
    border-left: 3px solid #0078d7;
    display: none;
  }
  .ai-suggestion span {
    font-weight: 600;
    margin-right: 4px;
  }
  .ai-suggestion button {
    border: none;
    background: transparent;
    color: #0078d7;
    font-size: 0.8rem;
    cursor: pointer;
    padding: 0;
    margin-left: 6px;
  }

  .modal-header {
    background: var(--brand);
    color: #fff;
  }
  .modal-backdrop {
    opacity: 0.35 !important; /* normal brightness */
}

.offcanvas-backdrop {
    opacity: 0 !important; /* remove the offcanvas dimming */
}
.modal {
    z-index: 9999 !important;
}

.modal-backdrop {
    z-index: 9998 !important;
}


  @media print {
    .toolbar, .modal, .offcanvas { display: none !important; }
    .calendar-shell {
      box-shadow: none;
      border-radius: 0;
      height: auto;
    }
  }

  .event-editor {
  width: 900px !important;
  max-width: 100%;
}

.event-header {
  background: var(--brand);
  color: white;
}

.event-body {
  display: flex;
  flex-direction: column;
  height: calc(100vh - 70px);
}

.event-form {
  display: flex;
  gap: 24px;
  flex: 1;
}

.event-left {
  flex: 1;
}

.event-right {
  width: 260px;
}

/* Inputs */
.event-input,
.event-textarea {
  border-radius: 6px;
  border: 1px solid #ccc;
}

/* BBCode Toolbar */
.bbcode-toolbar {
  display: flex;
  gap: 6px;
}

.bb-btn {
  border: 1px solid #ccc;
  background: #f8f8f8;
  padding: 4px 8px;
  border-radius: 4px;
  cursor: pointer;
}

.bb-btn:hover {
  background: #e8e8e8;
}

/* Duration Buttons */
.duration-buttons .btn {
  margin-right: 6px;
}

/* Timeline */
/* Timeline container */
.time-timeline {
  position: relative;
  height: 520px;
  border-radius: 12px;
  background: linear-gradient(180deg, #ffffff 0%, #f7f7f7 100%);
  border: 1px solid #e3e3e3;
  box-shadow: inset 0 0 6px rgba(0,0,0,0.05);
  overflow: hidden;
  padding-left: 70px;
}

/* Hour rows */
.time-slot {
  position: relative;
  height: 40px;
  display: flex;
  align-items: center;
  font-size: 12px;
  color: #777;
}

.time-slot-label {
  position: absolute;
  left: -65px;
  width: 60px;
  text-align: right;
  font-weight: 600;
  color: #555;
}

/* Horizontal lines */
.time-slot::after {
  content: "";
  position: absolute;
  left: 0;
  right: 0;
  height: 1px;
  background: #eaeaea;
}

/* Draggable block */
.time-block {
  position: absolute;
  left: 10px;
  right: 10px;
  background: var(--brand);
  border-radius: 10px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.15);
  cursor: grab;
  transition: box-shadow 0.15s ease;
}

.time-block:active {
  cursor: grabbing;
  box-shadow: 0 6px 16px rgba(0,0,0,0.25);
}

/* Resize handles */
.time-block-handle {
  position: absolute;
  left: 0;
  right: 0;
  height: 10px;
  cursor: ns-resize;
}

.top-handle {
  top: -5px;
  background: rgba(255,255,255,0.8);
  border-radius: 50%;
  width: 14px;
  height: 14px;
  margin: auto;
  box-shadow: 0 0 6px rgba(0,0,0,0.2);
}

.bottom-handle {
  bottom: -5px;
  background: rgba(255,255,255,0.8);
  border-radius: 50%;
  width: 14px;
  height: 14px;
  margin: auto;
  box-shadow: 0 0 6px rgba(0,0,0,0.2);
}

/* Time summary */
.time-summary {
  font-size: 14px;
  font-weight: 600;
  color: #444;
  padding-top: 8px;
}


.top-handle { top: -3px; }
.bottom-handle { bottom: -3px; }

.event-footer {
  display: flex;
  justify-content: flex-end;
  gap: 12px;
  padding-top: 12px;
  border-top: 1px solid #eee;
}

.event-editor-area {
  border: 1px solid #ccc;
  border-radius: 6px;
  padding: 10px;
  min-height: 180px;
  background: #fff;
  outline: none;
  white-space: pre-wrap;
}
#eventOffcanvas.offcanvas-end {
  width: 100% !important;
  max-width: 100% !important;
}
.time-timeline {
  position: relative;
  height: 500px;
  border: 1px solid #ddd;
  border-radius: 8px;
  background: #fafafa;
  overflow: hidden;
  padding-top: 4px;
}

.time-block {
  position: absolute;
  left: 10px;
  right: 10px;
  height: 40px;
  background: var(--brand);
  border-radius: 6px;
  cursor: move;
}

.time-block-handle {
  position: absolute;
  left: 0;
  right: 0;
  height: 6px;
  cursor: ns-resize;
}

.top-handle { top: -3px; }
.bottom-handle { bottom: -3px; }

.event-editor-area {
  min-height: 400px;
}

.event-footer {
  display: grid;
  grid-template-columns: repeat(3, 1fr); /* 3 equal columns */
  gap: 12px; /* spacing between buttons */
  padding: 16px;
}


/* Shared button style */
.footer-btn {
  padding: 14px 0;
  font-size: 16px;
  font-weight: 600;
  border-radius: 8px;
  border: none;
  transition: all 0.2s ease;
}

/* Cancel button */
.cancel-btn {
  background: #e6e6e6;
  color: #333;
}

.cancel-btn:hover {
  background: #d4d4d4;
}

/* Save button (brand colour) */
.save-btn {
  background: rgb(113,16,62);
  color: white;
}

.save-btn:hover {
  background: rgba(113,16,62,0.85);
}


.time-summary-wrapper {
  margin-top: 16px;
  padding: 14px 18px;
  border-radius: 10px;
  background: rgba(113,16,62,0.08); /* subtle brand tint */
  border: 1px solid rgba(113,16,62,0.15);
  box-shadow: 0 2px 6px rgba(0,0,0,0.05);
}

.time-summary-label {
  font-size: 13px;
  font-weight: 700;
  color: rgb(113,16,62);
  text-transform: uppercase;
  letter-spacing: 0.5px;
  margin-bottom: 4px;
}

.time-summary {
  font-size: 18px;
  font-weight: 600;
  color: #333;
}
/* Overlay */
.event-preview-overlay {
  position: fixed;
  inset: 0;
  background: rgba(0,0,0,0.55);
  display: none;
  align-items: center;
  justify-content: center;
  z-index: 99999;
}

/* Window */
.event-preview-window {
  width: 70%;
  max-width: 900px;
  background: #fff;
  border-radius: 14px;
  padding: 24px;
  box-shadow: 0 10px 30px rgba(0,0,0,0.25);
  animation: fadeInUp 0.25s ease;
}

/* Header */
.event-preview-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  border-bottom: 2px solid rgba(113,16,62,0.2);
  padding-bottom: 10px;
  margin-bottom: 20px;
}

.preview-close {
  background: none;
  border: none;
  font-size: 28px;
  cursor: pointer;
  color: rgb(113,16,62);
}

/* Sections */
.preview-section {
  margin-bottom: 20px;
}

.preview-section label {
  font-size: 13px;
  font-weight: 700;
  color: rgb(113,16,62);
  text-transform: uppercase;
  letter-spacing: 0.5px;
}

#previewDesc {
  border: 1px solid #ddd;
  padding: 12px;
  border-radius: 8px;
  background: #fafafa;
}

/* Animation */
@keyframes fadeInUp {
  from { opacity: 0; transform: translateY(20px); }
  to   { opacity: 1; transform: translateY(0); }
}

/* Preview button styling */
.preview-btn {
  background: rgba(113,16,62,0.15);
  color: rgb(113,16,62);
}

.preview-btn:hover {
  background: rgba(113,16,62,0.25);
}


.recipients-display {
  min-height: 40px;
  padding: 6px;
  border: 1px solid #ddd;
  border-radius: 8px;
  background: #fafafa;
}

.recipient-chip {
  display: inline-block;
  background: rgb(113,16,62);
  color: white;
  padding: 6px 10px;
  border-radius: 20px;
  margin: 4px;
  font-size: 13px;
}

.event-editor-wrapper {
  position: relative;
}

.event-editor-area {
  min-height: 180px;
  padding: 12px;
  border: 1px solid #ccc;
  border-radius: 6px;
}

.insert-template-btn {
  position: absolute;
  top: 6px;
  right: 6px;
  z-index: 10;
  padding: 4px 10px;
  font-size: 12px;
}

.chip-input-wrapper {
  display: flex;
  flex-wrap: wrap;
  align-items: center;
  gap: 6px;
  padding: 6px;
  border: 1px solid #ccc;
  border-radius: 6px;
}

.chip-container {
  display: flex;
  flex-wrap: wrap;
  gap: 6px;
}

.chip-input {
  border: none;
  outline: none;
  flex: 1;
  min-width: 150px;
}

.recipient-chip {
  background: #e8e8e8;
  padding: 4px 8px;
  border-radius: 20px;
  display: inline-flex;
  align-items: center;
  gap: 6px;
}

.recipient-chip button {
  border: none;
  background: transparent;
  font-weight: bold;
  cursor: pointer;
}


/* Modal container styling */
.fancy-modal {
  border-radius: 14px;
  overflow: hidden;
  box-shadow: 0 10px 35px rgba(0,0,0,0.25);
  border: none;
}

/* Header */
.fancy-header {
  background: linear-gradient(135deg, rgb(113,16,62), rgb(150,30,80));
  color: white;
  padding: 18px 24px;
}

/* Search bar wrapper */
.search-wrapper {
  position: relative;
}

.fancy-search {
  padding-left: 40px;
  border-radius: 10px;
  border: 1px solid #ddd;
  height: 42px;
  transition: all 0.2s ease;
}

.fancy-search:focus {
  border-color: rgb(113,16,62);
  box-shadow: 0 0 0 3px rgba(113,16,62,0.15);
}

.search-icon {
  position: absolute;
  top: 50%;
  left: 12px;
  transform: translateY(-50%);
  font-size: 18px;
  color: #777;
}

/* Recipient list area */
.fancy-list {
  max-height: 350px;
  overflow-y: auto;
  padding-right: 6px;
}

.fancy-list::-webkit-scrollbar {
  width: 6px;
}

.fancy-list::-webkit-scrollbar-thumb {
  background: #bbb;
  border-radius: 10px;
}

/* Footer */
.fancy-footer {
  padding: 16px 24px;
  border-top: 1px solid #eee;
}

.fancy-apply {
  padding: 8px 20px;
  border-radius: 8px;
}



</style>






<div class="offcanvas offcanvas-end sw-offcanvas" tabindex="-1" id="sw-offcanvas">

    <!-- HEADER -->
    <div class="offcanvas-header sw-offcanvas-header">
        <h5 class="offcanvas-title sw-offcanvas-title">Applications</h5>

        <button type="button" 
    class="btn-close sw-offcanvas-close"
    onclick="switchToApplicationsPanel()">
</button>

    </div>

    <!-- SUMMARY BAR -->
    <div class="sw-summary-bar" id="sw-summary-bar">
        <!-- JS will populate -->
    </div>

    <!-- FILTER BAR -->
    <div class="sw-filter-bar">
        <label class="sw-filter-label">Filter by Status:</label>

        <select id="sw-status-filter" 
                class="sw-filter-select" 
                onchange="swOpenApplications(window.swSelectedCategory)">
            <option value="">All Applications</option>
            <option value="Pending">Pending Review</option>
            <option value="Shortlisted">Shortlisted</option>
            <option value="Rejected">Rejected</option>
            <option value="Interview Scheduled">Interview Scheduled</option>
        </select>
    </div>

    <!-- BODY -->
    <div class="offcanvas-body sw-offcanvas-body" id="sw-offcanvas-content">
        <p class="text-muted">Loading applications...</p>
    </div>

</div>







<div class="offcanvas offcanvas-end sw-details-offcanvas" tabindex="-1" id="sw-details-offcanvas">
    <div class="sw-details-header">
        <h4 class="sw-details-title">Application Details</h4>
<button type="button" 
        class="btn-close sw-details-close" 
        data-bs-dismiss="offcanvas"
        onclick="swDetailsClosed()">
</button>

    </div>

    <div class="sw-details-body" id="sw-details-content">
        <p class="text-muted">Loading details...</p>
    </div>
</div>




<!-- OFFCANVAS CALENDAR -->
<div class="offcanvas offcanvas-end w-100" tabindex="-1" id="calendarOffcanvas">
  <div class="offcanvas-header">
    <h5 class="offcanvas-title">Calendar</h5>
    <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
  </div>

  <div class="offcanvas-body p-0">
    <div class="calendar-shell">

      <!-- TOOLBAR -->
      <div class="toolbar d-flex justify-content-between align-items-center">
        <div class="d-flex align-items-center gap-2">
          <button class="btn btn-sm btn-outline-success active" id="btnToday">Today</button>
          <button class="btn btn-sm btn-outline-success" id="btnPrev">&lt;</button>
          <button class="btn btn-sm btn-outline-success" id="btnNext">&gt;</button>
          <span id="weekLabel" class="fw-semibold ms-2"></span>
        </div>

        <div class="d-flex align-items-center gap-2">
          <div class="btn-group btn-group-sm" id="viewButtons">
            <button class="btn btn-outline-success" data-view="day">Day</button>
            <button class="btn btn-outline-success active" data-view="week">Week</button>
            <button class="btn btn-outline-success" data-view="month">Month</button>
          </div>

          <button class="btn btn-sm btn-outline-success" id="btnPrint">Print</button>

          <!-- OPEN MODAL -->

          <button class="btn btn-sm text-white" style="background:var(--brand);" 
                data-bs-toggle="offcanvas" data-bs-target="#eventOffcanvas"
                  id="btnNewEvent">
            + New event
          </button>
        </div>
      </div>

      <!-- VIEWS -->
      <div class="view-container">

        <!-- WEEK VIEW -->
        <div class="week-header" id="weekHeader">
          <div class="week-header-time"></div>
        </div>
        <div id="grid" class="grid"></div>

        <!-- DAY VIEW -->
        <div id="dayView" style="display:none; flex:1; overflow:hidden; flex-direction:column;">
          <div class="day-view-header" id="dayViewHeader"></div>
          <div id="dayGrid" class="grid"></div>
        </div>

        <!-- MONTH VIEW -->
        <div id="monthView" style="display:none; flex:1; flex-direction:column;">
          <div class="week-header" id="monthHeader"></div>
          <div id="monthGrid" class="month-grid"></div>
        </div>

      </div>
    </div>
  </div>
</div>



<!-- EVENT OFFCANVAS -->
<div class="offcanvas offcanvas-end w-100 event-editor" tabindex="-1" id="eventOffcanvas">
  <div class="offcanvas-header event-header">
    <h5 class="offcanvas-title">Edit Event</h5>
    <button class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
  </div>

  <div class="offcanvas-body event-body">

    <form id="eventForm" class="event-form">

      <!-- LEFT COLUMN -->
      <div class="event-left">

        <!-- TITLE -->
        <div class="mb-3">
          <label class="form-label fw-semibold">Title</label>
          <input id="evTitle" class="form-control event-input" required>
        </div>

        <!-- RECIPIENTS -->
<!-- TO (Primary Recipients) -->
<div class="mb-3">
  <label class="form-label fw-semibold">To</label>

  <div id="selectedRecipients" class="recipients-display"></div>

  <button type="button" class="btn btn-outline-primary mt-2" id="openRecipientsModal">
    Select Recipients
  </button>
</div>

<div class="mb-3">
  <label class="form-label fw-semibold">CC</label>

  <div id="ccInputWrapper" class="chip-input-wrapper">
    <div id="selectedCC" class="chip-container"></div>
    <input type="text" id="ccInput" class="chip-input" placeholder="Type email and press Enter">
  </div>
</div>

<div class="mb-3">
  <label class="form-label fw-semibold">BCC</label>

  <div id="bccInputWrapper" class="chip-input-wrapper">
    <div id="selectedBCC" class="chip-container"></div>
    <input type="text" id="bccInput" class="chip-input" placeholder="Type email and press Enter">
  </div>
</div>






        <!-- TIME -->
        <div class="row g-2 mb-3">
          <div class="col-md-6">
            <label class="form-label fw-semibold">Start</label>
            <input id="evStart" type="datetime-local" class="form-control event-input">
          </div>
          <div class="col-md-6">
            <label class="form-label fw-semibold">End</label>
            <input id="evEnd" type="datetime-local" class="form-control event-input">
          </div>
        </div>


 


        <!-- DESCRIPTION -->
        <div class="mb-3">
     
         <label class="form-label fw-semibold">Description</label>
         
          <!-- BBCode Toolbar -->
        <div class="bbcode-toolbar mb-1">
  <button type="button" class="bb-btn" data-cmd="bold"><b>B</b></button>
  <button type="button" class="bb-btn" data-cmd="italic"><i>I</i></button>
  <button type="button" class="bb-btn" data-cmd="underline"><u>U</u></button>
  <button type="button" class="bb-btn" data-cmd="insertUnorderedList">List</button>
  <button type="button" class="bb-btn" data-cmd="createLink">Link</button>
</div>

   

<div id="evDescWrapper" class="event-editor-wrapper">
  <div id="evDesc" class="event-editor-area" contenteditable="true"></div>

  <button type="button" id="insertTemplate" class="footer-btn save-btn" style="position:absolute; top:8px; right:8px; font-size:12px; padding:6px 10px;">
    Use Template
  </button>
</div>




          <div class="ai-suggestion" id="aiSuggestion">
            <span>AI suggestion:</span>
            <span id="aiSuggestionText"></span>
            <button type="button" id="btnUseSuggestion">Use</button>
          </div>
        </div>

      </div>

      <!-- RIGHT COLUMN (TIMELINE) -->
      <div class="event-right">
        <label class="form-label fw-semibold">Time Selector</label>

        <div id="timeTimeline" class="time-timeline">
          <div id="timeBlock" class="time-block">
            <div class="time-block-handle top-handle"></div>
            <div class="time-block-handle bottom-handle"></div>
          </div>
        </div>

   <div class="time-summary-wrapper">
  <div class="time-summary-label">Your event will run from:</div>
  <div class="time-summary" id="timeSummary"></div>
</div>

      </div>

    </form>

    <!-- FOOTER -->
<div class="event-footer">
  <button class="footer-btn cancel-btn" data-bs-dismiss="offcanvas">Cancel</button>
  <button class="footer-btn preview-btn" id="previewEvent">Preview</button>
  <button class="footer-btn save-btn" id="saveEvent">Send Event Emails</button>
</div>


  </div>
</div>




<div class="modal fade" id="previewModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header" style="background: rgb(113,16,62); color: white;">
        <h5 class="modal-title">Event Preview</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">

        <h3 id="previewTitle" class="mb-3"></h3>

        <div class="mb-3">
          <label class="fw-bold text-uppercase small" style="color: rgb(113,16,62);">Recipients</label>
          <div id="previewRecipients"></div>
        </div>

        <div class="mb-3">
          <label class="fw-bold text-uppercase small" style="color: rgb(113,16,62);">Time Selected</label>
          <div id="previewTime" class="fs-5 fw-semibold"></div>
        </div>

        <div class="mb-3">
          <label class="fw-bold text-uppercase small" style="color: rgb(113,16,62);">Description</label>
          <div id="previewDesc" class="p-3 rounded" style="background:#fafafa; border:1px solid #ddd;"></div>
        </div>

      </div>

      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>







<!-- Modal: Select Recipients -->
<div class="modal fade" id="recipientsModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content fancy-modal">

      <div class="modal-header fancy-header">
        <h5 class="modal-title">Select Recipients</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">

        <div class="search-wrapper mb-3">
          <input type="text" id="recipientSearch" class="form-control fancy-search" placeholder="Search recipients...">
          <i class="bi bi-search search-icon"></i>
        </div>
        <div class="d-flex justify-content-between align-items-center mb-2">
            <div>
                <input type="checkbox" id="checkAllRecipients" class="form-check-input me-2">
                <label for="checkAllRecipients" class="form-check-label">Select All</label>
            </div>

            <div class="fw-semibold">
                Selected Recipeints: <span id="recipientCount">0</span>
            </div>
            </div>


        <div id="recipientsList" class="py-2 fancy-list">
          <!-- AJAX-loaded checkboxes go here -->
        </div>

      </div>

      <div class="modal-footer fancy-footer">
        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary fancy-apply" id="applyRecipients">Add to Mailing List</button>
      </div>

    </div>
  </div>
</div>































<script>



function swCloseAllOffcanvases() {
    document.querySelectorAll('.offcanvas.show').forEach(el => {
        bootstrap.Offcanvas.getInstance(el)?.hide();
    });
}




function swOpenApplications(category = null) {

    swCloseAllOffcanvases();

    const offcanvasEl = document.getElementById('sw-offcanvas');
    const canvas = bootstrap.Offcanvas.getOrCreateInstance(offcanvasEl);
    canvas.show();

    // Save selected category globally
    window.swSelectedCategory = category;

    // Update title dynamically
    const titleEl = document.querySelector(".sw-offcanvas-title");
    titleEl.textContent = category ? `${category} Applications` : "All Applications";

    const container = document.getElementById("sw-offcanvas-content");
    container.innerHTML = `<p class="text-muted">Loading applications...</p>`;

    // Get selected status filter
    const filter = document.getElementById("sw-status-filter")?.value || "";

fetch(`/swApplications?category=${category}`)

        .then(res => res.json())
        .then(data => {

            //  Filter by CATEGORY first
            if (category) {
                data = data.filter(app => app.job_category === category);
            }
            console.log(category);
            console.log(app.job_job_category);
            

            //  Build summary counts AFTER category filter
            const summary = {
                all: data.length,
                pending: data.filter(a => a.status === "Pending").length,
                shortlisted: data.filter(a => a.status === "Shortlisted").length,
                rejected: data.filter(a => a.status === "Rejected").length,
                interview: data.filter(a => a.status === "Interview Scheduled").length,
            };

            // Render summary bar
            document.getElementById("sw-summary-bar").innerHTML = `
                <div class="sw-summary-item sw-summary-all" onclick="swSetFilter('')">
                    <i class="fas fa-users sw-summary-icon"></i>
                    <div class="sw-summary-count">${summary.all}</div>
                    <div class="sw-summary-label">All Applications</div>
                </div>

                <div class="sw-summary-item sw-summary-pending" onclick="swSetFilter('Pending')">
                    <i class="fas fa-hourglass-half sw-summary-icon"></i>
                    <div class="sw-summary-count">${summary.pending}</div>
                    <div class="sw-summary-label">Pending</div>
                </div>

                <div class="sw-summary-item sw-summary-shortlisted" onclick="swSetFilter('Shortlisted')">
                    <i class="fas fa-star sw-summary-icon"></i>
                    <div class="sw-summary-count">${summary.shortlisted}</div>
                    <div class="sw-summary-label">Shortlisted</div>
                </div>

                <div class="sw-summary-item sw-summary-rejected" onclick="swSetFilter('Rejected')">
                    <i class="fas fa-times-circle sw-summary-icon"></i>
                    <div class="sw-summary-count">${summary.rejected}</div>
                    <div class="sw-summary-label">Rejected</div>
                </div>

                <div class="sw-summary-item sw-summary-interview" onclick="swSetFilter('Interview Scheduled')">
                    <i class="fas fa-calendar-check sw-summary-icon"></i>
                    <div class="sw-summary-count">${summary.interview}</div>
                    <div class="sw-summary-label">Interview</div>
                </div>
            `;

            // Apply STATUS filter AFTER category filter
            let filtered = data;
            if (filter) {
                filtered = filtered.filter(app => app.status === filter);
            }

            if (!filtered.length) {
                container.innerHTML = `<p class="text-muted">No applications found.</p>`;
                return;
            }

            // Render table
            let html = `
                <div class="sw-table-wrapper">
                    <table class="sw-table">
                        <thead>
                            <tr>
                              <th>Job ID</th>
                                <th>Candidate Name</th>
                                <th>Role Tittile</th>
                                <th>Job Status</th>
                                <th>Applied On</th>
                                <th>Review Status</th>
                            </tr>
                        </thead>
                        <tbody>
            `;

            filtered.forEach(app => {
                html += `
                    <tr class="sw-table-row" onclick="swOpenApplicationDetails(${app.id})">
                            <td>${app.job.id}</td>
                        <td>
                            <div class="sw-applicant-cell">
                                <div class="sw-avatar">${app.user.name.charAt(0)}</div>
                                <span>${app.user.name}</span>
                            </div>
                        </td>
                        <td>${app.job.job_title}</td>
                        <td><span class="sw-status-badge sw-status-${app.status.toLowerCase().replace(/\s+/g, '-')}">${app.status}</span></td>
                        <td>${new Date(app.created_at).toLocaleDateString()}</td>
                       <td><span class="sw-status-badge">${app.is_read == 1 ? 'Reviewed' : 'New Application'}</span></td>

                    </tr>
                `;
            });

            html += `
                        </tbody>
                    </table>
                </div>
            `;

            container.innerHTML = html;
        })
        .catch(() => {
            container.innerHTML = `<p class="text-danger">Failed to load applications.</p>`;
        });
}


function swOpenApplicationDetails(id) {

    fetch(`/swApplications/${id}/mark-read`, 
    { method: 'POST', headers: { 'X-CSRF-TOKEN':
     document.querySelector('meta[name="csrf-token"]').content } });


    swCloseAllOffcanvases();

    const canvas = new bootstrap.Offcanvas(document.getElementById('sw-details-offcanvas'));
    canvas.show();

    const container = document.getElementById("sw-details-content");
    container.innerHTML = `<p class="text-muted">Loading details...</p>`;

    fetch(`/swApplications/${id}`)
        .then(res => res.json())
        .then(app => {

            let html = `

           <div class="sw-button-group mb-3">



    <button class="sw-viewer-btn sw-viewer-btn-primary w-100"
        onclick="swShowResume('${app.resume_path}')">
        View Resume
    </button>

    ${app.cover_letter_path ? `
    <button class="sw-viewer-btn sw-viewer-btn-secondary w-100"
        onclick="swShowCover('${app.cover_letter_path}')">
        View Cover Letter
    </button>` : ``}

    <button class="sw-viewer-btn sw-btn-green w-100"
        onclick="swShortlistApplication(${app.id})">
        Shortlist Candidate
    </button>

    <button class="sw-viewer-btn sw-btn-red w-100"
        onclick="swRejectApplication(${app.id})">
        Reject Application
    </button>

<button class="sw-viewer-btn sw-btn-blue w-100"
    onclick="swOpenInterviewCalendar(${app.id})">
    Schedule Interview
</button>







    <button class="sw-viewer-btn sw-btn-orange w-100"
        onclick="swPendingReview(${app.id})">
        Place To Pending Review
    </button>

</div>


    <div class="sw-applicant-card">
        <div class="sw-applicant-info">
            <div class="sw-applicant-meta">
                 <div><strong>Candidate Name:</strong> ${app.user.name}</div>
                <div><strong>Role Appplied For:</strong> ${app.job.job_title}</div>
                <div><strong>Job ID:</strong> ${app.job.id}</div>
                   <div><strong>Location:</strong> ${app.job.location}</div>
                <div><strong>Company:</strong> ${app.job.company}</div>
                <div><strong>Job Status:</strong> <span class="sw-status-badge">${app.status}</span></div>
                <div><strong>Applied on:</strong> ${new Date(app.created_at).toLocaleDateString()}</div>
                 <div><strong>Review Status:</strong> <span class="sw-status-badge">${app.is_read == 1 ? 'Reviewed' : 'New Application'}</span></div>
            </div>
        </div>
    </div>

 





    <iframe id="sw-resume-viewer" class="sw-pdf-viewer"></iframe>
    <iframe id="sw-cover-viewer" class="sw-pdf-viewer"></iframe>

    <h3 class="sw-section-title">Applicant Answers</h3>

    <div class="sw-answers-grid">
`;

            app.questions.forEach(q => {
                html += `
                    <div class="sw-answer-item">
                        <div class="fw-bold mb-1">${q.label}</div>
                        <div>${q.answer}</div>
                    </div>
                `;
            });

            html += `</div>`;

            container.innerHTML = html;
        })
      .catch(error => {
    console.error(error); // shows full error in console
    container.innerHTML = `
        <p class="text-danger">
            Failed to load details:<br>
            <small>${error.message}</small>
        </p>
    `;
});

}



function swShowResume(path) {
    document.getElementById("sw-cover-viewer").style.display = "none";

    const viewer = document.getElementById("sw-resume-viewer");
    viewer.src = `/storage/${path}`;
    viewer.style.display = "block";
}

function swShowCover(path) {
    document.getElementById("sw-resume-viewer").style.display = "none";

    const viewer = document.getElementById("sw-cover-viewer");
    viewer.src = `/storage/${path}`;
    viewer.style.display = "block";
}



function swRejectApplication(id) {

    Swal.fire({
        title: 'Reject Application',
        text: 'Are you sure you want to reject this application?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, Reject',
        cancelButtonText: 'Cancel',
        reverseButtons: true,
        customClass: {
            popup: 'sw-swal-popup',
            confirmButton: 'sw-swal-confirm',
            cancelButton: 'sw-swal-cancel'
        }
    }).then((result) => {

        if (result.isConfirmed) {

            fetch(`/swApplications/${id}/reject`, {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content
                }
            })
            .then(res => res.json())
            .then(data => {

                if (data.success) {

                    Notiflix.Notify.success('Application rejected successfully');

                    // Close details panel
                    const details = bootstrap.Offcanvas.getInstance(
                        document.getElementById('sw-details-offcanvas')
                    );
                    if (details) details.hide();

                    // Refresh list with SAME category
                    swOpenApplications(window.swSelectedCategory);

                } else {
                    Notiflix.Notify.failure('Failed to reject application');
                }
            })
            .catch(() => {
                Notiflix.Notify.failure('Error rejecting application');
            });

        } else {
            Notiflix.Notify.info('Action cancelled');
        }
    });
}


function swShortlistApplication(id) {

    Swal.fire({
        title: 'Shortlist Candidate',
        text: 'Do you want to shortlist this candidate?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Yes, Shortlist',
        cancelButtonText: 'Cancel',
        reverseButtons: true,
        customClass: {
            popup: 'sw-swal-popup',
            confirmButton: 'sw-swal-confirm',
            cancelButton: 'sw-swal-cancel'
        }
    }).then((result) => {

        if (result.isConfirmed) {

            fetch(`/swApplications/${id}/shortlist`, {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content
                }
            })
            .then(res => res.json())
            .then(data => {

                if (data.success) {

                    Notiflix.Notify.success('Candidate shortlisted successfully');

                    // Close details panel
                    const details = bootstrap.Offcanvas.getInstance(
                        document.getElementById('sw-details-offcanvas')
                    );
                    if (details) details.hide();

                    // Refresh list with SAME category
                    swOpenApplications(window.swSelectedCategory);

                } else {
                    Notiflix.Notify.failure('Failed to shortlist candidate');
                }
            })
            .catch(() => {
                Notiflix.Notify.failure('Error shortlisting candidate');
            });

        } else {
            Notiflix.Notify.info('Action cancelled');
        }
    });
}



function swPendingReview(id) {

    Swal.fire({
        title: 'Move to Pending Review',
        text: 'Do you want to move this application back to Pending Review?',
        icon: 'info',
        showCancelButton: true,
        confirmButtonText: 'Yes, Move',
        cancelButtonText: 'Cancel',
        reverseButtons: true,
        customClass: {
            popup: 'sw-swal-popup',
            confirmButton: 'sw-swal-confirm',
            cancelButton: 'sw-swal-cancel'
        }
    }).then((result) => {

        if (result.isConfirmed) {

            fetch(`/swApplications/${id}/pending`, {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content
                }
            })
            .then(res => res.json())
            .then(data => {

                if (data.success) {

                    Notiflix.Notify.success('Application moved to Pending Review');

                    // Close details panel
                    const details = bootstrap.Offcanvas.getInstance(
                        document.getElementById('sw-details-offcanvas')
                    );
                    if (details) details.hide();

                    // Refresh list with SAME category
                    swOpenApplications(window.swSelectedCategory);

                } else {
                    Notiflix.Notify.failure('Failed to update application');
                }
            })
            .catch(() => {
                Notiflix.Notify.failure('Error updating application');
            });

        } else {
            Notiflix.Notify.info('Action cancelled');
        }
    });
}


function swSetFilter(status) {
    document.getElementById("sw-status-filter").value = status;

    // Re-open with the SAME category the user selected
    swOpenApplications(window.swSelectedCategory || null);
}


document.addEventListener("DOMContentLoaded", () => {
    const panel = document.getElementById("applicationsPanel");
    document.body.appendChild(panel); // force attach to real body
});


  function swDetailsClosed() {
    const detailsEl = document.getElementById('sw-details-offcanvas');

    // Wait for Bootstrap to finish closing animation
    detailsEl.addEventListener('hidden.bs.offcanvas', function handler() {
            swOpenApplications(window.swSelectedCategory || null); // refresh list
        detailsEl.removeEventListener('hidden.bs.offcanvas', handler);
    });
}

function swCloseAndRefresh() {
    const offcanvasEl = document.querySelector('.sw-offcanvas');

    // Wait for the offcanvas to fully close
    offcanvasEl.addEventListener('hidden.bs.offcanvas', function handler() {
        location.reload(); // refresh the page
        offcanvasEl.removeEventListener('hidden.bs.offcanvas', handler);
    });
}




// Notifications for new applications



// ------------------------------
// NOTIFICATION BADGE (TOP NAV)
// ------------------------------
function refreshApplicationsBadge() {
    fetch('/notifications/applications')
        .then(res => res.json())
        .then(data => {
            console.log('applications notif response:', data);

            const badge = document.getElementById('applicationsBadge');
            if (!badge) return;

            if (data.new > 0) {
                badge.classList.remove('d-none');
                badge.textContent =  ' New Applications';
            } else {
                badge.classList.add('d-none');
            }
        })
        .catch(err => {
            console.error('applications notif error:', err);
        });
}

document.addEventListener('DOMContentLoaded', () => {
    refreshApplicationsBadge();
    setInterval(refreshApplicationsBadge, 20000);
});









// ------------------------------
// CATEGORY BADGES (BLINKING DOTS)
// ------------------------------

function updateCategoryBadges(applications) {

    const categories = [
        "Support Workers",
        "Senior Support Workers",
        "Service Managers",
        "Operations Managers",
        "Social Workers",
        "Administration Officers",
        "Nurses",
        "Team Leaders",
        "Business Managers"
    ];

    categories.forEach(cat => {

        // Convert category → badge ID
        const badgeId = "badge-" + cat.replace(/\s+/g, '-');
        const badge = document.getElementById(badgeId);

        if (!badge) return;

        // Count applications for this category
        const count = applications.filter(a => a.job_category === cat).length;

        // Show blinking dot if count > 0
        badge.style.display = count > 0 ? "block" : "none";
        badge.textContent = count + " new Applications";

    });
}


// ------------------------------
// POLL CATEGORY DATA
// ------------------------------

function pollCategoryApplications() {
    fetch('/swApplicationsbadge')
        .then(res => res.json())
        .then(data => {
            updateCategoryBadges(data);
        })
        .catch(console.error);
}

document.addEventListener('DOMContentLoaded', () => {
    pollCategoryApplications();
    setInterval(pollCategoryApplications, 20000);
});






document.addEventListener('DOMContentLoaded', () => {
    const applicationsPanel = document.getElementById('applicationsPanel');
    if (!applicationsPanel) return;

    applicationsPanel.addEventListener('show.bs.offcanvas', () => {
        fetch('/notifications/applications/mark-read', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({})
        })
            .then(res => res.json())
            .then(() => {
                // Immediately sync with DB after mark-read
                refreshApplicationsBadge();
                lastApplicationsCount = 0;
            })
            .catch(console.error);
    });
});


function switchToApplicationsPanel() {
    const current = bootstrap.Offcanvas.getInstance(document.getElementById('sw-offcanvas'));
    current.hide();

    setTimeout(() => {
        const panel = bootstrap.Offcanvas.getOrCreateInstance(document.getElementById('applicationsPanel'));
        panel.show();
    }, 300); // wait for hide animation
}

















        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('active');
        }

        function closeOffcanvas(id) {
    const el = document.getElementById(id);
    if (!el) return;

    const instance = bootstrap.Offcanvas.getInstance(el);
    if (instance) instance.hide();
}

    </script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    let selectedApplicationId = null;
    let interviewCalendar = null;
    let selectedDate = null;

    // ------------------------------------------------------
    // OPEN INTERVIEW CALENDAR (OFFCANVAS)
    // ------------------------------------------------------
window.swOpenInterviewCalendar = function (id) {
    selectedApplicationId = id;

    // Close details offcanvas first
    closeOffcanvas('sw-details-offcanvas');

    const canvasEl = document.getElementById('interviewCalendarOffcanvas');
    const offcanvas = bootstrap.Offcanvas.getOrCreateInstance(canvasEl);
    offcanvas.show();

    if (!interviewCalendar) {
        initInterviewCalendar();
    } else {
        interviewCalendar.refetchEvents();
    }
};


    // ------------------------------------------------------
    // INITIALIZE FULLCALENDAR
    // ------------------------------------------------------
    function initInterviewCalendar() {
        const calendarEl = document.getElementById('fullInterviewCalendar');
        if (!calendarEl) {
            console.error('fullInterviewCalendar not found');
            return;
        }

        interviewCalendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            selectable: true,
            height: '100%',
            events: '/swApplications/interviews',
            dateClick: function(info) {
                selectedDate = info.dateStr;
                window.openTimeSelection();
            }
        });

        interviewCalendar.render();
    }

    // ------------------------------------------------------
    // OPEN TIME SELECTION (OFFCANVAS)
    // ------------------------------------------------------
window.openTimeSelection = function () {
    if (!selectedDate) {
        console.error("No selected date");
        return;
    }

    const container = document.getElementById('timeSlots');
    if (!container) {
        console.error("timeSlots not found");
        return;
    }

    container.innerHTML = "";

    fetch(`/user/times?date=${selectedDate}`)
        .then(res => {
            if (!res.ok) throw new Error("Failed to load times");
            return res.json();
        })
        .then(data => {
            const available = data.available || [];

            //  No times → keep / reopen calendar, don't open time offcanvas
            if (available.length === 0) {
                Swal.fire({
                    icon: 'info',
                    title: 'No available times',
                    text: 'There are no available time slots for this date. Please choose another day.',
                    showConfirmButton: false,
                    timer: 2500
                });

                // Make sure calendar offcanvas is visible
                const calendarCanvas = bootstrap.Offcanvas.getOrCreateInstance(
                    document.getElementById('interviewCalendarOffcanvas')
                );
                calendarCanvas.show();

                return; // ⬅️ stop here, do NOT open timeSelectOffcanvas
            }

            // ✅ Times exist → build list and open time offcanvas
            available.forEach(time => {
                const btn = document.createElement('button');
                btn.className = "list-group-item list-group-item-action";
                btn.textContent = time;
                btn.onclick = () => scheduleInterview(time);
                container.appendChild(btn);
            });

            // Close calendar offcanvas
            const calendarCanvas = bootstrap.Offcanvas.getInstance(
                document.getElementById('interviewCalendarOffcanvas')
            );
            if (calendarCanvas) calendarCanvas.hide();

            // Open time selection offcanvas
            const timeCanvas = bootstrap.Offcanvas.getOrCreateInstance(
                document.getElementById('timeSelectOffcanvas')
            );
            timeCanvas.show();
        })
        .catch(err => {
            console.error(err);
            Swal.fire("Error", err.message, "error");
        });
};



    // ------------------------------------------------------
    // SCHEDULE INTERVIEW
    // ------------------------------------------------------
    function scheduleInterview(time) {
        if (!selectedDate || !selectedApplicationId) {
            Swal.fire("Error", "Missing date or application ID", "error");
            return;
        }

        const start = new Date(`${selectedDate}T${time}:00`);
        const end = new Date(start.getTime() + 30 * 60000);

        const start_time = start.toISOString();
        const end_time = end.toISOString();

        const displayDate = start.toLocaleDateString('en-AU', {
            weekday: 'long', year: 'numeric', month: 'long', day: 'numeric'
        });

        const displayStart = start.toLocaleTimeString('en-AU', {
            hour: '2-digit', minute: '2-digit'
        });

        const displayEnd = end.toLocaleTimeString('en-AU', {
            hour: '2-digit', minute: '2-digit'
        });

     Swal.fire({
    title: '',
    html: `
        <div style="text-align:center; padding-top:10px;">
            <div style="font-size:1.1rem; font-weight:600; margin-bottom:12px;">
                Scheduling Interview...
            </div>

            <div class="progress" style="height: 8px;">
                <div class="progress-bar progress-bar-striped progress-bar-animated" 
                     role="progressbar" style="width: 100%; background:#71103E;">
                </div>
            </div>

            <div style="margin-top:12px; font-size:0.9rem; color:#555;">
                Please wait while we schedule your interview.
            </div>
        </div>
    `,
    showConfirmButton: false,
    allowOutsideClick: false,
    allowEscapeKey: false,
    backdrop: true,
    customClass: {
        popup: 'swal-no-card'
    }
});


        fetch('/google/schedule-interview', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({
                title: "Interview with Applicant #" + selectedApplicationId,
                description: "Interview scheduled via SupportWork Admin Panel",
                start_time,
                end_time,
                application_id: selectedApplicationId
            })
        })
        .then(async res => {
            const text = await res.text();
            let data;

            try {
                data = JSON.parse(text);
            } catch {
                throw new Error(text || "Invalid JSON response");
            }

            if (!res.ok || data.error) {
                throw new Error(data.error || text || "Unknown error");
            }

            return data;
        })
        .then(async data => {

            // Update user times
            await fetch('/user/times/update', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                },
                body: JSON.stringify({
                    date: selectedDate,
                    time: time
                })
            });

        Swal.fire({
    icon: 'success',
    title: 'Interview has been scheduled successfully!',
    html: `
        <div style="text-align:left; font-size:1rem; line-height:1.6;">
            <strong>Date:</strong> ${displayDate}<br>
            <strong>Time:</strong> ${displayStart} – ${displayEnd}<br><br>
            The applicant will be notified via email.
            <br><br>
            <strong>Meeting has been synced with Your Google Calendar.</strong>
            <br><br>
            <a href="/google/calendar" target="_blank">
                <button class="sw-viewer-btn sw-btn-blue w-100">
                    View in Google Calendar
                </button>
            </a>
            <br><br>
            <button class="sw-viewer-btn sw-btn-red w-100" onclick="location.reload();">
                Close
            </button>
        </div>
    `,
    showConfirmButton: false,   // ← removes OK button
    allowOutsideClick: false,
    allowEscapeKey: false
});


            if (interviewCalendar) interviewCalendar.refetchEvents();

            // Close time selection offcanvas
            const timeCanvas = bootstrap.Offcanvas.getInstance(
                document.getElementById('timeSelectOffcanvas')
            );
            if (timeCanvas) timeCanvas.hide();

            // Close time selection offcanvas
                closeOffcanvas('timeSelectOffcanvas');

                // Reopen details offcanvas
                const detailsCanvas = bootstrap.Offcanvas.getOrCreateInstance(
                    document.getElementById('sw-details-offcanvas')
                );
                detailsCanvas.show();

        })
        .catch(err => {
            console.error(err);
            Swal.fire("Unexpected Error", err.message, "error");
        });
    }

});
</script>



<script>
  const SLOT_MINUTES = 30;
  const START_HOUR = 6;
  const END_HOUR = 23;
  const DAY_COUNT = 5;

  const gridEl = document.getElementById("grid");
  const weekLabelEl = document.getElementById("weekLabel");
  const weekHeaderEl = document.getElementById("weekHeader");
  const dayViewEl = document.getElementById("dayView");
  const dayGridEl = document.getElementById("dayGrid");
  const dayViewHeaderEl = document.getElementById("dayViewHeader");
  const monthViewEl = document.getElementById("monthView");
  const monthHeaderEl = document.getElementById("monthHeader");
  const monthGridEl = document.getElementById("monthGrid");
  const viewButtonsEl = document.getElementById("viewButtons");

  let currentMonday = getMonday(new Date());
  let currentView = "week";
  let events = [];

  let dragState = null;
  let selectionState = null;

  let recipients = [];

  function getMonday(d) {
    const date = new Date(d);
    const day = date.getDay();
    const diff = (day === 0 ? -6 : 1) - day;
    date.setDate(date.getDate() + diff);
    date.setHours(0,0,0,0);
    return date;
  }

  function formatRangeLabel() {
    if (currentView === "week") {
      const end = new Date(currentMonday);
      end.setDate(end.getDate() + 4);
      return `${currentMonday.toLocaleDateString()} - ${end.toLocaleDateString()}`;
    } else if (currentView === "day") {
      return currentMonday.toLocaleDateString(undefined, { weekday:"long", year:"numeric", month:"short", day:"numeric" });
    } else {
      return currentMonday.toLocaleDateString(undefined, { month:"long", year:"numeric" });
    }
  }

  function to12h(h, m) {
    const ampm = h >= 12 ? "PM" : "AM";
    const hour12 = ((h + 11) % 12) + 1;
    return `${hour12}:${m.toString().padStart(2,"0")} ${ampm}`;
  }

  function buildWeekHeader() {
    while (weekHeaderEl.children.length > 1) {
      weekHeaderEl.removeChild(weekHeaderEl.lastChild);
    }
    const today = new Date();
    today.setHours(0,0,0,0);

    for (let i = 0; i < DAY_COUNT; i++) {
      const d = new Date(currentMonday);
      d.setDate(d.getDate() + i);

      const dayName = d.toLocaleDateString(undefined, { weekday: "short" });
      const dayNum = d.toLocaleDateString(undefined, { day: "numeric" });
      const monthShort = d.toLocaleDateString(undefined, { month: "short" });

      const col = document.createElement("div");
      col.className = "week-header-day";

      if (d.toDateString() === today.toDateString()) {
        col.classList.add("today");
      }

      col.innerHTML = `
        <div class="day-name">${dayName}</div>
        <div class="day-date">${dayNum} ${monthShort}</div>
      `;
      weekHeaderEl.appendChild(col);
    }
  }

  function buildWeekGrid() {
    gridEl.innerHTML = "";
    const totalSlots = ((END_HOUR - START_HOUR + 1) * 60) / SLOT_MINUTES;

    for (let i = 0; i < totalSlots; i++) {
      const row = document.createElement("div");
      row.className = "row-slot";

      const minutesFromStart = i * SLOT_MINUTES;
      const hour = START_HOUR + Math.floor(minutesFromStart / 60);
      const minute = minutesFromStart % 60;

      const timeCol = document.createElement("div");
      timeCol.className = "row-time";
      timeCol.textContent = to12h(hour, minute);
      row.appendChild(timeCol);

      const cellsWrap = document.createElement("div");
      cellsWrap.className = "row-cells";

      for (let d = 0; d < DAY_COUNT; d++) {
        const cell = document.createElement("div");
        cell.className = "cell";
        cell.dataset.day = d;
        cell.dataset.slotIndex = i;
        cell.addEventListener("mousedown", (e) => startSelection(e, d, i, "week"));
        cellsWrap.appendChild(cell);
      }

      row.appendChild(cellsWrap);
      gridEl.appendChild(row);
    }
  }

  function buildDayGrid() {
    dayGridEl.innerHTML = "";
    const totalSlots = ((END_HOUR - START_HOUR + 1) * 60) / SLOT_MINUTES;

    for (let i = 0; i < totalSlots; i++) {
      const row = document.createElement("div");
      row.className = "row-slot";

      const minutesFromStart = i * SLOT_MINUTES;
      const hour = START_HOUR + Math.floor(minutesFromStart / 60);
      const minute = minutesFromStart % 60;

      const timeCol = document.createElement("div");
      timeCol.className = "row-time";
      timeCol.textContent = to12h(hour, minute);
      row.appendChild(timeCol);

      const cellsWrap = document.createElement("div");
      cellsWrap.className = "row-cells";

      const cell = document.createElement("div");
      cell.className = "cell";
      cell.dataset.day = 0;
      cell.dataset.slotIndex = i;
      cell.addEventListener("mousedown", (e) => startSelection(e, 0, i, "day"));
      cellsWrap.appendChild(cell);

      row.appendChild(cellsWrap);
      dayGridEl.appendChild(row);
    }
  }

  function buildMonthHeader() {
    monthHeaderEl.innerHTML = "";
    const empty = document.createElement("div");
    empty.className = "week-header-time";
    monthHeaderEl.appendChild(empty);

    const days = ["Mon","Tue","Wed","Thu","Fri","Sat","Sun"];
    days.forEach(d => {
      const col = document.createElement("div");
      col.className = "week-header-day";
      col.innerHTML = `<div class="day-name">${d}</div>`;
      monthHeaderEl.appendChild(col);
    });
  }

  function buildMonthGrid() {
    monthGridEl.innerHTML = "";
    const firstOfMonth = new Date(currentMonday.getFullYear(), currentMonday.getMonth(), 1);
    const firstDay = firstOfMonth.getDay() === 0 ? 7 : firstOfMonth.getDay();
    const startDate = new Date(firstOfMonth);
    startDate.setDate(firstOfMonth.getDate() - (firstDay - 1));

    for (let i = 0; i < 42; i++) {
      const d = new Date(startDate);
      d.setDate(startDate.getDate() + i);

      const cell = document.createElement("div");
      cell.className = "month-cell";
      cell.dataset.date = d.toISOString();

      const isCurrentMonth = d.getMonth() === currentMonday.getMonth();
      const header = document.createElement("div");
      header.className = "month-cell-header" + (isCurrentMonth ? "" : " muted");
      header.textContent = d.getDate();
      cell.appendChild(header);

      const evWrap = document.createElement("div");
      evWrap.className = "month-events";

      const dayEvents = events.filter(ev => {
        const s = new Date(ev.start);
        return s.getFullYear() === d.getFullYear() &&
               s.getMonth() === d.getMonth() &&
               s.getDate() === d.getDate();
      }).sort((a,b) => new Date(a.start) - new Date(b.start));

      const maxVisible = 3;
      dayEvents.slice(0, maxVisible).forEach(ev => {
        const eDiv = document.createElement("div");
        eDiv.className = "month-event";
        eDiv.textContent = ev.title || "(No title)";
        eDiv.addEventListener("click", (e) => {
          e.stopPropagation();
          openEdit(ev);
        });
        evWrap.appendChild(eDiv);
      });

      if (dayEvents.length > maxVisible) {
        const more = document.createElement("div");
        more.className = "month-more";
        more.textContent = `+${dayEvents.length - maxVisible} more`;
        more.addEventListener("click", (e) => {
          e.stopPropagation();
          switchToDayView(d);
        });
        evWrap.appendChild(more);
      }

      cell.appendChild(evWrap);
      cell.addEventListener("click", () => switchToDayView(d));
      monthGridEl.appendChild(cell);
    }
  }

  function slotToDate(dayIndex, slotIndex, context) {
    const base = new Date(currentMonday);
    if (context === "week") {
      base.setDate(base.getDate() + dayIndex);
    }
    const minutesFromStart = slotIndex * SLOT_MINUTES;
    const hour = START_HOUR + Math.floor(minutesFromStart / 60);
    const minute = minutesFromStart % 60;
    base.setHours(hour, minute, 0, 0);
    return base;
  }

  function toLocalInput(date) {
    const off = date.getTimezoneOffset();
    const local = new Date(date.getTime() - off*60000);
    return local.toISOString().slice(0,16);
  }

  function fromLocalInput(value) {
    const d = new Date(value);
    const off = d.getTimezoneOffset();
    return new Date(d.getTime() + off*60000);
  }

  function renderEvents() {
    document.querySelectorAll(".event-block").forEach(e => e.remove());

    if (currentView === "week") {
      const totalSlots = ((END_HOUR - START_HOUR + 1) * 60) / SLOT_MINUTES;
      const rowHeight = 40;

      events.forEach(ev => {
        const start = new Date(ev.start);
        const end = new Date(ev.end);

        const dayIndex = Math.floor((start - currentMonday) / (1000*60*60*24));
        if (dayIndex < 0 || dayIndex >= DAY_COUNT) return;

        const minutesFromStart = (start.getHours() - START_HOUR) * 60 + start.getMinutes();
        const slotIndex = Math.floor(minutesFromStart / SLOT_MINUTES);
        if (slotIndex < 0 || slotIndex >= totalSlots) return;

        const durationMinutes = (end - start) / 60000;
        const slotSpan = Math.max(1, durationMinutes / SLOT_MINUTES);

        const row = gridEl.children[slotIndex];
        if (!row) return;
        const cell = row.querySelectorAll(".cell")[dayIndex];
        if (!cell) return;

        const block = document.createElement("div");
        block.className = "event-block";
        block.style.top = "2px";
        block.style.height = `${slotSpan * rowHeight - 4}px`;
        block.innerHTML = `<div class="event-title">${ev.title || "(No title)"}</div>`;
        block.dataset.id = ev.id;

        block.addEventListener("mousedown", (e) => startDragMove(e, ev, block, "week"));

        const handle = document.createElement("div");
        handle.className = "event-resize-handle";
        handle.addEventListener("mousedown", (e) => startDragResize(e, ev, block, "week"));
        block.appendChild(handle);

        cell.appendChild(block);
      });
    } else if (currentView === "day") {
      const totalSlots = ((END_HOUR - START_HOUR + 1) * 60) / SLOT_MINUTES;
      const rowHeight = 40;
      const dayDate = new Date(currentMonday);

      events.forEach(ev => {
        const start = new Date(ev.start);
        const end = new Date(ev.end);

        if (start.toDateString() !== dayDate.toDateString()) return;

        const minutesFromStart = (start.getHours() - START_HOUR) * 60 + start.getMinutes();
        const slotIndex = Math.floor(minutesFromStart / SLOT_MINUTES);
        if (slotIndex < 0 || slotIndex >= totalSlots) return;

        const durationMinutes = (end - start) / 60000;
        const slotSpan = Math.max(1, durationMinutes / SLOT_MINUTES);

        const row = dayGridEl.children[slotIndex];
        if (!row) return;
        const cell = row.querySelector(".cell");
        if (!cell) return;

        const block = document.createElement("div");
        block.className = "event-block";
        block.style.top = "2px";
        block.style.height = `${slotSpan * rowHeight - 4}px`;
        block.innerHTML = `<div class="event-title">${ev.title || "(No title)"}</div>`;
        block.dataset.id = ev.id;

        block.addEventListener("mousedown", (e) => startDragMove(e, ev, block, "day"));

        const handle = document.createElement("div");
        handle.className = "event-resize-handle";
        handle.addEventListener("mousedown", (e) => startDragResize(e, ev, block, "day"));
        block.appendChild(handle);

        cell.appendChild(block);
      });
    } else if (currentView === "month") {
      buildMonthGrid();
    }
  }

  function startDragMove(e, ev, block, context) {
    if (e.target.classList.contains("event-resize-handle")) return;
    e.preventDefault();
    e.stopPropagation();
    dragState = {
      type: "move",
      event: ev,
      startY: e.clientY,
      startStart: new Date(ev.start),
      startEnd: new Date(ev.end),
      block,
      context
    };
    block.classList.add("event-dragging");
    document.addEventListener("mousemove", onDragMove);
    document.addEventListener("mouseup", stopDrag);
  }

  function startDragResize(e, ev, block, context) {
    e.preventDefault();
    e.stopPropagation();
    dragState = {
      type: "resize",
      event: ev,
      startY: e.clientY,
      startEnd: new Date(ev.end),
      block,
      context
    };
    block.classList.add("event-dragging");
    document.addEventListener("mousemove", onDragMove);
    document.addEventListener("mouseup", stopDrag);
  }

  function onDragMove(e) {
    if (!dragState) return;
    const deltaY = e.clientY - dragState.startY;
    const rowHeight = 40;
    const deltaSlots = Math.round(deltaY / rowHeight);
    const deltaMinutes = deltaSlots * SLOT_MINUTES;

    if (dragState.type === "move") {
      const newStart = new Date(dragState.startStart);
      newStart.setMinutes(newStart.getMinutes() + deltaMinutes);
      const newEnd = new Date(dragState.startEnd);
      newEnd.setMinutes(newEnd.getMinutes() + deltaMinutes);
      if (newEnd <= newStart) return;
      dragState.event.start = newStart.toISOString();
      dragState.event.end = newEnd.toISOString();
    } else if (dragState.type === "resize") {
      const newEnd = new Date(dragState.startEnd);
      newEnd.setMinutes(newEnd.getMinutes() + deltaMinutes);
      if (newEnd <= new Date(dragState.event.start)) return;
      dragState.event.end = newEnd.toISOString();
    }

    renderEvents();
  }

  function stopDrag() {
    document.removeEventListener("mousemove", onDragMove);
    document.removeEventListener("mouseup", stopDrag);
    if (dragState && dragState.block) {
      dragState.block.classList.remove("event-dragging");
    }
    dragState = null;
  }

 function openEdit(ev) {
  // Close calendar offcanvas first
  const cal = bootstrap.Offcanvas.getInstance(document.getElementById("calendarOffcanvas"));
  if (cal) cal.hide();

  // Populate fields
  document.getElementById("evTitle").value = ev.title;
  document.getElementById("evDesc").value = ev.desc || "";
  document.getElementById("evStart").value = toLocalInput(new Date(ev.start));
  document.getElementById("evEnd").value = toLocalInput(new Date(ev.end));

  document.getElementById("eventForm").dataset.editId = ev.id;

  recipients = ev.recipients || [];
  renderRecipients();

  updateAISuggestion();

  // OPEN THE OFFCANVAS (replaces modal)
  new bootstrap.Offcanvas(document.getElementById("eventOffcanvas")).show();
}

  document.getElementById("saveEvent").onclick = () => {
    const title = document.getElementById("evTitle").value.trim();
    const desc = document.getElementById("evDesc").value.trim();
   const start = fromLocalInput(document.getElementById("evStart").value);
const end = fromLocalInput(document.getElementById("evEnd").value);

const startFormatted = formatAMPM(start);
const endFormatted = formatAMPM(end);


    if (!title || !start || !end || end <= start) {
      alert("Check title and time range.");
      return;
    }

    const form = document.getElementById("eventForm");
    const editId = form.dataset.editId;

    if (editId) {
      const ev = events.find(e => e.id === editId);
      if (ev) {
        ev.title = title;
        ev.desc = desc;
        ev.start = start.toISOString();
        ev.end = end.toISOString();
        ev.recipients = [...recipients];
      }
    } else {
      events.push({
        id: "ev_" + Date.now(),
        title,
        desc,
        start: start.toISOString(),
        end: end.toISOString(),
        recipients: [...recipients]
      });
    }

    bootstrap.Modal.getInstance(document.getElementById("eventModal")).hide();
    refreshView();
  };

  document.getElementById("btnPrev").onclick = () => {
    if (currentView === "week") {
      currentMonday.setDate(currentMonday.getDate() - 7);
    } else if (currentView === "day") {
      currentMonday.setDate(currentMonday.getDate() - 1);
    } else {
      currentMonday.setMonth(currentMonday.getMonth() - 1);
    }
    refreshView();
  };
  document.getElementById("btnNext").onclick = () => {
    if (currentView === "week") {
      currentMonday.setDate(currentMonday.getDate() + 7);
    } else if (currentView === "day") {
      currentMonday.setDate(currentMonday.getDate() + 1);
    } else {
      currentMonday.setMonth(currentMonday.getMonth() + 1);
    }
    refreshView();
  };
  document.getElementById("btnToday").onclick = () => {
    if (currentView === "day") {
      currentMonday = new Date();
      currentMonday.setHours(0,0,0,0);
    } else {
      currentMonday = getMonday(new Date());
    }
    refreshView();
  };

  document.getElementById("btnPrint").onclick = () => {
    window.print();
  };

  viewButtonsEl.addEventListener("click", (e) => {
    const btn = e.target.closest("button[data-view]");
    if (!btn) return;
    const view = btn.dataset.view;
    switchView(view);
  });

  function switchView(view) {
    currentView = view;
    viewButtonsEl.querySelectorAll("button").forEach(b => b.classList.remove("active"));
    viewButtonsEl.querySelector(`button[data-view="${view}"]`).classList.add("active");

    gridEl.style.display = "none";
    weekHeaderEl.style.display = "none";
    dayViewEl.style.display = "none";
    monthViewEl.style.display = "none";

    if (view === "week") {
      weekHeaderEl.style.display = "flex";
      gridEl.style.display = "block";
    } else if (view === "day") {
      dayViewEl.style.display = "flex";
    } else {
      monthViewEl.style.display = "flex";
    }

    refreshView();
  }

  function switchToDayView(date) {
    currentView = "day";
    currentMonday = new Date(date);
    currentMonday.setHours(0,0,0,0);
    switchView("day");
  }

  function refreshView() {
    weekLabelEl.textContent = formatRangeLabel();

    if (currentView === "week") {
      buildWeekHeader();
      buildWeekGrid();
    } else if (currentView === "day") {
      dayViewHeaderEl.textContent = currentMonday.toLocaleDateString(undefined, {
        weekday:"long", year:"numeric", month:"short", day:"numeric"
      });
      buildDayGrid();
    } else {
      buildMonthHeader();
      buildMonthGrid();
    }

    renderEvents();
  }

  function startSelection(e, dayIndex, slotIndex, context) {
    if (e.button !== 0) return;
    e.preventDefault();

    const cell = e.currentTarget;
    const rect = cell.getBoundingClientRect();
    const offsetY = e.clientY - rect.top;
    const rowHeight = 40;
    const slotOffset = offsetY / rowHeight;
    const startSlot = slotIndex + (slotOffset >= 0.5 ? 1 : 0);

    selectionState = {
      dayIndex,
      startSlot,
      endSlot: startSlot,
      selectionEl: null,
      context
    };

    createOrUpdateSelectionBlock();
    document.addEventListener("mousemove", onSelectionMove);
    document.addEventListener("mouseup", stopSelection);
  }

  function onSelectionMove(e) {
    if (!selectionState) return;

    const container = selectionState.context === "week" ? gridEl : dayGridEl;
    const gridRect = container.getBoundingClientRect();
    const y = e.clientY - gridRect.top;
    const rowHeight = 40;
    const slotIndex = Math.max(0, Math.min(Math.floor(y / rowHeight), container.children.length - 1));

    selectionState.endSlot = slotIndex;
    createOrUpdateSelectionBlock();
  }

  function createOrUpdateSelectionBlock() {
    const { dayIndex, startSlot, endSlot, context } = selectionState;
    const container = context === "week" ? gridEl : dayGridEl;

    const minSlot = Math.min(startSlot, endSlot);
    const maxSlot = Math.max(startSlot, endSlot) + 1;

    if (!selectionState.selectionEl) {
      const el = document.createElement("div");
      el.className = "selection-block";
      container.appendChild(el);
      selectionState.selectionEl = el;
      requestAnimationFrame(() => el.classList.add("visible"));
    }

    const rowTop = container.children[minSlot]?.getBoundingClientRect().top;
    const rowBottom = container.children[maxSlot - 1]?.getBoundingClientRect().bottom;
    const gridTop = container.getBoundingClientRect().top;

    const top = rowTop - gridTop + 2;
    const height = rowBottom - rowTop - 4;

    const sampleRow = container.children[minSlot];
    const cell = sampleRow.querySelectorAll(".cell")[context === "week" ? dayIndex : 0];
    const cellRect = cell.getBoundingClientRect();
    const gridLeft = container.getBoundingClientRect().left;

    const left = cellRect.left - gridLeft + 3;
    const width = cellRect.width - 6;

    const el = selectionState.selectionEl;
    el.style.top = `${top}px`;
    el.style.height = `${height}px`;
    el.style.left = `${left}px`;
    el.style.width = `${width}px`;
  }

  function stopSelection() {
    document.removeEventListener("mousemove", onSelectionMove);
    document.removeEventListener("mouseup", stopSelection);

    if (!selectionState) return;

    const { dayIndex, startSlot, endSlot, selectionEl, context } = selectionState;
    const minSlot = Math.min(startSlot, endSlot);
    const maxSlot = Math.max(startSlot, endSlot) + 1;

    if (selectionEl) {
      selectionEl.classList.remove("visible");
      setTimeout(() => selectionEl.remove(), 120);
    }

    const start = slotToDate(dayIndex, minSlot, context);
    const end = slotToDate(dayIndex, maxSlot, context);

    selectionState = null;

    document.getElementById("evTitle").value = "";
    document.getElementById("evDesc").value = "";
    document.getElementById("evStart").value = toLocalInput(start);
    document.getElementById("evEnd").value = toLocalInput(end);
    document.getElementById("eventForm").dataset.editId = "";
    recipients = [];
    updateAISuggestion();

 new bootstrap.Offcanvas(document.getElementById("eventOffcanvas")).show();

 const calendarCanvasEl = document.getElementById("calendarOffcanvas");
    const calendarCanvas = bootstrap.Offcanvas.getInstance(calendarCanvasEl);
    if (calendarCanvas) calendarCanvas.hide();


  }

//   const recipientsContainer = document.getElementById("recipientsContainer");
//   const recipientsInput = document.getElementById("recipientsInput");

//   recipientsContainer.addEventListener("click", () => {
//     recipientsInput.focus();
//   });

//   recipientsInput.addEventListener("keydown", (e) => {
//     if (e.key === "Enter" || e.key === ",") {
//       e.preventDefault();
//       const value = recipientsInput.value.trim().replace(/,$/, "");
//       if (value) {
//         recipients.push(value);
//         recipientsInput.value = "";
//         renderRecipients();
//       }
//     } else if (e.key === "Backspace" && !recipientsInput.value && recipients.length) {
//       recipients.pop();
//       renderRecipients();
//     }
//   });

//   function renderRecipients() {
//     recipientsContainer.querySelectorAll(".recipient-chip").forEach(c => c.remove());
//     recipients.forEach((r, index) => {
//       const chip = document.createElement("span");
//       chip.className = "recipient-chip";
//       chip.innerHTML = `${r} <button type="button">&times;</button>`;
//       chip.querySelector("button").addEventListener("click", () => {
//         recipients.splice(index, 1);
//         renderRecipients();
//       });
//       recipientsContainer.insertBefore(chip, recipientsInput);
//     });
//   }

  const evTitleEl = document.getElementById("evTitle");
  const evDescEl = document.getElementById("evDesc");
  const aiSuggestionEl = document.getElementById("aiSuggestion");
  const aiSuggestionTextEl = document.getElementById("aiSuggestionText");
  const btnUseSuggestion = document.getElementById("btnUseSuggestion");

  function updateAISuggestion() {
    const title = evTitleEl.value.trim();
    const startVal = document.getElementById("evStart").value;
    const endVal = document.getElementById("evEnd").value;

    if (!title || !startVal || !endVal) {
      aiSuggestionEl.style.display = "none";
      return;
    }

const start = fromLocalInput(document.getElementById("evStart").value);
const end = fromLocalInput(document.getElementById("evEnd").value);

const startFormatted = formatAMPM(start);
const endFormatted = formatAMPM(end);

    const durationMinutes = (end - start) / 60000;
    const hours = (durationMinutes / 60).toFixed(1);

    const dateStr = start.toLocaleDateString(undefined, { weekday:"long", month:"short", day:"numeric" });
    const timeStr = start.toLocaleTimeString(undefined, { hour:"2-digit", minute:"2-digit" });

    const suggestion = `Discuss "${title}" on ${dateStr} at ${timeStr} for about ${hours} hours, covering key decisions, next steps, and responsibilities.`;
    aiSuggestionTextEl.textContent = suggestion;
    aiSuggestionEl.style.display = "none";
  }

  evTitleEl.addEventListener("input", updateAISuggestion);
  document.getElementById("evStart").addEventListener("change", updateAISuggestion);
  document.getElementById("evEnd").addEventListener("change", updateAISuggestion);

  btnUseSuggestion.addEventListener("click", () => {
    const current = evDescEl.value.trim();
    const suggestion = aiSuggestionTextEl.textContent;
    evDescEl.value = current ? current + "\n\n" + suggestion : suggestion;
  });

  document.getElementById("btnNewEvent").addEventListener("click", () => {
    recipients = [];
    renderRecipients();
    document.getElementById("eventForm").dataset.editId = "";
    document.getElementById("evTitle").value = "";
    document.getElementById("evDesc").value = "";
    document.getElementById("evStart").value = "";
    document.getElementById("evEnd").value = "";
    aiSuggestionEl.style.display = "none";
  });

  currentMonday = getMonday(new Date());
  switchView("week");




  // BBCode insertion
document.querySelectorAll(".bb-btn").forEach(btn => {
  btn.addEventListener("click", () => {
    const tag = btn.dataset.tag;
    const textarea = document.getElementById("evDesc");
    const start = textarea.selectionStart;
    const end = textarea.selectionEnd;
    const selected = textarea.value.substring(start, end);

    let wrapped = "";

    if (tag === "list") {
      wrapped = `[list]\n[*] ${selected}\n[/list]`;
    } else if (tag === "url") {
      wrapped = `[url]${selected}[/url]`;
    } else {
      wrapped = `[${tag}]${selected}[/${tag}]`;
    }

    textarea.value =
      textarea.value.substring(0, start) +
      wrapped +
      textarea.value.substring(end);
  });
});

// Duration buttons
document.querySelectorAll(".duration-btn").forEach(btn => {
  btn.addEventListener("click", () => {
    const min = parseInt(btn.dataset.min);
    const start = new Date(document.getElementById("evStart").value);
    const end = new Date(start.getTime() + min * 60000);
    document.getElementById("evEnd").value = end.toISOString().slice(0, 16);
    setBlockFromInputs();
  });
});
function setBlockFromInputs() {
  if (!evStart.value || !evEnd.value) return;

  const start = new Date(evStart.value);
  const end = new Date(evEnd.value);

  const startMinutes = start.getHours() * 60 + start.getMinutes();
  const endMinutes = end.getHours() * 60 + end.getMinutes();

  const topMinutes = startMinutes - START_HOUR * 60;
  const durationMinutes = endMinutes - startMinutes;

  const topPx = (topMinutes / SLOT_MINUTES) * SLOT_HEIGHT;
  const heightPx = (durationMinutes / SLOT_MINUTES) * SLOT_HEIGHT;

  block.style.top = topPx + "px";
  block.style.height = heightPx + "px";
}


document.querySelectorAll(".bb-btn").forEach(btn => {
  btn.addEventListener("click", () => {
    const cmd = btn.dataset.cmd;

    if (cmd === "createLink") {
      const url = prompt("Enter URL:");
      if (url) document.execCommand("createLink", false, url);
      return;
    }

    document.execCommand(cmd, false, null);
  });
});


document.addEventListener("DOMContentLoaded", () => {

  const timeline = document.getElementById("timeTimeline");
  const block = document.getElementById("timeBlock");
  const summary = document.getElementById("timeSummary");
  const evStart = document.getElementById("evStart");
  const evEnd = document.getElementById("evEnd");

 const SLOT_MINUTES = 60;   // each row = 1 hour
const SLOT_HEIGHT = 40;    // each row = 40px
const START_HOUR = 8;
const END_HOUR = 18;


  function buildSlots() {
    const totalSlots = ((END_HOUR - START_HOUR) * 60) / SLOT_MINUTES;
    for (let i = 0; i <= totalSlots; i++) {
      const slot = document.createElement("div");
      slot.className = "time-slot";

      const minutesFromStart = i * SLOT_MINUTES;
      const hour = START_HOUR + Math.floor(minutesFromStart / 60);
      const minute = minutesFromStart % 60;

      const label = document.createElement("div");
      label.className = "time-slot-label";
      label.textContent = minute === 0 ? `${String(hour).padStart(2,"0")}:00` : "";

      slot.appendChild(label);
      timeline.appendChild(slot);
    }
  }

  buildSlots();

  const roundToSlot = px => Math.round(px / SLOT_HEIGHT) * SLOT_HEIGHT;
  const minutesFromTop = px => (px / SLOT_HEIGHT) * SLOT_MINUTES;

  function setInputsFromBlock() {
    const rect = timeline.getBoundingClientRect();
    const blockRect = block.getBoundingClientRect();

    const topPx = blockRect.top - rect.top;
    const heightPx = blockRect.height;

    const startMinutes = minutesFromTop(topPx) + START_HOUR * 60;
    const endMinutes = startMinutes + minutesFromTop(heightPx);

    const base = new Date();
    base.setHours(0,0,0,0);

    const startDate = new Date(base);
    startDate.setMinutes(startMinutes);

    const endDate = new Date(base);
    endDate.setMinutes(endMinutes);

    const toLocal = d => {
      const off = d.getTimezoneOffset();
      return new Date(d.getTime() - off * 60000).toISOString().slice(0,16);
    };

    evStart.value = toLocal(startDate);
    evEnd.value = toLocal(endDate);

 summary.textContent =
  `${startDate.toLocaleTimeString([], { hour: "numeric", minute: "2-digit", hour12: true })} – ` +
  `${endDate.toLocaleTimeString([], { hour: "numeric", minute: "2-digit", hour12: true })}`;
    }

  function setBlockFromInputs() {
    if (!evStart.value || !evEnd.value) return;

    const start = new Date(evStart.value);
    const end = new Date(evEnd.value);

    const startMinutes = start.getHours() * 60 + start.getMinutes();
    const endMinutes = end.getHours() * 60 + end.getMinutes();

    const topMinutes = startMinutes - START_HOUR * 60;
    const durationMinutes = endMinutes - startMinutes;

    const topPx = (topMinutes / SLOT_MINUTES) * SLOT_HEIGHT;
    const heightPx = (durationMinutes / SLOT_MINUTES) * SLOT_HEIGHT;

    block.style.top = topPx + "px";
    block.style.height = heightPx + "px";
  }

  let dragMode = null;
  let startY = 0;
  let startTop = 0;
  let startHeight = 0;

  block.addEventListener("mousedown", e => {
    if (e.target.classList.contains("top-handle")) dragMode = "top";
    else if (e.target.classList.contains("bottom-handle")) dragMode = "bottom";
    else dragMode = "move";

    startY = e.clientY;

    const rect = block.getBoundingClientRect();
    const parentRect = timeline.getBoundingClientRect();

    startTop = rect.top - parentRect.top;
    startHeight = rect.height;

    document.addEventListener("mousemove", onMove);
    document.addEventListener("mouseup", onUp);
  });

  function onMove(e) {
    const dy = e.clientY - startY;

    if (dragMode === "move") {
      block.style.top = roundToSlot(startTop + dy) + "px";
    }

    if (dragMode === "top") {
      let newTop = roundToSlot(startTop + dy);
      let newHeight = startHeight + (startTop - newTop);
      block.style.top = newTop + "px";
      block.style.height = newHeight + "px";
    }

    if (dragMode === "bottom") {
      block.style.height = roundToSlot(startHeight + dy) + "px";
    }

    setInputsFromBlock();
  }
  function setInputsFromBlock() {
  const rect = timeline.getBoundingClientRect();
  const blockRect = block.getBoundingClientRect();

  const topPx = blockRect.top - rect.top;
  const heightPx = blockRect.height;

  const startMinutes = (topPx / SLOT_HEIGHT) * SLOT_MINUTES + START_HOUR * 60;
  const endMinutes = startMinutes + (heightPx / SLOT_HEIGHT) * SLOT_MINUTES;

  const base = new Date();
  base.setHours(0,0,0,0);

  const startDate = new Date(base);
  startDate.setMinutes(startMinutes);

  const endDate = new Date(base);
  endDate.setMinutes(endMinutes);

  const toLocal = d => {
    const off = d.getTimezoneOffset();
    return new Date(d.getTime() - off * 60000).toISOString().slice(0,16);
  };

  evStart.value = toLocal(startDate);
  evEnd.value = toLocal(endDate);

  summary.textContent =
    `${startDate.toLocaleTimeString([], {hour:"2-digit", minute:"2-digit"})} – ` +
    `${endDate.toLocaleTimeString([], {hour:"2-digit", minute:"2-digit"})}`;
}
function onMove(e) {
  const dy = e.clientY - startY;

  if (dragMode === "move") {
    block.style.top = roundToSlot(startTop + dy) + "px";
  }

  if (dragMode === "top") {
    let newTop = roundToSlot(startTop + dy);
    let newHeight = startHeight + (startTop - newTop);
    block.style.top = newTop + "px";
    block.style.height = newHeight + "px";
  }

  if (dragMode === "bottom") {
    block.style.height = roundToSlot(startHeight + dy) + "px";
  }

  setInputsFromBlock();
}



  function onUp() {
    dragMode = null;
    document.removeEventListener("mousemove", onMove);
    document.removeEventListener("mouseup", onUp);
  }

  evStart.addEventListener("change", setBlockFromInputs);
  evEnd.addEventListener("change", setBlockFromInputs);

});

function buildSlots() {
  for (let hour = 8; hour <= 18; hour++) {
    const slot = document.createElement("div");
    slot.className = "time-slot";

    const label = document.createElement("div");
    label.className = "time-slot-label";
    label.textContent = `${String(hour).padStart(2,"0")}:00`;

    slot.appendChild(label);
    timeline.appendChild(slot);
  }
}

function formatAMPM(date) {
  return date.toLocaleTimeString([], {
    hour: "numeric",
    minute: "2-digit",
    hour12: true
  });
}

document.getElementById("previewEvent").addEventListener("click", () => {

  const title = document.getElementById("evTitle").value;
  const descHTML = document.getElementById("evDesc").innerHTML;

  const start = fromLocalInput(document.getElementById("evStart").value);
  const end = fromLocalInput(document.getElementById("evEnd").value);

  const formatAMPM = d =>
    d.toLocaleTimeString([], { hour: "numeric", minute: "2-digit", hour12: true });

  document.getElementById("previewTitle").textContent = title;

  // FIXED: format recipients properly
  const previewList = (window.recipients || [])
    .map(r => `${r.name} (${r.email})`)
    .join(", ");

const toList = (window.recipients || [])
  .map(r => `${r.name} (${r.email})`)
  .join(", ");

const ccList = (window.ccList || [])
  .map(email => email)
  .join(", ");

const bccList = (window.bccList || [])
  .map(email => email)
  .join(", ");

// Build final preview text
let previewRecipientsText = "";

if (toList) previewRecipientsText += `To: ${toList}\n`;
if (ccList) previewRecipientsText += `CC: ${ccList}\n`;
if (bccList) previewRecipientsText += `BCC: ${bccList}`;

document.getElementById("previewRecipients").innerHTML = previewRecipientsText.replace(/\n/g, "<br>");



  document.getElementById("previewTime").textContent =
    `${formatAMPM(start)} – ${formatAMPM(end)}`;

  document.getElementById("previewDesc").innerHTML = descHTML;

  // Open modal
  const modal = new bootstrap.Modal(document.getElementById("previewModal"));
  modal.show();
});






document.getElementById("openRecipientsModal").addEventListener("click", () => {

  fetch("/recipients/shortlisted")
    .then(async res => {

      if (!res.ok) {
        // Try to extract real Laravel error message
        const text = await res.text();
        throw new Error(`Server error ${res.status}: ${text}`);
      }

      return res.json();
    })
    .then(users => {

      const container = document.getElementById("recipientsList");
      container.innerHTML = "";

users.forEach(u => {
  container.innerHTML += `
    <div class="form-check mb-2 recipient-item">
      <input class="form-check-input recipient-checkbox" 
             type="checkbox" 
             value="${u.email}" 
             data-name="${u.name}"
             id="rec_${u.id}">
      <label class="form-check-label" for="rec_${u.id}">
        ${u.name} <small class="text-muted">(${u.email})</small>
      </label>
    </div>
  `;
});

// Attach change listeners to each checkbox
document.querySelectorAll(".recipient-checkbox").forEach(cb => {
  cb.addEventListener("change", updateRecipientCount);
});

// Reset count on modal open
updateRecipientCount();



      new bootstrap.Modal(document.getElementById("recipientsModal")).show();
    })
    .catch(err => {
      console.error("Recipients fetch failed:", err);

      // Show the REAL error to the user
      alert("Error loading recipients:\n\n" + err.message);
    });

});

document.getElementById("applyRecipients").addEventListener("click", () => {

  const selected = [...document.querySelectorAll(".recipient-checkbox:checked")]
    .map(cb => ({
      id: cb.id,
      email: cb.value,
      name: cb.dataset.name
    }));

  window.recipients = selected;

  renderSelectedRecipients();

  bootstrap.Modal.getInstance(document.getElementById("recipientsModal")).hide();
});

function renderSelectedRecipients() {
  const container = document.getElementById("selectedRecipients");

  if (!window.recipients || window.recipients.length === 0) {
    container.innerHTML = "<em>No recipients selected</em>";
    return;
  }

  container.innerHTML = window.recipients.map(r => `
    <span class="recipient-chip">
      ${r.name} <small>(${r.email})</small>
      <button class="remove-recipient" data-email="${r.email}">&times;</button>
    </span>
  `).join("");

  // enable delete buttons
  container.querySelectorAll(".remove-recipient").forEach(btn => {
    btn.addEventListener("click", () => {
      const email = btn.dataset.email;

      // remove from selected list
      window.recipients = window.recipients.filter(r => r.email !== email);

      // uncheck in modal
      const checkbox = document.querySelector(`.recipient-checkbox[value="${email}"]`);
      if (checkbox) checkbox.checked = false;

      renderSelectedRecipients();
    });
  });
}

document.getElementById("recipientSearch").addEventListener("input", e => {
  const term = e.target.value.toLowerCase();

  document.querySelectorAll("#recipientsList .recipient-item").forEach(item => {
    const text = item.innerText.toLowerCase();
    item.style.display = text.includes(term) ? "" : "none";
  });
});

function updateRecipientCount() {
  const count = document.querySelectorAll(".recipient-checkbox:checked").length;
  document.getElementById("recipientCount").textContent = count;

  // Sync "Select All" checkbox
  const all = document.querySelectorAll(".recipient-checkbox").length;
  document.getElementById("checkAllRecipients").checked = (count === all && all > 0);
}




document.getElementById("insertTemplate").addEventListener("click", () => {
  const desc = document.getElementById("evDesc");

  const template = `
    <p>Dear <strong>[Applicant Name]</strong>,<i>(Leave this field blank the system will automatically populate it)</i></p>
    <p>Thank you for your interest in the <strong>Role Name</strong><i>(leave role name blank the system will automatically populate it)</i> role with <strong>[Company Name]</strong><i>(leave company name blank the system will automatically populate it)</i>. We’ve had the pleasure of reviewing your application, and we are impressed with your background and your clear passion for supporting others.</p>
    <p>We would like to invite you to an interview to discuss how your skills and values align with our team and the individuals we support. This will be a great opportunity for us to get to know you better and for you to learn more about the rewarding work we do here.</p>
   
    <p>Find below meeting link for the interview. Please do not hesitate to contact us if you have any questions or concerns.</p>
   <p><i>Meeting Link will be automatically generated by the system</i></p>
    <p>We look forward to meeting you and discussing how you can contribute to our mission of making a positive impact in the lives of those we support.</p>


   
   
    <p>Kind regards,<br>
    <strong>[Your Name]</strong><i>(leave this field blank the system will automatically populate it)</i><br>
    <strong>[Company Name]</strong><i>(leave this field blank the system will automatically populate it)</i>p>
  `;

  desc.innerHTML += template;
});


function insertHTMLAtCursor(html) {
  let sel, range;
  if (window.getSelection) {
    sel = window.getSelection();
    if (sel.getRangeAt && sel.rangeCount) {
      range = sel.getRangeAt(0);
      range.deleteContents();

      const el = document.createElement("div");
      el.innerHTML = html;

      const frag = document.createDocumentFragment();
      let node, lastNode;
      while ((node = el.firstChild)) {
        lastNode = frag.appendChild(node);
      }

      range.insertNode(frag);

      if (lastNode) {
        range = range.cloneRange();
        range.setStartAfter(lastNode);
        range.collapse(true);
        sel.removeAllRanges();
        sel.addRange(range);
      }
    }
  }
}



window.ccList = [];
window.bccList = [];

function setupChipInput(inputId, containerId, listRef) {
  const input = document.getElementById(inputId);
  const container = document.getElementById(containerId);

  input.addEventListener("keydown", e => {
    if (e.key === "Enter") {
      e.preventDefault();

      const email = input.value.trim();
      if (!email) return;

      // Add to array
      listRef.push(email);

      // Render chip
      renderChips(container, listRef);

      // Clear input
      input.value = "";
    }
  });
}

function renderChips(container, listRef) {
  container.innerHTML = listRef.map(email => `
    <span class="recipient-chip">
      ${email}
      <button data-email="${email}">&times;</button>
    </span>
  `).join("");

  // Delete chip
  container.querySelectorAll("button").forEach(btn => {
    btn.addEventListener("click", () => {
      const email = btn.dataset.email;
      const index = listRef.indexOf(email);
      if (index !== -1) listRef.splice(index, 1);
      renderChips(container, listRef);
    });
  });
}

// Initialize CC + BCC inputs
setupChipInput("ccInput", "selectedCC", window.ccList);
setupChipInput("bccInput", "selectedBCC", window.bccList);


document.getElementById("checkAllRecipients").addEventListener("change", e => {
  const checked = e.target.checked;

  document.querySelectorAll(".recipient-checkbox").forEach(cb => {
    cb.checked = checked;
  });

  updateRecipientCount();
});




//   closeand reopen calendar offcanvas
const eventCanvasEl = document.getElementById("eventOffcanvas");
const calendarCanvasEl = document.getElementById("calendarOffcanvas");

eventCanvasEl.addEventListener("hidden.bs.offcanvas", () => {
    // When event editor closes → reopen calendar
    const calendar = new bootstrap.Offcanvas(calendarCanvasEl);
    calendar.show();
});




// Send Event Email Notification 

document.getElementById("saveEvent").addEventListener("click", () => {

  const title = document.getElementById("evTitle").value.trim();
  const description = document.getElementById("evDesc").innerHTML.trim();

  const start = document.getElementById("evStart").value;
  const end = document.getElementById("evEnd").value;

  // Build payload
  const payload = {
    title: title,
    description: description,
    start: start,
    end: end,
    to: window.recipients || [],
    cc: window.ccList || [],
    bcc: window.bccList || []
  };

  // Store in sessionStorage
  sessionStorage.setItem("eventPayload", JSON.stringify(payload));

  console.log("Event payload saved:", payload);

  // Optional: show a toast or swal
  // swal("Saved!", "Event data stored in session.", "success");
});



document.getElementById("saveEvent").addEventListener("click", () => {
    const payload = JSON.parse(sessionStorage.getItem("eventPayload"));

    fetch("/send-event-emails", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify(payload)
    })
    .then(res => res.json())
    .then(data => {
        console.log("Emails sent:", data);
        // swal("Success", "Event emails sent!", "success");
    })
    .catch(err => console.error(err));
});





</script>

</body>
</html>
<?php /**PATH E:\CareerJobs\resources\views\layouts\admin\adminsidebar.blade.php ENDPATH**/ ?>