
<?php echo $__env->make('components.offcanvas', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->startSection('content'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

<style>
/* Layout */
.checkout-wrapper {
    display: flex;
    gap: 40px;
    align-items: flex-start;
    margin: 40px auto;
    max-width: 960px;
    font-family: 'Segoe UI', sans-serif;
}

/* Invoice */
.invoice-box {
    flex: 1;
    background: #fff;
    border: none;
    border-radius: 0;
    padding: 20px;
    font-size: 0.95rem;
    color: #333;
}

.invoice-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 15px;
    border-bottom: 1px solid #ccc;
    padding-bottom: 8px;
}

.logo {
    font-size: 1.2rem;
    font-weight: 700;
    color: #000;
    letter-spacing: 1px;
}

.company-info h2 {
    margin: 0;
    font-size: 1rem;
    font-weight: 600;
}

.company-info p {
    margin: 0;
    font-size: 0.85rem;
    color: #555;
}

.invoice-title {
    margin: 15px 0;
    font-size: 1.1rem;
    font-weight: 600;
    text-transform: uppercase;
    color: #444;
}

.invoice-box table {
    width: 100%;
    border-collapse: collapse;
}

.invoice-box table td {
    padding: 8px;
}

.invoice-box table .heading td {
    font-weight: 600;
    border-bottom: 1px solid #ccc;
    background: #f5f5f5;
}

.invoice-box table .item td {
    border-bottom: 1px solid #eee;
}

.invoice-box table .total td {
    font-weight: 700;
    border-top: 2px solid #000;
}

/* Payment form */
.payment-box {
    flex: 2;
}

#payment-form {
    margin: 0 auto;
}

#payment-form h2 {
    margin-bottom: 20px;
    font-size: 1.5rem;
    font-weight: 600;
    color: #333;
    text-align: center;
}

label {
    display: block;
    margin-bottom: 6px;
    font-weight: 500;
    color: #444;
    font-size: 0.95rem;
}

.input-field, #card-element {
    width: 100%;
    padding: 12px;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    margin-bottom: 16px;
    font-size: 1rem;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.input-field:focus, #card-element.StripeElement--focus {
    border-color: #6772e5;
    box-shadow: 0 0 0 3px rgba(103,114,229,0.2);
    outline: none;
}

button {
    background-color: rgb(113, 16, 62);
    color: #fff;
    border: none;
    padding: 12px;
    border-radius: 6px;
    cursor: pointer;
    width: 100%;
    font-size: 1rem;
    font-weight: 600;
    transition: background 0.3s, transform 0.1s;
}
.idsubmit {
    background-color: rgb(113, 16, 62);
    color: #fff;
    border: none;
    padding: 12px;
    border-radius: 6px;
    cursor: pointer;
    width: 100%;
    font-size: 1rem;
    font-weight: 600;
    transition: background 0.3s, transform 0.1s;
}

button:hover {
    background: linear-gradient(135deg, #5469d4, #22e305);
    transform: translateY(-1px);
}

#error-message {
    color: #e63946;
    margin-top: 12px;
    font-size: 0.9rem;
    text-align: center;
}
/* Simple inline spinner */
.spinner {
  border: 2px solid #f3f3f3;
  border-top: 2px solid #2e7d32; /* green */
  border-radius: 50%;
  width: 16px;
  height: 16px;
  animation: spin 0.8s linear infinite;
  display: inline-block;
  vertical-align: middle;
  margin-right: 8px;
}

@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}
/* Add this CSS to your styles */
.swal-popup-custom {
    border-radius: 15px; /* Rounded corners */
    padding: 20px; /* Padding inside the popup */
    box-shadow: 0 4px 30px rgba(0, 0, 0, 0.2); /* Soft shadow */
}

.swal-confirm-full {
    border-radius: 25px; /* Rounded confirm button */
    padding: 10px 20px; /* Padding for the button */
    font-weight: bold; /* Bold text for the button */
    transition: background-color 0.3s; /* Smooth transition */
}

.swal-confirm-full:hover {
    background-color: rgb(100, 15, 45); /* Darker shade on hover */
    width: 100%;
}

</style>

<div class="checkout-wrapper">
    <!-- Invoice Section -->
    <div class="invoice-box">
        <?php
            $jobFormData = json_decode(request('jobFormData'), true);
            // dump($jobFormData);
        ?>


        <div class="invoice-header">
            <div class="company-info">
                <h2><?php echo e($jobFormData['company'] ?? 'Company Name'); ?></h2>

            </div>
        </div>

        <h3 class="invoice-title">Invoice</h3>

        <table>
            <tr class="heading">
                <td>Item</td>
                <td>Price</td>
            </tr>
            <tr class="item">
                <td><?php echo e($jobFormData['adType'] ?? '—'); ?> Ad</td>
                <td>AUD $<?php echo e($jobFormData['adPrice'] ?? '—'); ?></td>
            </tr>
            <tr class="total">
                <td>Total Due</td>
                <td><strong>AUD $<?php echo e($jobFormData['adPrice'] ?? '—'); ?></strong></td>
            </tr>
        </table>
    </div>

    <!-- Payment Form Section -->
    <div class="payment-box">
        <form id="payment-form">
            <h2>Secure Checkout</h2>
            <div>
                <label for="cardholder-name">Cardholder Name</label>
                <input type="text" id="cardholder-name" class="input-field" placeholder="John Doe" required>
            </div>
            <div>
                <label for="card-element">Card Information</label>
                <div id="card-element"></div>
            </div>
            <button id="submit" class="idsubmit">Pay Securely</button>
            <div id="error-message"></div>
        </form>
    </div>
</div>

<script src="https://js.stripe.com/v3/"></script>
<script>
const stripe = Stripe('pk_test_51RlN3fRdXeSPt59V4Xjqhy4kyxqHvZ0IFifFRc1k829QVVbAeIKomP9FyM7QZqHQe1bm27rFRftdIFW0KkWsSXkP00NIM8r37F'); // publishable key
const elements = stripe.elements();
const cardElement = elements.create('card', { hidePostalCode: true });
const btn = document.getElementById('submit');
cardElement.mount('#card-element');

const form = document.getElementById('payment-form');
form.addEventListener('submit', async (event) => {
    event.preventDefault();

    // 🔹 Show spinner + "Processing payment..." inside button
    btn.disabled = true;
    btn.innerHTML = '<span class="spinner"></span> Processing payment...';

    const cardholderName = document.getElementById('cardholder-name').value;
    const { error, token } = await stripe.createToken(cardElement, { name: cardholderName });

    if (error) {
        btn.disabled = false;
        btn.innerHTML = 'Pay Securely';
        document.getElementById('error-message').textContent = error.message;
        Notiflix.Notify.failure(error.message);
        return;
    }

    // Step 1: send token to backend for payment
    const paymentRes = await fetch('/checkout/payment', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            token: token.id,
            amount: <?php echo e($jobFormData['adPrice'] ?? 0); ?>, // dynamic amount
            adType: "<?php echo e($jobFormData['adType'] ?? ''); ?>",
            company_id: "<?php echo e($jobFormData['company_id'] ?? ''); ?>",
            company: "<?php echo e($jobFormData['company'] ?? ''); ?>"
        })
    });

    const paymentData = await paymentRes.json();

    if (!paymentData.success) {
        btn.disabled = false;
        btn.innerHTML = 'Pay Securely';
        Notiflix.Notify.failure('Payment failed: ' + paymentData.error);
        return;
    }

    // ✅ Payment succeeded
    btn.disabled = false;
    btn.innerHTML = 'Pay Securely';

    Swal.fire({
        title: 'Payment Successful!',
        html: `
        <div style="text-align: left; font-family: Arial, sans-serif;">
            <p style="font-size: 16px; margin: 10px 0; color: #2e7d32;">
                <i class="fa fa-check" style="color: #2e7d32; margin-right: 6px;"></i>
                Receipt of payment has been sent to your email.
            </p>
            <p style="font-size: 16px; margin: 10px 0; color: #2e7d32;">
                <i class="fa fa-check" style="color: #2e7d32; margin-right: 6px;"></i>
                Ad posted successfully!
            </p>
            <h3 style="font-size: 16px; margin-top: 15px; color: #555;">
                Charge ID: <strong>${paymentData.charge_id}</strong>
            </h3>
        </div>
    `,
        allowOutsideClick: false,
        allowEscapeKey: false,
        showConfirmButton: true,
        confirmButtonText: 'OK',
        confirmButtonColor: 'rgb(113, 16, 62)',
        position: 'center',
        backdrop: 'rgba(113, 16, 62, 0.9)', // Dim background with wine color
        icon: 'success',
        customClass: {
            icon: 'no-border',
            confirmButton: 'swal-confirm-full',
            popup: 'swal-popup-custom'
        }
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = '/admin/home';
        }
    });



    // Step 2: merge jobFormData from sessionStorage
    const stored = sessionStorage.getItem('jobFormData');
    const mergedData = stored ? JSON.parse(stored) : {
        adType: "<?php echo e($jobFormData['adType'] ?? ''); ?>",
        company_id: "<?php echo e($jobFormData['company_id'] ?? ''); ?>",
        company: "<?php echo e($jobFormData['company'] ?? ''); ?>"
    };

    // Step 3: build payload with ad_rev_status = paid
    const payload = {
        company_id: mergedData.company_id || null,
        ad_type: mergedData.adType || null,
        category: mergedData.category || null,
        company: mergedData.company || null,
        description: mergedData.description || null,
        job_title: mergedData.jobTitle || null,
        location: mergedData.location || null,
        workplace: mergedData.workplace || null,
        work_type: mergedData.workType || null,
        pay_type: mergedData.payType || null,
        pay_min: mergedData.payMin || null,
        pay_max: mergedData.payMax || null,
        pay_visibility: mergedData.payVisibility === 'show',
        summary: mergedData.summary || null,
        logo: mergedData.logo || null,
        overview: mergedData.overview || null,
        social_media: mergedData.socialMedia || null,
        video: mergedData.video || null,
        questions: mergedData.questions || [],
        ad_rev_status: 'paid',
        status: 'active',
        expiry_date: new Date(new Date().setDate(new Date().getDate() + 30)).toISOString().split('T')[0], // 30 days from now
        ad_price: <?php echo e($jobFormData['adPrice'] ?? 0); ?>,
        ad_duration: '30',
        payment_intent_id: paymentData.charge_id || null

    };

    console.log('Payload to send:', payload);

    try {
        const res = await fetch('/create/jobboards', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify(payload)
        });

        const data = await res.json().catch(() => null);

        if (!res.ok) {
            Notiflix.Notify.failure('Request failed: ' + res.status);
            throw new Error('Request failed');
        }

        // Notiflix.Notify.success('Ad Posted Successfully!', {
        //     svgSize: '20px',
        //     fontSize: '14px'
        // });

        console.log('Saved job:', data);
    } catch (err) {
        Notiflix.Notify.failure('Fetch error: ' + err.message);
        console.error('Fetch error:', err);
    }
});
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.adminapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\CareerJobs\resources\views\EAdmin\checkout.blade.php ENDPATH**/ ?>