<?php //d43176431af406a5f41b710393aa45c4
/** @noinspection all */

namespace App\Models {

    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_AdsType_C;
    use LaravelIdea\Helper\App\Models\_IH_AdsType_QB;
    use LaravelIdea\Helper\App\Models\_IH_Company_C;
    use LaravelIdea\Helper\App\Models\_IH_Company_QB;
    use LaravelIdea\Helper\App\Models\_IH_JobBoard_C;
    use LaravelIdea\Helper\App\Models\_IH_JobBoard_QB;
    use LaravelIdea\Helper\App\Models\_IH_Job_C;
    use LaravelIdea\Helper\App\Models\_IH_Job_QB;
    use LaravelIdea\Helper\App\Models\_IH_Message_C;
    use LaravelIdea\Helper\App\Models\_IH_Message_QB;
    use LaravelIdea\Helper\App\Models\_IH_Transaction_C;
    use LaravelIdea\Helper\App\Models\_IH_Transaction_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;

    /**
     * @property int $id
     * @property string $name
     * @property float $amount
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_AdsType_QB onWriteConnection()
     * @method _IH_AdsType_QB newQuery()
     * @method static _IH_AdsType_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AdsType_QB query()
     * @method static _IH_AdsType_QB with(array|string $relations)
     * @method _IH_AdsType_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AdsType_C|AdsType[] all($columns = ['*'])
     * @mixin _IH_AdsType_QB
     */
    class AdsType extends Model {}

    /**
     * @property int $id
     * @property string $abn
     * @property string|null $name
     * @property string|null $status
     * @property string|null $type
     * @property string|null $state
     * @property string|null $postcode
     * @property string|null $c_uuid
     * @property int|null $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Company_QB onWriteConnection()
     * @method _IH_Company_QB newQuery()
     * @method static _IH_Company_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Company_QB query()
     * @method static _IH_Company_QB with(array|string $relations)
     * @method _IH_Company_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Company_C|Company[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks id,\App\Models\JobBoard,company_id
     * @mixin _IH_Company_QB
     */
    class Company extends Model {}

    /**
     * @property int $id
     * @property string $queue
     * @property string $payload
     * @property int $attempts
     * @property int|null $reserved_at
     * @property int $available_at
     * @property int $created_at
     * @method static _IH_Job_QB onWriteConnection()
     * @method _IH_Job_QB newQuery()
     * @method static _IH_Job_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Job_QB query()
     * @method static _IH_Job_QB with(array|string $relations)
     * @method _IH_Job_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Job_C|Job[] all($columns = ['*'])
     * @mixin _IH_Job_QB
     */
    class Job extends Model {}

    /**
     * @property int $id
     * @property int $company_id
     * @property string $ad_type
     * @property string $category
     * @property string $company
     * @property string|null $description
     * @property string $job_title
     * @property string $location
     * @property string $workplace
     * @property string $work_type
     * @property string $pay_type
     * @property float|null $pay_min
     * @property float|null $pay_max
     * @property bool $pay_visibility
     * @property string|null $summary
     * @property string|null $logo
     * @property string|null $overview
     * @property string|null $social_media
     * @property string|null $video
     * @property array $questions
     * @property string $ad_rev_status
     * @property string $status
     * @property Carbon|null $expiry_date
     * @property int|null $ad_price
     * @property string|null $ad_duration
     * @property string|null $payment_intent_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method BelongsTo|_IH_Company_QB company()
     * @method static _IH_JobBoard_QB onWriteConnection()
     * @method _IH_JobBoard_QB newQuery()
     * @method static _IH_JobBoard_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_JobBoard_QB query()
     * @method static _IH_JobBoard_QB with(array|string $relations)
     * @method _IH_JobBoard_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobBoard_C|JobBoard[] all($columns = ['*'])
     * @ownLinks company_id,\App\Models\Company,id
     * @foreignLinks id,\App\Models\Transaction,job_board_id
     * @mixin _IH_JobBoard_QB
     */
    class JobBoard extends Model {}

    /**
     * @property-read string $time attribute
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Message_QB onWriteConnection()
     * @method _IH_Message_QB newQuery()
     * @method static _IH_Message_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Message_QB query()
     * @method static _IH_Message_QB with(array|string $relations)
     * @method _IH_Message_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Message_C|Message[] all($columns = ['*'])
     * @mixin _IH_Message_QB
     */
    class Message extends Model {}

    /**
     * @property int $id
     * @property int $job_board_id
     * @property string $stripe_id
     * @property string $status
     * @property float $amount
     * @property array $response
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Transaction_QB onWriteConnection()
     * @method _IH_Transaction_QB newQuery()
     * @method static _IH_Transaction_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Transaction_QB query()
     * @method static _IH_Transaction_QB with(array|string $relations)
     * @method _IH_Transaction_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Transaction_C|Transaction[] all($columns = ['*'])
     * @ownLinks job_board_id,\App\Models\JobBoard,id
     * @mixin _IH_Transaction_QB
     */
    class Transaction extends Model {}

    /**
     * @property int $id
     * @property string $uuid
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property mixed $password
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $type
     * @property _IH_Company_C|Company[] $companies
     * @property-read int $companies_count
     * @method HasMany|_IH_Company_QB companies()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\Company,user_id
     * @mixin _IH_User_QB
     * @method static UserFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class User extends Model {}
}
