<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidEnterprise;

class EnrollmentToken extends \Google\Model
{
  /**
   * The value is unused.
   */
  public const ENROLLMENT_TOKEN_TYPE_enrollmentTokenTypeUnspecified = 'enrollmentTokenTypeUnspecified';
  /**
   * The enrollment token is for a userless device.
   */
  public const ENROLLMENT_TOKEN_TYPE_userlessDevice = 'userlessDevice';
  /**
   * The enrollment token is for a user device.
   */
  public const ENROLLMENT_TOKEN_TYPE_userDevice = 'userDevice';
  /**
   * [Optional] The length of time the enrollment token is valid, ranging from 1
   * minute to [`Durations.MAX_VALUE`](https://developers.google.com/protocol-bu
   * ffers/docs/reference/java/com/google/protobuf/util/Durations.html#MAX_VALUE
   * ), approximately 10,000 years. If not specified, the default duration is 1
   * hour.
   *
   * @var string
   */
  public $duration;
  /**
   * [Required] The type of the enrollment token.
   *
   * @var string
   */
  public $enrollmentTokenType;
  protected $googleAuthenticationOptionsType = EnrollmentTokenGoogleAuthenticationOptions::class;
  protected $googleAuthenticationOptionsDataType = '';
  /**
   * The token value that's passed to the device and authorizes the device to
   * enroll. This is a read-only field generated by the server.
   *
   * @var string
   */
  public $token;

  /**
   * [Optional] The length of time the enrollment token is valid, ranging from 1
   * minute to [`Durations.MAX_VALUE`](https://developers.google.com/protocol-bu
   * ffers/docs/reference/java/com/google/protobuf/util/Durations.html#MAX_VALUE
   * ), approximately 10,000 years. If not specified, the default duration is 1
   * hour.
   *
   * @param string $duration
   */
  public function setDuration($duration)
  {
    $this->duration = $duration;
  }
  /**
   * @return string
   */
  public function getDuration()
  {
    return $this->duration;
  }
  /**
   * [Required] The type of the enrollment token.
   *
   * Accepted values: enrollmentTokenTypeUnspecified, userlessDevice, userDevice
   *
   * @param self::ENROLLMENT_TOKEN_TYPE_* $enrollmentTokenType
   */
  public function setEnrollmentTokenType($enrollmentTokenType)
  {
    $this->enrollmentTokenType = $enrollmentTokenType;
  }
  /**
   * @return self::ENROLLMENT_TOKEN_TYPE_*
   */
  public function getEnrollmentTokenType()
  {
    return $this->enrollmentTokenType;
  }
  /**
   * [Optional] Provides options related to Google authentication during the
   * enrollment.
   *
   * @param EnrollmentTokenGoogleAuthenticationOptions $googleAuthenticationOptions
   */
  public function setGoogleAuthenticationOptions(EnrollmentTokenGoogleAuthenticationOptions $googleAuthenticationOptions)
  {
    $this->googleAuthenticationOptions = $googleAuthenticationOptions;
  }
  /**
   * @return EnrollmentTokenGoogleAuthenticationOptions
   */
  public function getGoogleAuthenticationOptions()
  {
    return $this->googleAuthenticationOptions;
  }
  /**
   * The token value that's passed to the device and authorizes the device to
   * enroll. This is a read-only field generated by the server.
   *
   * @param string $token
   */
  public function setToken($token)
  {
    $this->token = $token;
  }
  /**
   * @return string
   */
  public function getToken()
  {
    return $this->token;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(EnrollmentToken::class, 'Google_Service_AndroidEnterprise_EnrollmentToken');
