<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudTalentSolution;

class ClientEvent extends \Google\Model
{
  /**
   * Required. The timestamp of the event.
   *
   * @var string
   */
  public $createTime;
  /**
   * Required. A unique identifier, generated by the client application.
   *
   * @var string
   */
  public $eventId;
  /**
   * Notes about the event provided by recruiters or other users, for example,
   * feedback on why a job was bookmarked.
   *
   * @var string
   */
  public $eventNotes;
  protected $jobEventType = JobEvent::class;
  protected $jobEventDataType = '';
  /**
   * Strongly recommended for the best service experience. A unique ID generated
   * in the API responses. It can be found in ResponseMetadata.request_id.
   *
   * @var string
   */
  public $requestId;

  /**
   * Required. The timestamp of the event.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Required. A unique identifier, generated by the client application.
   *
   * @param string $eventId
   */
  public function setEventId($eventId)
  {
    $this->eventId = $eventId;
  }
  /**
   * @return string
   */
  public function getEventId()
  {
    return $this->eventId;
  }
  /**
   * Notes about the event provided by recruiters or other users, for example,
   * feedback on why a job was bookmarked.
   *
   * @param string $eventNotes
   */
  public function setEventNotes($eventNotes)
  {
    $this->eventNotes = $eventNotes;
  }
  /**
   * @return string
   */
  public function getEventNotes()
  {
    return $this->eventNotes;
  }
  /**
   * An event issued when a job seeker interacts with the application that
   * implements Cloud Talent Solution.
   *
   * @param JobEvent $jobEvent
   */
  public function setJobEvent(JobEvent $jobEvent)
  {
    $this->jobEvent = $jobEvent;
  }
  /**
   * @return JobEvent
   */
  public function getJobEvent()
  {
    return $this->jobEvent;
  }
  /**
   * Strongly recommended for the best service experience. A unique ID generated
   * in the API responses. It can be found in ResponseMetadata.request_id.
   *
   * @param string $requestId
   */
  public function setRequestId($requestId)
  {
    $this->requestId = $requestId;
  }
  /**
   * @return string
   */
  public function getRequestId()
  {
    return $this->requestId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ClientEvent::class, 'Google_Service_CloudTalentSolution_ClientEvent');
