<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Docs;

class SheetsChartReference extends \Google\Model
{
  /**
   * The ID of the specific chart in the Google Sheets spreadsheet that's
   * embedded.
   *
   * @var int
   */
  public $chartId;
  /**
   * The ID of the Google Sheets spreadsheet that contains the source chart.
   *
   * @var string
   */
  public $spreadsheetId;

  /**
   * The ID of the specific chart in the Google Sheets spreadsheet that's
   * embedded.
   *
   * @param int $chartId
   */
  public function setChartId($chartId)
  {
    $this->chartId = $chartId;
  }
  /**
   * @return int
   */
  public function getChartId()
  {
    return $this->chartId;
  }
  /**
   * The ID of the Google Sheets spreadsheet that contains the source chart.
   *
   * @param string $spreadsheetId
   */
  public function setSpreadsheetId($spreadsheetId)
  {
    $this->spreadsheetId = $spreadsheetId;
  }
  /**
   * @return string
   */
  public function getSpreadsheetId()
  {
    return $this->spreadsheetId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SheetsChartReference::class, 'Google_Service_Docs_SheetsChartReference');
